/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Collect;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Match;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sample;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalWindow;
import org.apache.calcite.rel.mutable.MutableAggregate;
import org.apache.calcite.rel.mutable.MutableCalc;
import org.apache.calcite.rel.mutable.MutableCollect;
import org.apache.calcite.rel.mutable.MutableCorrelate;
import org.apache.calcite.rel.mutable.MutableExchange;
import org.apache.calcite.rel.mutable.MutableFilter;
import org.apache.calcite.rel.mutable.MutableIntersect;
import org.apache.calcite.rel.mutable.MutableJoin;
import org.apache.calcite.rel.mutable.MutableLeafRel;
import org.apache.calcite.rel.mutable.MutableMatch;
import org.apache.calcite.rel.mutable.MutableMinus;
import org.apache.calcite.rel.mutable.MutableProject;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelVisitor;
import org.apache.calcite.rel.mutable.MutableSample;
import org.apache.calcite.rel.mutable.MutableScan;
import org.apache.calcite.rel.mutable.MutableSort;
import org.apache.calcite.rel.mutable.MutableTableFunctionScan;
import org.apache.calcite.rel.mutable.MutableTableModify;
import org.apache.calcite.rel.mutable.MutableUncollect;
import org.apache.calcite.rel.mutable.MutableUnion;
import org.apache.calcite.rel.mutable.MutableValues;
import org.apache.calcite.rel.mutable.MutableWindow;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class MutableRels {
    public static boolean contains(MutableRel ancestor, final MutableRel target) {
        if (ancestor.equals(target)) {
            return true;
        }
        try {
            new MutableRelVisitor(){

                @Override
                public void visit(@Nullable MutableRel node) {
                    if (Objects.equals(node, target)) {
                        throw Util.FoundOne.NULL;
                    }
                    super.visit(node);
                }
            }.go(ancestor);
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    public static @Nullable MutableRel preOrderTraverseNext(MutableRel node) {
        MutableRel parent = node.getParent();
        int ordinal = node.ordinalInParent + 1;
        while (parent != null) {
            if (parent.getInputs().size() > ordinal) {
                return parent.getInputs().get(ordinal);
            }
            node = parent;
            parent = node.getParent();
            ordinal = node.ordinalInParent + 1;
        }
        return null;
    }

    public static List<MutableRel> descendants(MutableRel query) {
        ArrayList<MutableRel> list = new ArrayList<MutableRel>();
        MutableRels.descendantsRecurse(list, query);
        return list;
    }

    private static void descendantsRecurse(List<MutableRel> list, MutableRel rel) {
        list.add(rel);
        for (MutableRel input : rel.getInputs()) {
            MutableRels.descendantsRecurse(list, input);
        }
    }

    public static MutableRel strip(MutableProject project) {
        return MutableRels.isTrivial(project) ? project.getInput() : project;
    }

    public static boolean isTrivial(MutableProject project) {
        MutableRel child = project.getInput();
        return RexUtil.isIdentity(project.projects, child.rowType);
    }

    public static MutableRel createProject(MutableRel child, final List<Integer> posList) {
        final RelDataType rowType = child.rowType;
        if (Mappings.isIdentity(posList, rowType.getFieldCount())) {
            return child;
        }
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, rowType.getFieldCount(), posList.size());
        for (int i = 0; i < posList.size(); ++i) {
            mapping.set(posList.get(i), i);
        }
        return MutableProject.of(RelOptUtil.permute(child.cluster.getTypeFactory(), rowType, mapping), child, (List<RexNode>)new AbstractList<RexNode>(){

            @Override
            public int size() {
                return posList.size();
            }

            @Override
            public RexNode get(int index) {
                int pos = (Integer)posList.get(index);
                return RexInputRef.of(pos, rowType);
            }
        });
    }

    public static List<RexNode> createProjectExprs(MutableRel child, List<Integer> posList) {
        return posList.stream().map(pos -> RexInputRef.of((int)pos, child.rowType)).collect(Collectors.toList());
    }

    public static List<RexNode> createProjects(MutableRel child, List<RexNode> projects) {
        ArrayList<RexNode> rexNodeList = new ArrayList<RexNode>(projects.size());
        for (RexNode project : projects) {
            if (project instanceof RexInputRef) {
                RexInputRef rexInputRef = (RexInputRef)project;
                rexNodeList.add(RexInputRef.of(rexInputRef.getIndex(), child.rowType));
                continue;
            }
            rexNodeList.add(project);
        }
        return rexNodeList;
    }

    public static MutableRel createCastRel(MutableRel rel, RelDataType castRowType, boolean rename) {
        RelDataType rowType = rel.rowType;
        if (RelOptUtil.areRowTypesEqual(rowType, castRowType, rename)) {
            return rel;
        }
        List<RexNode> castExps = RexUtil.generateCastExpressions(rel.cluster.getRexBuilder(), castRowType, rowType);
        List<String> fieldNames = rename ? castRowType.getFieldNames() : rowType.getFieldNames();
        return MutableProject.of(rel, castExps, fieldNames);
    }

    public static RelNode fromMutable(MutableRel node) {
        return MutableRels.fromMutable(node, RelFactories.LOGICAL_BUILDER.create(node.cluster, null));
    }

    public static RelNode fromMutable(MutableRel node, RelBuilder relBuilder) {
        switch (node.type) {
            case TABLE_SCAN: 
            case VALUES: {
                return ((MutableLeafRel)node).rel;
            }
            case PROJECT: {
                MutableProject project = (MutableProject)node;
                relBuilder.push(MutableRels.fromMutable(project.input, relBuilder));
                relBuilder.project(project.projects, project.rowType.getFieldNames(), true);
                return relBuilder.build();
            }
            case FILTER: {
                MutableFilter filter = (MutableFilter)node;
                relBuilder.push(MutableRels.fromMutable(filter.input, relBuilder));
                relBuilder.filter(filter.condition);
                return relBuilder.build();
            }
            case AGGREGATE: {
                MutableAggregate aggregate = (MutableAggregate)node;
                relBuilder.push(MutableRels.fromMutable(aggregate.input, relBuilder));
                relBuilder.aggregate(relBuilder.groupKey(aggregate.groupSet, (Iterable<? extends ImmutableBitSet>)aggregate.groupSets), aggregate.aggCalls);
                return relBuilder.build();
            }
            case SORT: {
                MutableSort sort = (MutableSort)node;
                return LogicalSort.create(MutableRels.fromMutable(sort.input, relBuilder), sort.collation, sort.offset, sort.fetch);
            }
            case CALC: {
                MutableCalc calc = (MutableCalc)node;
                return LogicalCalc.create(MutableRels.fromMutable(calc.input, relBuilder), calc.program);
            }
            case EXCHANGE: {
                MutableExchange exchange = (MutableExchange)node;
                return LogicalExchange.create(MutableRels.fromMutable(exchange.getInput(), relBuilder), exchange.distribution);
            }
            case COLLECT: {
                MutableCollect collect = (MutableCollect)node;
                RelNode child = MutableRels.fromMutable(collect.getInput(), relBuilder);
                return Collect.create(child, collect.rowType);
            }
            case UNCOLLECT: {
                MutableUncollect uncollect = (MutableUncollect)node;
                RelNode child = MutableRels.fromMutable(uncollect.getInput(), relBuilder);
                return Uncollect.create(child.getTraitSet(), child, uncollect.withOrdinality, Collections.emptyList());
            }
            case WINDOW: {
                MutableWindow window = (MutableWindow)node;
                RelNode child = MutableRels.fromMutable(window.getInput(), relBuilder);
                return LogicalWindow.create(child.getTraitSet(), child, window.constants, window.rowType, window.groups);
            }
            case MATCH: {
                MutableMatch match = (MutableMatch)node;
                RelNode child = MutableRels.fromMutable(match.getInput(), relBuilder);
                return LogicalMatch.create(child, match.rowType, match.pattern, match.strictStart, match.strictEnd, match.patternDefinitions, match.measures, match.after, match.subsets, match.allRows, match.partitionKeys, match.orderKeys, match.interval);
            }
            case TABLE_MODIFY: {
                MutableTableModify modify = (MutableTableModify)node;
                return LogicalTableModify.create(modify.table, modify.catalogReader, MutableRels.fromMutable(modify.getInput(), relBuilder), modify.operation, modify.updateColumnList, modify.sourceExpressionList, modify.flattened);
            }
            case SAMPLE: {
                MutableSample sample = (MutableSample)node;
                return new Sample(sample.cluster, MutableRels.fromMutable(sample.getInput(), relBuilder), sample.params);
            }
            case TABLE_FUNCTION_SCAN: {
                MutableTableFunctionScan tableFunctionScan = (MutableTableFunctionScan)node;
                return LogicalTableFunctionScan.create(tableFunctionScan.cluster, MutableRels.fromMutables(tableFunctionScan.getInputs(), relBuilder), tableFunctionScan.rexCall, tableFunctionScan.elementType, tableFunctionScan.rowType, tableFunctionScan.columnMappings);
            }
            case JOIN: {
                MutableJoin join = (MutableJoin)node;
                relBuilder.push(MutableRels.fromMutable(join.getLeft(), relBuilder));
                relBuilder.push(MutableRels.fromMutable(join.getRight(), relBuilder));
                relBuilder.join(join.joinType, join.condition, join.variablesSet);
                return relBuilder.build();
            }
            case CORRELATE: {
                MutableCorrelate correlate = (MutableCorrelate)node;
                return LogicalCorrelate.create(MutableRels.fromMutable(correlate.getLeft(), relBuilder), MutableRels.fromMutable(correlate.getRight(), relBuilder), (List<RelHint>)ImmutableList.of(), correlate.correlationId, correlate.requiredColumns, correlate.joinType);
            }
            case UNION: {
                MutableUnion union = (MutableUnion)node;
                relBuilder.pushAll(MutableRels.fromMutables(union.inputs, relBuilder));
                relBuilder.union(union.all, union.inputs.size());
                return relBuilder.build();
            }
            case MINUS: {
                MutableMinus minus = (MutableMinus)node;
                relBuilder.pushAll(MutableRels.fromMutables(minus.inputs, relBuilder));
                relBuilder.minus(minus.all, minus.inputs.size());
                return relBuilder.build();
            }
            case INTERSECT: {
                MutableIntersect intersect = (MutableIntersect)node;
                relBuilder.pushAll(MutableRels.fromMutables(intersect.inputs, relBuilder));
                relBuilder.intersect(intersect.all, intersect.inputs.size());
                return relBuilder.build();
            }
        }
        throw new AssertionError((Object)node.deep());
    }

    private static List<RelNode> fromMutables(List<MutableRel> nodes, RelBuilder relBuilder) {
        return Util.transform(nodes, mutableRel -> MutableRels.fromMutable(mutableRel, relBuilder));
    }

    public static MutableRel toMutable(RelNode rel) {
        if (rel instanceof HepRelVertex) {
            return MutableRels.toMutable(((HepRelVertex)rel).getCurrentRel());
        }
        if (rel instanceof RelSubset) {
            RelSubset subset = (RelSubset)rel;
            RelNode best = subset.getBest();
            if (best == null) {
                best = Objects.requireNonNull(subset.getOriginal(), () -> "subset.getOriginal() is null for " + subset);
            }
            return MutableRels.toMutable(best);
        }
        if (rel instanceof TableScan) {
            return MutableScan.of((TableScan)rel);
        }
        if (rel instanceof Values) {
            return MutableValues.of((Values)rel);
        }
        if (rel instanceof Project) {
            Project project = (Project)rel;
            MutableRel input = MutableRels.toMutable(project.getInput());
            return MutableProject.of(input, project.getProjects(), project.getRowType().getFieldNames());
        }
        if (rel instanceof Filter) {
            Filter filter = (Filter)rel;
            MutableRel input = MutableRels.toMutable(filter.getInput());
            return MutableFilter.of(input, filter.getCondition());
        }
        if (rel instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)rel;
            MutableRel input = MutableRels.toMutable(aggregate.getInput());
            return MutableAggregate.of(input, aggregate.getGroupSet(), aggregate.getGroupSets(), aggregate.getAggCallList());
        }
        if (rel instanceof Sort) {
            Sort sort = (Sort)rel;
            MutableRel input = MutableRels.toMutable(sort.getInput());
            return MutableSort.of(input, sort.getCollation(), sort.offset, sort.fetch);
        }
        if (rel instanceof Calc) {
            Calc calc = (Calc)rel;
            MutableRel input = MutableRels.toMutable(calc.getInput());
            return MutableCalc.of(input, calc.getProgram());
        }
        if (rel instanceof Exchange) {
            Exchange exchange = (Exchange)rel;
            MutableRel input = MutableRels.toMutable(exchange.getInput());
            return MutableExchange.of(input, exchange.getDistribution());
        }
        if (rel instanceof Collect) {
            Collect collect = (Collect)rel;
            MutableRel input = MutableRels.toMutable(collect.getInput());
            return MutableCollect.of(collect.getRowType(), input, collect.getFieldName());
        }
        if (rel instanceof Uncollect) {
            Uncollect uncollect = (Uncollect)rel;
            MutableRel input = MutableRels.toMutable(uncollect.getInput());
            return MutableUncollect.of(uncollect.getRowType(), input, uncollect.withOrdinality);
        }
        if (rel instanceof Window) {
            Window window = (Window)rel;
            MutableRel input = MutableRels.toMutable(window.getInput());
            return MutableWindow.of(window.getRowType(), input, window.groups, window.getConstants());
        }
        if (rel instanceof Match) {
            Match match = (Match)rel;
            MutableRel input = MutableRels.toMutable(match.getInput());
            return MutableMatch.of(match.getRowType(), input, match.getPattern(), match.isStrictStart(), match.isStrictEnd(), match.getPatternDefinitions(), match.getMeasures(), match.getAfter(), match.getSubsets(), match.isAllRows(), match.getPartitionKeys(), match.getOrderKeys(), match.getInterval());
        }
        if (rel instanceof TableModify) {
            TableModify modify = (TableModify)rel;
            MutableRel input = MutableRels.toMutable(modify.getInput());
            return MutableTableModify.of(modify.getRowType(), input, modify.getTable(), modify.getCatalogReader(), modify.getOperation(), modify.getUpdateColumnList(), modify.getSourceExpressionList(), modify.isFlattened());
        }
        if (rel instanceof Sample) {
            Sample sample = (Sample)rel;
            MutableRel input = MutableRels.toMutable(sample.getInput());
            return MutableSample.of(input, sample.getSamplingParameters());
        }
        if (rel instanceof TableFunctionScan) {
            TableFunctionScan tableFunctionScan = (TableFunctionScan)rel;
            List<MutableRel> inputs = MutableRels.toMutables(tableFunctionScan.getInputs());
            return MutableTableFunctionScan.of(tableFunctionScan.getCluster(), tableFunctionScan.getRowType(), inputs, tableFunctionScan.getCall(), tableFunctionScan.getElementType(), tableFunctionScan.getColumnMappings());
        }
        if (rel instanceof Join) {
            Join join = (Join)rel;
            MutableRel left = MutableRels.toMutable(join.getLeft());
            MutableRel right = MutableRels.toMutable(join.getRight());
            return MutableJoin.of(join.getRowType(), left, right, join.getCondition(), join.getJoinType(), join.getVariablesSet());
        }
        if (rel instanceof Correlate) {
            Correlate correlate = (Correlate)rel;
            MutableRel left = MutableRels.toMutable(correlate.getLeft());
            MutableRel right = MutableRels.toMutable(correlate.getRight());
            return MutableCorrelate.of(correlate.getRowType(), left, right, correlate.getCorrelationId(), correlate.getRequiredColumns(), correlate.getJoinType());
        }
        if (rel instanceof Union) {
            Union union = (Union)rel;
            List<MutableRel> inputs = MutableRels.toMutables(union.getInputs());
            return MutableUnion.of(union.getRowType(), inputs, union.all);
        }
        if (rel instanceof Minus) {
            Minus minus = (Minus)rel;
            List<MutableRel> inputs = MutableRels.toMutables(minus.getInputs());
            return MutableMinus.of(minus.getRowType(), inputs, minus.all);
        }
        if (rel instanceof Intersect) {
            Intersect intersect = (Intersect)rel;
            List<MutableRel> inputs = MutableRels.toMutables(intersect.getInputs());
            return MutableIntersect.of(intersect.getRowType(), inputs, intersect.all);
        }
        throw new RuntimeException("cannot translate " + rel + " to MutableRel");
    }

    private static List<MutableRel> toMutables(List<RelNode> nodes) {
        return nodes.stream().map(MutableRels::toMutable).collect(Collectors.toList());
    }
}

