/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.ResetLearnersRequestBuilder;

public class ResetLearnersRequestImpl
implements CliRequests.ResetLearnersRequest {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1015;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String leaderId;
    @IgniteToStringInclude
    private final Collection<String> learnersList;

    private ResetLearnersRequestImpl(String groupId, String leaderId, Collection<String> learnersList) {
        this.groupId = groupId;
        this.leaderId = leaderId;
        this.learnersList = learnersList;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String leaderId() {
        return this.leaderId;
    }

    @Override
    public Collection<String> learnersList() {
        return this.learnersList;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(ResetLearnersRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 1015;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResetLearnersRequestImpl otherMessage = (ResetLearnersRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.leaderId, otherMessage.leaderId) && Objects.equals(this.learnersList, otherMessage.learnersList);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId, this.leaderId, this.learnersList);
        return result;
    }

    public static ResetLearnersRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ResetLearnersRequestBuilder {
        private String groupId;
        private String leaderId;
        private Collection<String> learnersList;

        private Builder() {
        }

        @Override
        public ResetLearnersRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public ResetLearnersRequestBuilder leaderId(String leaderId) {
            this.leaderId = leaderId;
            return this;
        }

        @Override
        public ResetLearnersRequestBuilder learnersList(Collection<String> learnersList) {
            this.learnersList = learnersList;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String leaderId() {
            return this.leaderId;
        }

        @Override
        public Collection<String> learnersList() {
            return this.learnersList;
        }

        @Override
        public CliRequests.ResetLearnersRequest build() {
            return new ResetLearnersRequestImpl(this.groupId, this.leaderId, this.learnersList);
        }
    }
}

