/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.tree;

import java.util.Arrays;
import org.apache.ignite.internal.pagememory.CorruptedDataStructureException;
import org.apache.ignite.lang.IgniteStringBuilder;
import org.jetbrains.annotations.Nullable;

public class CorruptedTreeException
extends CorruptedDataStructureException {
    private static final long serialVersionUID = 0L;

    public CorruptedTreeException(String msg, @Nullable Throwable cause, String grpName, int grpId, long ... pageIds) {
        this(msg, null, grpName, cause, grpId, pageIds);
    }

    public CorruptedTreeException(String msg, @Nullable Throwable cause, String grpName, String indexName, int grpId, long ... pageIds) {
        this(msg, indexName, grpName, cause, grpId, pageIds);
    }

    public CorruptedTreeException(String msg, String indexName, String grpName, @Nullable Throwable cause, int grpId, long ... pageIds) {
        super(CorruptedTreeException.getMsg(msg, indexName, grpName, grpId, pageIds), cause, grpId, pageIds);
    }

    private static String getMsg(String msg, @Nullable String indexName, @Nullable String grpName, int grpId, long ... pageIds) {
        IgniteStringBuilder sb = new IgniteStringBuilder("B+Tree is corrupted [groupId=");
        sb.app(grpId).app(", pageIds=").app(Arrays.toString(pageIds));
        if (indexName != null) {
            sb.app(", indexName=").app(indexName);
        }
        if (grpName != null) {
            sb.app(", groupName=").app(grpName);
        }
        sb.app(", msg=").app(msg).app(']');
        return sb.toString();
    }
}

