/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BooleanSupplier;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PageStoreWriter;
import org.apache.ignite.internal.pagememory.persistence.PartitionMeta;
import org.apache.ignite.internal.pagememory.persistence.PartitionMetaManager;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.WriteDirtyPage;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointMetricsTracker;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.pagememory.persistence.io.PartitionMetaIo;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.util.IgniteConcurrentMultiPairQueue;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public class CheckpointPagesWriter
implements Runnable {
    private final IgniteLogger log;
    private final CheckpointMetricsTracker tracker;
    private final IgniteConcurrentMultiPairQueue<PersistentPageMemory, FullPageId> writePageIds;
    private final ConcurrentMap<GroupPartitionId, LongAdder> updatedPartitions;
    private final CompletableFuture<?> doneFut;
    private final Runnable updateHeartbeat;
    private final ThreadLocal<ByteBuffer> threadBuf;
    private final CheckpointProgressImpl checkpointProgress;
    private final WriteDirtyPage pageWriter;
    private final PageIoRegistry ioRegistry;
    private final PartitionMetaManager partitionMetaManager;
    private final BooleanSupplier shutdownNow;

    CheckpointPagesWriter(IgniteLogger log, CheckpointMetricsTracker tracker, IgniteConcurrentMultiPairQueue<PersistentPageMemory, FullPageId> writePageIds, ConcurrentMap<GroupPartitionId, LongAdder> updatedPartitions, CompletableFuture<?> doneFut, Runnable updateHeartbeat, ThreadLocal<ByteBuffer> threadBuf, CheckpointProgressImpl checkpointProgress, WriteDirtyPage pageWriter, PageIoRegistry ioRegistry, PartitionMetaManager partitionMetaManager, BooleanSupplier shutdownNow) {
        this.log = log;
        this.tracker = tracker;
        this.writePageIds = writePageIds;
        this.updatedPartitions = updatedPartitions;
        this.doneFut = doneFut;
        this.updateHeartbeat = updateHeartbeat;
        this.threadBuf = threadBuf;
        this.checkpointProgress = checkpointProgress;
        this.pageWriter = pageWriter;
        this.ioRegistry = ioRegistry;
        this.partitionMetaManager = partitionMetaManager;
        this.shutdownNow = shutdownNow;
    }

    @Override
    public void run() {
        try {
            IgniteConcurrentMultiPairQueue<PersistentPageMemory, FullPageId> pageIdsToRetry = this.writePages(this.writePageIds);
            while (!pageIdsToRetry.isEmpty()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Checkpoint pages were not written yet due to unsuccessful page write lock acquisition and will be retried [pageCount={}]", new Object[]{pageIdsToRetry.size()});
                }
                pageIdsToRetry = this.writePages(pageIdsToRetry);
            }
            this.doneFut.complete(null);
        }
        catch (Throwable e) {
            this.doneFut.completeExceptionally(e);
        }
    }

    private IgniteConcurrentMultiPairQueue<PersistentPageMemory, FullPageId> writePages(IgniteConcurrentMultiPairQueue<PersistentPageMemory, FullPageId> writePageIds) throws IgniteInternalCheckedException {
        HashMap pageIdsToRetry = new HashMap();
        HashMap<PersistentPageMemory, PageStoreWriter> pageStoreWriters = new HashMap<PersistentPageMemory, PageStoreWriter>();
        ByteBuffer tmpWriteBuf = this.threadBuf.get();
        IgniteConcurrentMultiPairQueue.Result queueResult = new IgniteConcurrentMultiPairQueue.Result();
        GroupPartitionId partitionId = null;
        AtomicBoolean writeMetaPage = new AtomicBoolean();
        while (!this.shutdownNow.getAsBoolean() && writePageIds.next(queueResult)) {
            this.updateHeartbeat.run();
            FullPageId fullId = (FullPageId)queueResult.getValue();
            PersistentPageMemory pageMemory = (PersistentPageMemory)queueResult.getKey();
            if (CheckpointPagesWriter.hasPartitionChanged(partitionId, fullId)) {
                partitionId = CheckpointPagesWriter.toPartitionId(fullId);
                this.updatedPartitions.computeIfAbsent(partitionId, partId -> {
                    writeMetaPage.set(true);
                    return new LongAdder();
                });
                if (writeMetaPage.get()) {
                    this.writePartitionMeta(pageMemory, partitionId, tmpWriteBuf.rewind());
                    writeMetaPage.set(false);
                }
            }
            tmpWriteBuf.rewind();
            PageStoreWriter pageStoreWriter = pageStoreWriters.computeIfAbsent(pageMemory, pm -> this.createPageStoreWriter((PersistentPageMemory)pm, pageIdsToRetry));
            pageMemory.checkpointWritePage(fullId, tmpWriteBuf, pageStoreWriter, this.tracker);
        }
        return pageIdsToRetry.isEmpty() ? IgniteConcurrentMultiPairQueue.EMPTY : new IgniteConcurrentMultiPairQueue(pageIdsToRetry);
    }

    private PageStoreWriter createPageStoreWriter(final PersistentPageMemory pageMemory, final Map<PersistentPageMemory, List<FullPageId>> pagesToRetry) {
        return new PageStoreWriter(){

            @Override
            public void writePage(FullPageId fullPageId, ByteBuffer buf, int tag) throws IgniteInternalCheckedException {
                if (tag == -1) {
                    pagesToRetry.computeIfAbsent(pageMemory, k -> new ArrayList()).add(fullPageId);
                    return;
                }
                long pageId = fullPageId.pageId();
                assert (PageIo.getType(buf) != 0) : "Invalid state. Type is 0! pageId = " + IgniteUtils.hexLong((long)pageId);
                assert (PageIo.getVersion(buf) != 0) : "Invalid state. Version is 0! pageId = " + IgniteUtils.hexLong((long)pageId);
                assert (fullPageId.pageIdx() != 0) : "Invalid pageIdx. Index is 0! pageId = " + IgniteUtils.hexLong((long)pageId);
                assert (!(CheckpointPagesWriter.this.ioRegistry.resolve(buf) instanceof PartitionMetaIo)) : "Invalid IO type. pageId = " + IgniteUtils.hexLong((long)pageId);
                if (PageIdUtils.flag(pageId) == 1) {
                    CheckpointPagesWriter.this.tracker.onDataPageWritten();
                }
                CheckpointPagesWriter.this.checkpointProgress.writtenPagesCounter().incrementAndGet();
                CheckpointPagesWriter.this.pageWriter.write(pageMemory, fullPageId, buf);
                ((LongAdder)CheckpointPagesWriter.this.updatedPartitions.get(CheckpointPagesWriter.toPartitionId(fullPageId))).increment();
            }
        };
    }

    private void writePartitionMeta(PersistentPageMemory pageMemory, GroupPartitionId partitionId, ByteBuffer buffer) throws IgniteInternalCheckedException {
        PartitionMeta.PartitionMetaSnapshot partitionMetaSnapshot = this.partitionMetaManager.getMeta(partitionId).metaSnapshot(this.checkpointProgress.id());
        this.partitionMetaManager.writeMetaToBuffer(partitionId, partitionMetaSnapshot, buffer.rewind());
        FullPageId fullPageId = new FullPageId(PartitionMeta.partitionMetaPageId(partitionId.getPartitionId()), partitionId.getGroupId());
        this.pageWriter.write(pageMemory, fullPageId, buffer.rewind());
        this.checkpointProgress.writtenPagesCounter().incrementAndGet();
        ((LongAdder)this.updatedPartitions.get(partitionId)).increment();
    }

    private static boolean hasPartitionChanged(@Nullable GroupPartitionId partitionId, FullPageId pageId) {
        return partitionId == null || partitionId.getPartitionId() != pageId.partitionId() || partitionId.getGroupId() != pageId.groupId();
    }

    private static GroupPartitionId toPartitionId(FullPageId pageId) {
        return new GroupPartitionId(pageId.groupId(), pageId.partitionId());
    }
}

