/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.MarshallerException;
import org.apache.ignite.internal.schema.marshaller.TupleMarshallerException;
import org.apache.ignite.internal.schema.marshaller.TupleMarshallerImpl;
import org.apache.ignite.internal.schema.marshaller.reflection.KvMarshallerImpl;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.KeyValueBinaryViewImpl;
import org.apache.ignite.internal.table.KeyValueViewImpl;
import org.apache.ignite.internal.table.RecordBinaryViewImpl;
import org.apache.ignite.internal.table.RecordViewImpl;
import org.apache.ignite.internal.table.distributed.HashIndexLocker;
import org.apache.ignite.internal.table.distributed.IndexLocker;
import org.apache.ignite.internal.table.distributed.SortedIndexLocker;
import org.apache.ignite.internal.table.distributed.TableSchemaAwareIndexStorage;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class TableImpl
implements Table {
    private final InternalTable tbl;
    private final LockManager lockManager;
    private volatile SchemaRegistry schemaReg;
    private final CompletableFuture<UUID> pkId = new CompletableFuture();
    private final Map<UUID, CompletableFuture<?>> indexesToWait = new ConcurrentHashMap();
    private final Map<UUID, IndexStorageAdapterFactory> indexStorageAdapterFactories = new ConcurrentHashMap<UUID, IndexStorageAdapterFactory>();
    private final Map<UUID, IndexLockerFactory> indexLockerFactories = new ConcurrentHashMap<UUID, IndexLockerFactory>();

    public TableImpl(InternalTable tbl, LockManager lockManager, Supplier<List<UUID>> activeIndexIds) {
        this.tbl = tbl;
        this.lockManager = lockManager;
    }

    @TestOnly
    public TableImpl(InternalTable tbl, SchemaRegistry schemaReg, LockManager lockManager) {
        this.tbl = tbl;
        this.schemaReg = schemaReg;
        this.lockManager = lockManager;
    }

    @NotNull
    public UUID tableId() {
        return this.tbl.tableId();
    }

    public void pkId(UUID pkId) {
        this.pkId.complete(Objects.requireNonNull(pkId, "pkId"));
    }

    public UUID pkId() {
        return this.pkId.join();
    }

    public InternalTable internalTable() {
        return this.tbl;
    }

    @NotNull
    public String name() {
        return this.tbl.name();
    }

    public SchemaRegistry schemaView() {
        return this.schemaReg;
    }

    public void schemaView(@NotNull SchemaRegistry schemaReg) {
        assert (this.schemaReg == null) : "Schema registry is already set [tableName=" + this.name() + "]";
        Objects.requireNonNull(schemaReg, "Schema registry must not be null [tableName=" + this.name() + "]");
        this.schemaReg = schemaReg;
    }

    public <R> RecordView<R> recordView(Mapper<R> recMapper) {
        return new RecordViewImpl<R>(this.tbl, this.schemaReg, recMapper);
    }

    public RecordView<Tuple> recordView() {
        return new RecordBinaryViewImpl(this.tbl, this.schemaReg);
    }

    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper) {
        return new KeyValueViewImpl<K, V>(this.tbl, this.schemaReg, keyMapper, valMapper);
    }

    public KeyValueView<Tuple, Tuple> keyValueView() {
        return new KeyValueBinaryViewImpl(this.tbl, this.schemaReg);
    }

    public int partition(Tuple key) {
        Objects.requireNonNull(key);
        try {
            Row keyRow = new TupleMarshallerImpl(this.schemaReg).marshalKey(key);
            return this.tbl.partition((BinaryRowEx)keyRow);
        }
        catch (TupleMarshallerException e) {
            throw new IgniteInternalException((Throwable)((Object)e));
        }
    }

    public <K> int partition(K key, Mapper<K> keyMapper) {
        Row keyRow;
        Objects.requireNonNull(key);
        Objects.requireNonNull(keyMapper);
        KvMarshallerImpl marshaller = new KvMarshallerImpl(this.schemaReg.schema(), keyMapper, keyMapper);
        try {
            keyRow = marshaller.marshal(key);
        }
        catch (MarshallerException e) {
            throw new IgniteInternalException("Cannot marshal key", (Throwable)e);
        }
        return this.tbl.partition((BinaryRowEx)keyRow);
    }

    public ClusterNode leaderAssignment(int partition) {
        return this.tbl.leaderAssignment(partition);
    }

    public Supplier<Map<UUID, TableSchemaAwareIndexStorage>> indexStorageAdapters(int partId) {
        return () -> {
            this.awaitIndexes();
            ArrayList<IndexStorageAdapterFactory> factories = new ArrayList<IndexStorageAdapterFactory>(this.indexStorageAdapterFactories.values());
            HashMap<UUID, TableSchemaAwareIndexStorage> adapters = new HashMap<UUID, TableSchemaAwareIndexStorage>();
            for (IndexStorageAdapterFactory factory : factories) {
                TableSchemaAwareIndexStorage storage = factory.create(partId);
                adapters.put(storage.id(), storage);
            }
            return adapters;
        };
    }

    public Supplier<Map<UUID, IndexLocker>> indexesLockers(int partId) {
        return () -> {
            this.awaitIndexes();
            ArrayList<IndexLockerFactory> factories = new ArrayList<IndexLockerFactory>(this.indexLockerFactories.values());
            HashMap<UUID, IndexLocker> lockers = new HashMap<UUID, IndexLocker>(factories.size());
            for (IndexLockerFactory factory : factories) {
                IndexLocker locker = factory.create(partId);
                lockers.put(locker.id(), locker);
            }
            return lockers;
        };
    }

    public void registerHashIndex(UUID indexId, boolean unique, Function<BinaryRow, BinaryTuple> searchRowResolver) {
        this.indexLockerFactories.put(indexId, partitionId -> new HashIndexLocker(indexId, unique, this.lockManager, searchRowResolver));
        this.indexStorageAdapterFactories.put(indexId, partitionId -> new TableSchemaAwareIndexStorage(indexId, (IndexStorage)this.tbl.storage().getOrCreateHashIndex(partitionId, indexId), searchRowResolver));
        CompletableFuture<?> indexFuture = this.indexesToWait.remove(indexId);
        if (indexFuture != null) {
            indexFuture.complete(null);
        }
    }

    public void registerSortedIndex(UUID indexId, Function<BinaryRow, BinaryTuple> searchRowResolver) {
        this.indexLockerFactories.put(indexId, partitionId -> new SortedIndexLocker(indexId, this.lockManager, this.tbl.storage().getOrCreateSortedIndex(partitionId, indexId), searchRowResolver));
        this.indexStorageAdapterFactories.put(indexId, partitionId -> new TableSchemaAwareIndexStorage(indexId, (IndexStorage)this.tbl.storage().getOrCreateSortedIndex(partitionId, indexId), searchRowResolver));
        CompletableFuture<?> indexFuture = this.indexesToWait.remove(indexId);
        if (indexFuture != null) {
            indexFuture.complete(null);
        }
    }

    public void unregisterIndex(UUID indexId) {
        this.indexLockerFactories.remove(indexId);
        this.indexStorageAdapterFactories.remove(indexId);
    }

    private void awaitIndexes() {
        List<UUID> indexIds = List.of(this.pkId());
        ArrayList<CompletableFuture> toWait = new ArrayList<CompletableFuture>();
        for (UUID indexId : indexIds) {
            if (this.indexLockerFactories.containsKey(indexId) && this.indexStorageAdapterFactories.containsKey(indexId)) continue;
            CompletableFuture indexFuture = this.indexesToWait.computeIfAbsent(indexId, k -> new CompletableFuture());
            if (this.indexLockerFactories.containsKey(indexId) && this.indexStorageAdapterFactories.containsKey(indexId)) {
                this.indexesToWait.remove(indexId);
                continue;
            }
            toWait.add(indexFuture);
        }
        CompletableFuture.allOf((CompletableFuture[])toWait.toArray(CompletableFuture[]::new)).join();
    }

    @FunctionalInterface
    private static interface IndexStorageAdapterFactory {
        public TableSchemaAwareIndexStorage create(int var1);
    }

    @FunctionalInterface
    private static interface IndexLockerFactory {
        public IndexLocker create(int var1);
    }
}

