/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.IgniteInternalException;

abstract class AbstractTableView {
    protected final InternalTable tbl;
    protected final SchemaRegistry schemaReg;

    protected AbstractTableView(InternalTable tbl, SchemaRegistry schemaReg) {
        this.tbl = tbl;
        this.schemaReg = schemaReg;
    }

    protected <T> T sync(CompletableFuture<T> fut) {
        try {
            return fut.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.convertException(e);
        }
        catch (ExecutionException e) {
            throw this.convertException(e.getCause());
        }
        catch (IgniteInternalException e) {
            throw this.convertException(e);
        }
    }

    protected IgniteException convertException(Throwable th) {
        if (th instanceof IgniteException) {
            return (IgniteException)th;
        }
        return new IgniteException(th);
    }
}

