/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.network.scalecube;

import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterConfig;
import io.scalecube.cluster.ClusterImpl;
import io.scalecube.cluster.ClusterMessageHandler;
import io.scalecube.cluster.Member;
import io.scalecube.cluster.membership.MembershipEvent;
import io.scalecube.net.Address;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.schemas.network.ClusterMembershipView;
import org.apache.ignite.configuration.schemas.network.NetworkConfiguration;
import org.apache.ignite.configuration.schemas.network.NetworkView;
import org.apache.ignite.configuration.schemas.network.ScaleCubeView;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.netty.ConnectionManager;
import org.apache.ignite.internal.network.serialization.ClassDescriptorFactory;
import org.apache.ignite.internal.network.serialization.ClassDescriptorRegistry;
import org.apache.ignite.internal.network.serialization.SerializationService;
import org.apache.ignite.internal.network.serialization.UserObjectSerializationContext;
import org.apache.ignite.internal.network.serialization.marshal.DefaultUserObjectMarshaller;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.network.AbstractClusterService;
import org.apache.ignite.network.ClusterLocalConfiguration;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.DefaultMessagingService;
import org.apache.ignite.network.MessagingService;
import org.apache.ignite.network.NettyBootstrapFactory;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NodeFinder;
import org.apache.ignite.network.NodeFinderFactory;
import org.apache.ignite.network.TopologyService;
import org.apache.ignite.network.scalecube.ScaleCubeDirectMarshallerTransport;
import org.apache.ignite.network.scalecube.ScaleCubeTopologyService;

public class ScaleCubeClusterServiceFactory {
    private static final IgniteLogger LOG = Loggers.forClass(ScaleCubeClusterServiceFactory.class);

    public ClusterService createClusterService(final ClusterLocalConfiguration context, final NetworkConfiguration networkConfiguration, final NettyBootstrapFactory nettyBootstrapFactory) {
        final NetworkMessagesFactory messageFactory = new NetworkMessagesFactory();
        final ScaleCubeTopologyService topologyService = new ScaleCubeTopologyService();
        final UserObjectSerializationContext userObjectSerialization = this.createUserObjectSerializationContext();
        final DefaultMessagingService messagingService = new DefaultMessagingService(messageFactory, (TopologyService)topologyService, userObjectSerialization.descriptorRegistry(), userObjectSerialization.marshaller());
        return new AbstractClusterService(context, (TopologyService)topologyService, (MessagingService)messagingService){
            private volatile ClusterImpl cluster;
            private volatile ConnectionManager connectionMgr;
            private volatile CompletableFuture<Void> shutdownFuture;

            public void start() {
                String consistentId = context.getName();
                SerializationService serializationService = new SerializationService(context.getSerializationRegistry(), userObjectSerialization);
                UUID launchId = UUID.randomUUID();
                NetworkView configView = (NetworkView)networkConfiguration.value();
                this.connectionMgr = new ConnectionManager(configView, serializationService, launchId, consistentId, nettyBootstrapFactory);
                this.connectionMgr.start();
                ScaleCubeDirectMarshallerTransport transport = new ScaleCubeDirectMarshallerTransport(this.connectionMgr.getLocalAddress(), (MessagingService)messagingService, topologyService, messageFactory);
                NodeFinder finder = NodeFinderFactory.createNodeFinder(configView.nodeFinder());
                this.cluster = new ClusterImpl(ScaleCubeClusterServiceFactory.this.clusterConfig(configView.membership())).handler(cl -> new ClusterMessageHandler(){

                    public void onMembershipEvent(MembershipEvent event) {
                        topologyService.onMembershipEvent(event);
                    }
                }).config(opts -> opts.memberAlias(consistentId)).transport(opts -> opts.transportFactory(transportConfig -> transport)).membership(opts -> opts.seedMembers(ScaleCubeClusterServiceFactory.parseAddresses(finder.findNodes())));
                this.shutdownFuture = this.cluster.onShutdown().toFuture();
                topologyService.setCluster((Cluster)this.cluster);
                messagingService.setConnectionManager(this.connectionMgr);
                this.cluster.startAwait();
                MembershipEvent localMembershipEvent = MembershipEvent.createAdded((Member)this.cluster.member(), null, (long)System.currentTimeMillis());
                topologyService.onMembershipEvent(localMembershipEvent);
            }

            public void stop() {
                if (this.cluster == null || this.cluster.member() == null) {
                    return;
                }
                this.cluster.shutdown();
                try {
                    this.shutdownFuture.get(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IgniteInternalException("Interrupted while waiting for the ClusterService to stop", (Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new IgniteInternalException("Unable to stop the ClusterService", e.getCause());
                }
                catch (TimeoutException e) {
                    LOG.warn("Failed to wait for ScaleCube cluster shutdown [reason={}]", (Throwable)e, new Object[]{e.getMessage()});
                }
                this.connectionMgr.stop();
                messagingService.stop();
            }

            public void beforeNodeStop() {
                this.stop();
            }

            public boolean isStopped() {
                return this.shutdownFuture.isDone();
            }
        };
    }

    protected ClusterConfig clusterConfig(ClusterMembershipView cfg) {
        ScaleCubeView scaleCube = cfg.scaleCube();
        return ClusterConfig.defaultLocalConfig().membership(opts -> opts.syncInterval(cfg.membershipSyncInterval()).suspicionMult(scaleCube.membershipSuspicionMultiplier())).failureDetector(opts -> opts.pingInterval(cfg.failurePingInterval()).pingReqMembers(scaleCube.failurePingRequestMembers())).gossip(opts -> opts.gossipInterval((long)scaleCube.gossipInterval()));
    }

    private UserObjectSerializationContext createUserObjectSerializationContext() {
        ClassDescriptorRegistry userObjectDescriptorRegistry = new ClassDescriptorRegistry();
        ClassDescriptorFactory userObjectDescriptorFactory = new ClassDescriptorFactory(userObjectDescriptorRegistry);
        DefaultUserObjectMarshaller userObjectMarshaller = new DefaultUserObjectMarshaller(userObjectDescriptorRegistry, userObjectDescriptorFactory);
        return new UserObjectSerializationContext(userObjectDescriptorRegistry, userObjectDescriptorFactory, userObjectMarshaller);
    }

    private static List<Address> parseAddresses(List<NetworkAddress> addresses) {
        return addresses.stream().map(addr -> Address.create((String)addr.host(), (int)addr.port())).collect(Collectors.toList());
    }
}

