/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import java.lang.reflect.Field;
import org.apache.ignite.internal.network.serialization.BrokenFieldAccessor;
import org.apache.ignite.internal.network.serialization.Classes;
import org.apache.ignite.internal.network.serialization.DeclaredType;
import org.apache.ignite.internal.network.serialization.FieldAccessor;
import org.apache.ignite.internal.network.serialization.Primitives;

public class FieldDescriptor
implements DeclaredType {
    private final String name;
    private final Class<?> localClass;
    private final int typeDescriptorId;
    private final boolean unshared;
    private final boolean isPrimitive;
    private final boolean isRuntimeTypeKnownUpfront;
    private final FieldAccessor accessor;

    public static FieldDescriptor local(Field field, int typeDescriptorId) {
        return new FieldDescriptor(field.getName(), field.getType(), typeDescriptorId, false, field.getType().isPrimitive(), Classes.isRuntimeTypeKnownUpfront(field.getType()), FieldAccessor.forField(field));
    }

    public static FieldDescriptor local(String fieldName, Class<?> fieldClazz, int typeDescriptorId, boolean unshared, Class<?> declaringClass) {
        return new FieldDescriptor(fieldName, fieldClazz, typeDescriptorId, unshared, fieldClazz.isPrimitive(), Classes.isRuntimeTypeKnownUpfront(fieldClazz), declaringClass);
    }

    public static FieldDescriptor remote(String fieldName, Class<?> fieldClazz, int typeDescriptorId, boolean unshared, boolean isPrimitive, boolean isRuntimeTypeKnownUpfront, Class<?> declaringClass) {
        return new FieldDescriptor(fieldName, fieldClazz, typeDescriptorId, unshared, isPrimitive, isRuntimeTypeKnownUpfront, declaringClass);
    }

    public static FieldDescriptor remote(String fieldName, Class<?> fieldClazz, int typeDescriptorId, boolean unshared, boolean isPrimitive, boolean isRuntimeTypeKnownUpfront, String declaringClassName) {
        return new FieldDescriptor(fieldName, fieldClazz, typeDescriptorId, unshared, isPrimitive, isRuntimeTypeKnownUpfront, new BrokenFieldAccessor(fieldName, declaringClassName));
    }

    private FieldDescriptor(String fieldName, Class<?> fieldClazz, int typeDescriptorId, boolean unshared, boolean isPrimitive, boolean isRuntimeTypeKnownUpfront, Class<?> declaringClass) {
        this(fieldName, fieldClazz, typeDescriptorId, unshared, isPrimitive, isRuntimeTypeKnownUpfront, FieldAccessor.forFieldName(fieldName, declaringClass));
    }

    private FieldDescriptor(String fieldName, Class<?> fieldClazz, int typeDescriptorId, boolean unshared, boolean isPrimitive, boolean isRuntimeTypeKnownUpfront, FieldAccessor accessor) {
        this.name = fieldName;
        this.localClass = fieldClazz;
        this.typeDescriptorId = typeDescriptorId;
        this.unshared = unshared;
        this.isPrimitive = isPrimitive;
        this.isRuntimeTypeKnownUpfront = isRuntimeTypeKnownUpfront;
        this.accessor = accessor;
    }

    public String name() {
        return this.name;
    }

    public Class<?> localClass() {
        return this.localClass;
    }

    public String typeName() {
        return this.localClass.getName();
    }

    @Override
    public int typeDescriptorId() {
        return this.typeDescriptorId;
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public int primitiveWidthInBytes() {
        assert (this.isPrimitive());
        return Primitives.widthInBytes(this.localClass);
    }

    @Override
    public boolean isRuntimeTypeKnownUpfront() {
        return this.isRuntimeTypeKnownUpfront;
    }

    public FieldAccessor accessor() {
        return this.accessor;
    }
}

