/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.message.ClassDescriptorMessage;
import org.apache.ignite.internal.network.message.ClassDescriptorMessageBuilder;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class ClassDescriptorMessageDeserializer
implements MessageDeserializer<ClassDescriptorMessage> {
    private final ClassDescriptorMessageBuilder msg;

    ClassDescriptorMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.classDescriptorMessage();
    }

    public Class<ClassDescriptorMessage> klass() {
        return ClassDescriptorMessage.class;
    }

    public ClassDescriptorMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.attributes(reader.readByte("attributes"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.className(reader.readString("className"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.componentTypeDescriptorId(reader.readInt("componentTypeDescriptorId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.msg.componentTypeName(reader.readString("componentTypeName"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.msg.descriptorId(reader.readInt("descriptorId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.msg.fields(reader.readCollection("fields", MessageCollectionItemType.MSG));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.msg.serializationFlags(reader.readByte("serializationFlags"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.msg.serializationType(reader.readByte("serializationType"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.msg.superClassDescriptorId(reader.readInt("superClassDescriptorId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.msg.superClassName(reader.readString("superClassName"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ClassDescriptorMessage.class);
    }
}

