/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.membership;

import io.scalecube.cluster.ClusterConfig;
import io.scalecube.cluster.ClusterMath;
import io.scalecube.cluster.CorrelationIdGenerator;
import io.scalecube.cluster.Member;
import io.scalecube.cluster.fdetector.FailureDetector;
import io.scalecube.cluster.fdetector.FailureDetectorConfig;
import io.scalecube.cluster.fdetector.FailureDetectorEvent;
import io.scalecube.cluster.gossip.GossipProtocol;
import io.scalecube.cluster.membership.MemberStatus;
import io.scalecube.cluster.membership.MembershipConfig;
import io.scalecube.cluster.membership.MembershipEvent;
import io.scalecube.cluster.membership.MembershipProtocol;
import io.scalecube.cluster.membership.MembershipRecord;
import io.scalecube.cluster.membership.SyncData;
import io.scalecube.cluster.metadata.MetadataStore;
import io.scalecube.cluster.monitor.ClusterMonitorModel;
import io.scalecube.cluster.transport.api.Message;
import io.scalecube.cluster.transport.api.Transport;
import io.scalecube.net.Address;
import io.scalecube.reactor.RetryNonSerializedEmitFailureHandler;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Scheduler;

public final class MembershipProtocolImpl
implements MembershipProtocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(MembershipProtocol.class);
    public static final String SYNC = "sc/membership/sync";
    public static final String SYNC_ACK = "sc/membership/syncAck";
    public static final String MEMBERSHIP_GOSSIP = "sc/membership/gossip";
    private final Member localMember;
    private final Transport transport;
    private final MembershipConfig membershipConfig;
    private final FailureDetectorConfig failureDetectorConfig;
    private final List<Address> seedMembers;
    private final FailureDetector failureDetector;
    private final GossipProtocol gossipProtocol;
    private final MetadataStore metadataStore;
    private final CorrelationIdGenerator cidGenerator;
    private final ClusterMonitorModel.Builder monitorModelBuilder;
    private final Map<String, MembershipRecord> membershipTable = new HashMap<String, MembershipRecord>();
    private final Map<String, Member> members = new HashMap<String, Member>();
    private final List<MembershipEvent> removedMembersHistory = new CopyOnWriteArrayList<MembershipEvent>();
    private final Set<String> aliveEmittedSet = new HashSet<String>();
    private final Sinks.Many<MembershipEvent> sink = Sinks.many().multicast().directBestEffort();
    private final Disposable.Composite actionsDisposables = Disposables.composite();
    private final Disposable.Swap disposable = Disposables.swap();
    private final Scheduler scheduler;
    private final Map<String, Disposable> suspicionTimeoutTasks = new HashMap<String, Disposable>();

    public MembershipProtocolImpl(Member localMember, Transport transport, FailureDetector failureDetector, GossipProtocol gossipProtocol, MetadataStore metadataStore, ClusterConfig config, Scheduler scheduler, CorrelationIdGenerator cidGenerator, ClusterMonitorModel.Builder monitorModelBuilder) {
        this.transport = Objects.requireNonNull(transport);
        this.failureDetector = Objects.requireNonNull(failureDetector);
        this.gossipProtocol = Objects.requireNonNull(gossipProtocol);
        this.metadataStore = Objects.requireNonNull(metadataStore);
        this.localMember = Objects.requireNonNull(localMember);
        this.scheduler = Objects.requireNonNull(scheduler);
        this.cidGenerator = Objects.requireNonNull(cidGenerator);
        this.monitorModelBuilder = Objects.requireNonNull(monitorModelBuilder);
        this.membershipConfig = Objects.requireNonNull(config).membershipConfig();
        this.failureDetectorConfig = Objects.requireNonNull(config).failureDetectorConfig();
        this.seedMembers = this.cleanUpSeedMembers(this.membershipConfig.seedMembers());
        this.membershipTable.put(localMember.id(), new MembershipRecord(localMember, MemberStatus.ALIVE, 0));
        this.members.put(localMember.id(), localMember);
        this.actionsDisposables.addAll(Arrays.asList(transport.listen().publishOn(scheduler).subscribe(this::onMessage, ex -> LOGGER.error("[{}][onMessage][error] cause:", (Object)localMember, ex)), failureDetector.listen().publishOn(scheduler).subscribe(this::onFailureDetectorEvent, ex -> LOGGER.error("[{}][onFailureDetectorEvent][error] cause:", (Object)localMember, ex)), gossipProtocol.listen().publishOn(scheduler).subscribe(this::onMembershipGossip, ex -> LOGGER.error("[{}][onMembershipGossip][error] cause:", (Object)localMember, ex)), this.listen().filter(MembershipEvent::isRemoved).subscribe(this::onMemberRemoved)));
    }

    private List<Address> cleanUpSeedMembers(Collection<Address> seedMembers) {
        InetAddress localIpAddress = Address.getLocalIpAddress();
        String hostAddress = localIpAddress.getHostAddress();
        String hostName = localIpAddress.getHostName();
        Address memberAddr = this.localMember.address();
        Address transportAddr = this.transport.address();
        Address memberAddrByHostAddress = Address.create((String)hostAddress, (int)memberAddr.port());
        Address transportAddrByHostAddress = Address.create((String)hostAddress, (int)transportAddr.port());
        Address memberAddByHostName = Address.create((String)hostName, (int)memberAddr.port());
        Address transportAddrByHostName = Address.create((String)hostName, (int)transportAddr.port());
        return new LinkedHashSet<Address>(seedMembers).stream().filter(addr -> this.checkAddressesNotEqual((Address)addr, memberAddr)).filter(addr -> this.checkAddressesNotEqual((Address)addr, transportAddr)).filter(addr -> this.checkAddressesNotEqual((Address)addr, memberAddrByHostAddress)).filter(addr -> this.checkAddressesNotEqual((Address)addr, transportAddrByHostAddress)).filter(addr -> this.checkAddressesNotEqual((Address)addr, memberAddByHostName)).filter(addr -> this.checkAddressesNotEqual((Address)addr, transportAddrByHostName)).collect(Collectors.toList());
    }

    private boolean checkAddressesNotEqual(Address address0, Address address1) {
        if (!address0.equals((Object)address1)) {
            return true;
        }
        LOGGER.warn("[{}] Filtering out seed address: {}", (Object)this.localMember, (Object)address0);
        return false;
    }

    @Override
    public Flux<MembershipEvent> listen() {
        return this.sink.asFlux().onBackpressureBuffer();
    }

    public Mono<Void> updateIncarnation() {
        return Mono.defer(() -> {
            MembershipRecord curRecord = this.membershipTable.get(this.localMember.id());
            MembershipRecord newRecord = new MembershipRecord(this.localMember, MemberStatus.ALIVE, curRecord.incarnation() + 1);
            this.membershipTable.put(this.localMember.id(), newRecord);
            return this.spreadMembershipGossip(newRecord);
        });
    }

    public Mono<Void> leaveCluster() {
        return Mono.defer(() -> {
            MembershipRecord curRecord = this.membershipTable.get(this.localMember.id());
            MembershipRecord newRecord = new MembershipRecord(this.localMember, MemberStatus.LEAVING, curRecord.incarnation() + 1);
            this.membershipTable.put(this.localMember.id(), newRecord);
            return this.spreadMembershipGossip(newRecord);
        });
    }

    @Override
    public Mono<Void> start() {
        return Mono.create(this::start0).then();
    }

    private void start0(MonoSink<Object> sink) {
        this.monitorModelBuilder.seedMembers(this.seedMembers).incarnationSupplier(this::getIncarnation).aliveMembersSupplier(this::getAliveMembers).suspectedMembersSupplier(this::getSuspectedMembers).removedMembersSupplier(this::getRemovedMembers);
        if (this.seedMembers.isEmpty()) {
            this.schedulePeriodicSync();
            sink.success();
            return;
        }
        LOGGER.info("[{}] Making initial Sync to all seed members: {}", (Object)this.localMember, this.seedMembers);
        Mono[] syncs = (Mono[])this.seedMembers.stream().map(address -> this.transport.requestResponse(address, this.prepareSyncDataMsg(SYNC, this.cidGenerator.nextCid())).doOnError(ex -> LOGGER.warn("[{}] Exception on initial Sync, cause: {}", (Object)this.localMember, (Object)ex.toString())).onErrorResume(Exception.class, e -> Mono.empty())).toArray(Mono[]::new);
        Flux.mergeDelayError((int)syncs.length, (Publisher[])syncs).take((long)syncs.length).timeout(Duration.ofMillis(this.membershipConfig.syncTimeout()), this.scheduler).publishOn(this.scheduler).flatMap(message -> this.onSyncAck((Message)message, true)).doFinally(s -> {
            this.schedulePeriodicSync();
            sink.success();
        }).subscribe(null, ex -> LOGGER.warn("[{}] Exception on initial SyncAck, cause: {}", (Object)this.localMember, (Object)ex.toString()));
    }

    @Override
    public void stop() {
        this.actionsDisposables.dispose();
        this.disposable.dispose();
        for (String memberId : this.suspicionTimeoutTasks.keySet()) {
            Disposable future = this.suspicionTimeoutTasks.get(memberId);
            if (future == null || future.isDisposed()) continue;
            future.dispose();
        }
        this.suspicionTimeoutTasks.clear();
        this.sink.emitComplete((Sinks.EmitFailureHandler)RetryNonSerializedEmitFailureHandler.RETRY_NON_SERIALIZED);
    }

    @Override
    public Collection<Member> members() {
        return new ArrayList<Member>(this.members.values());
    }

    @Override
    public Collection<Member> otherMembers() {
        return new ArrayList<Member>(this.members.values()).stream().filter(member -> !member.equals((Object)this.localMember)).collect(Collectors.toList());
    }

    @Override
    public Member member() {
        return this.localMember;
    }

    @Override
    public Optional<Member> member(String id) {
        return Optional.ofNullable(this.members.get(id));
    }

    @Override
    public Optional<Member> member(Address address) {
        return new ArrayList<Member>(this.members.values()).stream().filter(member -> member.address().equals((Object)address)).findFirst();
    }

    private void doSync() {
        Address address = this.selectSyncAddress().orElse(null);
        if (address == null) {
            return;
        }
        Message message = this.prepareSyncDataMsg(SYNC, null);
        LOGGER.debug("[{}][doSync] Send Sync to {}", (Object)this.localMember, (Object)address);
        this.transport.send(address, message).subscribe(null, ex -> LOGGER.debug("[{}][doSync] Failed to send Sync to {}, cause: {}", new Object[]{this.localMember, address, ex.toString()}));
    }

    private void onMessage(Message message) {
        if (this.isSync(message)) {
            this.onSync(message).subscribe(null, ex -> LOGGER.error("[{}][onSync][error] cause:", (Object)this.localMember, ex));
        } else if (this.isSyncAck(message) && message.correlationId() == null) {
            this.onSyncAck(message, false).subscribe(null, ex -> LOGGER.error("[{}][onSyncAck][error] cause:", (Object)this.localMember, ex));
        }
    }

    private boolean isSync(Message message) {
        return SYNC.equals(message.qualifier());
    }

    private boolean isSyncAck(Message message) {
        return SYNC_ACK.equals(message.qualifier());
    }

    private Mono<Void> onSyncAck(Message syncAckMsg, boolean onStart) {
        return Mono.defer(() -> {
            LOGGER.debug("[{}] Received SyncAck from {}", (Object)this.localMember, (Object)syncAckMsg.sender());
            return this.syncMembership((SyncData)syncAckMsg.data(), onStart);
        });
    }

    private Mono<Void> onSync(Message syncMsg) {
        return Mono.defer(() -> {
            Address sender = syncMsg.sender();
            LOGGER.debug("[{}] Received Sync from {}", (Object)this.localMember, (Object)sender);
            return this.syncMembership((SyncData)syncMsg.data(), false).doOnSuccess(avoid -> {
                Message message = this.prepareSyncDataMsg(SYNC_ACK, syncMsg.correlationId());
                this.transport.send(sender, message).subscribe(null, ex -> LOGGER.debug("[{}] Failed to send SyncAck to {}, cause: {}", new Object[]{this.localMember, sender, ex.toString()}));
            });
        });
    }

    private void onFailureDetectorEvent(FailureDetectorEvent fdEvent) {
        MembershipRecord r0 = this.membershipTable.get(fdEvent.member().id());
        if (r0 == null) {
            return;
        }
        if (r0.status() == fdEvent.status()) {
            return;
        }
        LOGGER.debug("[{}][onFailureDetectorEvent] Received status change: {}", (Object)this.localMember, (Object)fdEvent);
        if (fdEvent.status() == MemberStatus.ALIVE) {
            Message syncMsg = this.prepareSyncDataMsg(SYNC, null);
            Address address = fdEvent.member().address();
            this.transport.send(address, syncMsg).subscribe(null, ex -> LOGGER.debug("[{}][onFailureDetectorEvent] Failed to send Sync to {}, cause: {}", new Object[]{this.localMember, address, ex.toString()}));
        } else {
            MembershipRecord record = new MembershipRecord(r0.member(), fdEvent.status(), r0.incarnation());
            this.updateMembership(record, MembershipUpdateReason.FAILURE_DETECTOR_EVENT).subscribe(null, ex -> LOGGER.error("[{}][onFailureDetectorEvent][updateMembership][error] cause:", (Object)this.localMember, ex));
        }
    }

    private void onMembershipGossip(Message message) {
        if (MEMBERSHIP_GOSSIP.equals(message.qualifier())) {
            MembershipRecord record = (MembershipRecord)message.data();
            LOGGER.debug("[{}] Received membership gossip: {}", (Object)this.localMember, (Object)record);
            this.updateMembership(record, MembershipUpdateReason.MEMBERSHIP_GOSSIP).subscribe(null, ex -> LOGGER.error("[{}][onMembershipGossip][updateMembership][error] cause:", (Object)this.localMember, ex));
        }
    }

    private Optional<Address> selectSyncAddress() {
        List addresses = Stream.concat(this.seedMembers.stream(), this.otherMembers().stream().map(Member::address)).collect(Collectors.collectingAndThen(Collectors.toSet(), ArrayList::new));
        Collections.shuffle(addresses);
        if (addresses.isEmpty()) {
            return Optional.empty();
        }
        int i = ThreadLocalRandom.current().nextInt(addresses.size());
        return Optional.of(addresses.get(i));
    }

    private void schedulePeriodicSync() {
        int syncInterval = this.membershipConfig.syncInterval();
        this.disposable.update(this.scheduler.schedulePeriodically(this::doSync, (long)syncInterval, (long)syncInterval, TimeUnit.MILLISECONDS));
    }

    private Message prepareSyncDataMsg(String qualifier, String cid) {
        ArrayList<MembershipRecord> membershipRecords = new ArrayList<MembershipRecord>(this.membershipTable.values());
        SyncData syncData = new SyncData(membershipRecords);
        return Message.withData((Object)syncData).qualifier(qualifier).correlationId(cid).build();
    }

    private Mono<Void> syncMembership(SyncData syncData, boolean onStart) {
        return Mono.defer(() -> {
            MembershipUpdateReason reason = onStart ? MembershipUpdateReason.INITIAL_SYNC : MembershipUpdateReason.SYNC;
            Mono[] monos = (Mono[])syncData.getMembership().stream().map(r1 -> this.updateMembership((MembershipRecord)r1, reason).doOnError(ex -> LOGGER.warn("[{}][syncMembership][{}][error] cause: {}", new Object[]{this.localMember, reason, ex.toString()})).onErrorResume(ex -> Mono.empty())).toArray(Mono[]::new);
            return Flux.mergeDelayError((int)monos.length, (Publisher[])monos).then();
        });
    }

    private static boolean areNamespacesRelated(String namespace1, String namespace2) {
        int n2;
        Path ns2;
        Path ns1 = Paths.get(namespace1, new String[0]);
        if (ns1.compareTo(ns2 = Paths.get(namespace2, new String[0])) == 0) {
            return true;
        }
        int n1 = ns1.getNameCount();
        if (n1 == (n2 = ns2.getNameCount())) {
            return false;
        }
        Path shorter = n1 < n2 ? ns1 : ns2;
        Path longer = n1 < n2 ? ns2 : ns1;
        boolean areNamespacesRelated = true;
        for (int i = 0; i < shorter.getNameCount(); ++i) {
            if (shorter.getName(i).equals(longer.getName(i))) continue;
            areNamespacesRelated = false;
            break;
        }
        return areNamespacesRelated;
    }

    private Mono<Void> updateMembership(MembershipRecord r1, MembershipUpdateReason reason) {
        return Mono.defer(() -> {
            Objects.requireNonNull(r1, "Membership record can't be null");
            String localNamespace = this.membershipConfig.namespace();
            String namespace = r1.member().namespace();
            if (!MembershipProtocolImpl.areNamespacesRelated(localNamespace, namespace)) {
                LOGGER.debug("[{}][updateMembership][{}] Skipping update, namespace not matched, local: {}, inbound: {}", new Object[]{this.localMember, reason, localNamespace, namespace});
                return Mono.empty();
            }
            MembershipRecord r0 = this.membershipTable.get(r1.member().id());
            if (!(r0 != null && r0.isLeaving() || r1.isOverrides(r0))) {
                LOGGER.debug("[{}][updateMembership][{}] Skipping update, can't override r0: {} with received r1: {}", new Object[]{this.localMember, reason, r0, r1});
                return Mono.empty();
            }
            if (r1.member().address().equals((Object)this.localMember.address())) {
                if (r1.member().id().equals(this.localMember.id())) {
                    return this.onSelfMemberDetected(r0, r1, reason);
                }
                return Mono.empty();
            }
            if (r1.isLeaving()) {
                return this.onLeavingDetected(r0, r1);
            }
            if (r1.isDead()) {
                return this.onDeadMemberDetected(r1);
            }
            if (r1.isSuspect()) {
                if (r0 == null || !r0.isLeaving()) {
                    this.membershipTable.put(r1.member().id(), r1);
                }
                this.scheduleSuspicionTimeoutTask(r1);
                this.spreadMembershipGossipUnlessGossiped(r1, reason);
            }
            if (r1.isAlive()) {
                if (r0 != null && r0.isLeaving()) {
                    return this.onAliveAfterLeaving(r1);
                }
                if (r0 == null || r0.incarnation() < r1.incarnation()) {
                    return this.metadataStore.fetchMetadata(r1.member()).doOnError(ex -> LOGGER.warn("[{}][updateMembership][{}] Skipping to add/update member: {}, due to failed fetchMetadata call (cause: {})", new Object[]{this.localMember, reason, r1, ex.toString()})).doOnSuccess(metadata1 -> {
                        this.cancelSuspicionTimeoutTask(r1.member().id());
                        this.spreadMembershipGossipUnlessGossiped(r1, reason);
                        ByteBuffer metadata0 = this.metadataStore.updateMetadata(r1.member(), metadata1);
                        this.onAliveMemberDetected(r1, metadata0, (ByteBuffer)metadata1);
                    }).onErrorResume(Exception.class, e -> Mono.empty()).then();
                }
            }
            return Mono.empty();
        });
    }

    private Mono<Void> onAliveAfterLeaving(MembershipRecord r1) {
        Member member = r1.member();
        String memberId = member.id();
        this.members.put(memberId, member);
        if (this.aliveEmittedSet.add(memberId)) {
            long timestamp = System.currentTimeMillis();
            this.publishEvent(MembershipEvent.createAdded((Member)member, null, (long)timestamp));
            this.publishEvent(MembershipEvent.createLeaving((Member)member, null, (long)timestamp));
        }
        return Mono.empty();
    }

    private Mono<Void> onSelfMemberDetected(MembershipRecord r0, MembershipRecord r1, MembershipUpdateReason reason) {
        return Mono.fromRunnable(() -> {
            int currentIncarnation = Math.max(r0.incarnation(), r1.incarnation());
            MembershipRecord r2 = new MembershipRecord(this.localMember, r0.status(), currentIncarnation + 1);
            this.membershipTable.put(this.localMember.id(), r2);
            LOGGER.debug("[{}][updateMembership][{}] Updating incarnation, local record r0: {} to received r1: {}, spreading with increased incarnation r2: {}", new Object[]{this.localMember, reason, r0, r1, r2});
            this.spreadMembershipGossip(r2).subscribe(null, th -> {});
        });
    }

    private Mono<Void> onLeavingDetected(MembershipRecord r0, MembershipRecord r1) {
        return Mono.defer(() -> {
            Member member = r1.member();
            String memberId = member.id();
            this.membershipTable.put(memberId, r1);
            if (r0 != null && (r0.isAlive() || r0.isSuspect() && this.aliveEmittedSet.contains(memberId))) {
                ByteBuffer metadata = this.metadataStore.metadata(member).orElse(null);
                long timestamp = System.currentTimeMillis();
                this.publishEvent(MembershipEvent.createLeaving((Member)member, (ByteBuffer)metadata, (long)timestamp));
            }
            if (r0 == null || !r0.isLeaving()) {
                this.scheduleSuspicionTimeoutTask(r1);
                return this.spreadMembershipGossip(r1);
            }
            return Mono.empty();
        });
    }

    private void publishEvent(MembershipEvent event) {
        LOGGER.info("[{}][publishEvent] {}", (Object)this.localMember, (Object)event);
        this.sink.emitNext((Object)event, (Sinks.EmitFailureHandler)RetryNonSerializedEmitFailureHandler.RETRY_NON_SERIALIZED);
    }

    private Mono<Void> onDeadMemberDetected(MembershipRecord r1) {
        return Mono.fromRunnable(() -> {
            Member member = r1.member();
            this.cancelSuspicionTimeoutTask(member.id());
            if (!this.members.containsKey(member.id())) {
                return;
            }
            this.members.remove(member.id());
            MembershipRecord r0 = this.membershipTable.remove(member.id());
            ByteBuffer metadata = this.metadataStore.removeMetadata(member);
            this.aliveEmittedSet.remove(member.id());
            if (r0.isLeaving()) {
                LOGGER.info("[{}] Member leaved gracefully: {}", (Object)this.localMember, (Object)member);
            } else {
                LOGGER.info("[{}] Member leaved without notification: {}", (Object)this.localMember, (Object)member);
            }
            long timestamp = System.currentTimeMillis();
            this.publishEvent(MembershipEvent.createRemoved((Member)member, (ByteBuffer)metadata, (long)timestamp));
        });
    }

    private void onAliveMemberDetected(MembershipRecord r1, ByteBuffer metadata0, ByteBuffer metadata1) {
        Member member = r1.member();
        boolean memberExists = this.members.containsKey(member.id());
        long timestamp = System.currentTimeMillis();
        MembershipEvent event = null;
        if (!memberExists) {
            event = MembershipEvent.createAdded((Member)member, (ByteBuffer)metadata1, (long)timestamp);
        } else if (!metadata1.equals(metadata0)) {
            event = MembershipEvent.createUpdated((Member)member, (ByteBuffer)metadata0, (ByteBuffer)metadata1, (long)timestamp);
        }
        this.members.put(member.id(), member);
        this.membershipTable.put(member.id(), r1);
        if (event != null) {
            this.publishEvent(event);
            if (event.isAdded()) {
                this.aliveEmittedSet.add(member.id());
            }
        }
    }

    private void cancelSuspicionTimeoutTask(String memberId) {
        Disposable future = this.suspicionTimeoutTasks.remove(memberId);
        if (future != null && !future.isDisposed()) {
            LOGGER.debug("[{}] Cancelled SuspicionTimeoutTask for {}", (Object)this.localMember, (Object)memberId);
            future.dispose();
        }
    }

    private void scheduleSuspicionTimeoutTask(MembershipRecord r) {
        long suspicionTimeout = ClusterMath.suspicionTimeout(this.membershipConfig.suspicionMult(), this.membershipTable.size(), this.failureDetectorConfig.pingInterval());
        this.suspicionTimeoutTasks.computeIfAbsent(r.member().id(), id -> {
            LOGGER.debug("[{}] Scheduled SuspicionTimeoutTask for {}, suspicionTimeout: {}", new Object[]{this.localMember, id, suspicionTimeout});
            return this.scheduler.schedule(() -> this.onSuspicionTimeout((String)id), suspicionTimeout, TimeUnit.MILLISECONDS);
        });
    }

    private void onSuspicionTimeout(String memberId) {
        this.suspicionTimeoutTasks.remove(memberId);
        MembershipRecord r = this.membershipTable.get(memberId);
        if (r != null) {
            LOGGER.debug("[{}] Declare SUSPECTED member {} as DEAD by timeout", (Object)this.localMember, (Object)r);
            MembershipRecord deadRecord = new MembershipRecord(r.member(), MemberStatus.DEAD, r.incarnation());
            this.updateMembership(deadRecord, MembershipUpdateReason.SUSPICION_TIMEOUT).subscribe(null, ex -> LOGGER.error("[{}][onSuspicionTimeout][updateMembership][error] cause:", (Object)this.localMember, ex));
        }
    }

    private void spreadMembershipGossipUnlessGossiped(MembershipRecord r, MembershipUpdateReason reason) {
        if (reason != MembershipUpdateReason.MEMBERSHIP_GOSSIP && reason != MembershipUpdateReason.INITIAL_SYNC) {
            this.spreadMembershipGossip(r).subscribe(null, th -> {});
        }
    }

    private Mono<Void> spreadMembershipGossip(MembershipRecord r) {
        return Mono.defer(() -> {
            Message msg = Message.withData((Object)r).qualifier(MEMBERSHIP_GOSSIP).build();
            LOGGER.debug("[{}] Send membership with gossip", (Object)this.localMember);
            return this.gossipProtocol.spread(msg).doOnError(ex -> LOGGER.debug("[{}] Failed to send membership with gossip, cause: {}", (Object)this.localMember, (Object)ex.toString())).then();
        });
    }

    FailureDetector getFailureDetector() {
        return this.failureDetector;
    }

    GossipProtocol getGossipProtocol() {
        return this.gossipProtocol;
    }

    Transport getTransport() {
        return this.transport;
    }

    MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    List<MembershipRecord> getMembershipRecords() {
        return Collections.unmodifiableList(new ArrayList<MembershipRecord>(this.membershipTable.values()));
    }

    private int getIncarnation() {
        return this.membershipTable.get(this.localMember.id()).incarnation();
    }

    private List<Member> getAliveMembers() {
        return this.findRecordsByCondition(MembershipRecord::isAlive);
    }

    private List<Member> getSuspectedMembers() {
        return this.findRecordsByCondition(MembershipRecord::isSuspect);
    }

    private List<Member> getRemovedMembers() {
        return this.removedMembersHistory.stream().map(MembershipEvent::member).collect(Collectors.toList());
    }

    private List<Member> findRecordsByCondition(Predicate<MembershipRecord> condition) {
        return this.getMembershipRecords().stream().filter(condition).map(MembershipRecord::member).collect(Collectors.toList());
    }

    private void onMemberRemoved(MembershipEvent event) {
        int s = this.membershipConfig.removedMembersHistorySize();
        if (s <= 0) {
            return;
        }
        this.removedMembersHistory.add(event);
        if (this.removedMembersHistory.size() > s) {
            this.removedMembersHistory.remove(0);
        }
    }

    private static enum MembershipUpdateReason {
        FAILURE_DETECTOR_EVENT,
        MEMBERSHIP_GOSSIP,
        SYNC,
        INITIAL_SYNC,
        SUSPICION_TIMEOUT;

    }
}

