/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.impl.IgniteAbstractTransactionImpl;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.NotNull;

public class ReadWriteTransactionImpl
extends IgniteAbstractTransactionImpl {
    private static final IgniteLogger LOG = Loggers.forClass(InternalTransaction.class);
    private final Map<ReplicationGroupId, IgniteBiTuple<ClusterNode, Long>> enlisted = new ConcurrentHashMap<ReplicationGroupId, IgniteBiTuple<ClusterNode, Long>>();
    private final List<CompletableFuture<?>> enlistedResults = new CopyOnWriteArrayList();
    private final AtomicReference<ReplicationGroupId> commitPartitionRef = new AtomicReference();

    public ReadWriteTransactionImpl(TxManager txManager, @NotNull UUID id) {
        super(txManager, id);
    }

    @Override
    public boolean assignCommitPartition(ReplicationGroupId replicationGroupId) {
        return this.commitPartitionRef.compareAndSet(null, replicationGroupId);
    }

    @Override
    public ReplicationGroupId commitPartition() {
        return this.commitPartitionRef.get();
    }

    @Override
    public IgniteBiTuple<ClusterNode, Long> enlistedNodeAndTerm(ReplicationGroupId partGroupId) {
        return this.enlisted.get(partGroupId);
    }

    @Override
    public IgniteBiTuple<ClusterNode, Long> enlist(ReplicationGroupId replicationGroupId, IgniteBiTuple<ClusterNode, Long> nodeAndTerm) {
        this.enlisted.put(replicationGroupId, nodeAndTerm);
        return nodeAndTerm;
    }

    @Override
    protected CompletableFuture<Void> finish(boolean commit) {
        return CompletableFuture.allOf(this.enlistedResults.toArray(new CompletableFuture[0])).thenCompose(ignored -> {
            if (!this.enlisted.isEmpty()) {
                LinkedHashMap<ClusterNode, List<IgniteBiTuple<ReplicationGroupId, Long>>> groups = new LinkedHashMap<ClusterNode, List<IgniteBiTuple<ReplicationGroupId, Long>>>();
                this.enlisted.forEach((groupId, groupMeta) -> {
                    ClusterNode recipientNode = (ClusterNode)groupMeta.get1();
                    if (groups.containsKey(recipientNode)) {
                        ((List)groups.get(recipientNode)).add(new IgniteBiTuple(groupId, (Object)((Long)groupMeta.get2())));
                    } else {
                        ArrayList<IgniteBiTuple> items = new ArrayList<IgniteBiTuple>();
                        items.add(new IgniteBiTuple(groupId, (Object)((Long)groupMeta.get2())));
                        groups.put(recipientNode, items);
                    }
                });
                ReplicationGroupId commitPart = this.commitPartitionRef.get();
                ClusterNode recipientNode = (ClusterNode)this.enlisted.get(commitPart).get1();
                Long term = (Long)this.enlisted.get(commitPart).get2();
                LOG.debug("Finish [recipientNode={}, term={} commit={}, txId={}, groups={}", new Object[]{recipientNode, term, commit, this.id(), groups});
                return this.txManager.finish(commitPart, recipientNode, term, commit, groups, this.id());
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public void enlistResultFuture(CompletableFuture<?> resultFuture) {
        this.enlistedResults.add(resultFuture);
    }

    public boolean isReadOnly() {
        return false;
    }

    public HybridTimestamp readTimestamp() {
        return null;
    }
}

