/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.marshaller.MarshallerReader;

public class ClientMarshallerReader
implements MarshallerReader {
    private final BinaryTupleReader unpacker;
    private int index;

    public ClientMarshallerReader(BinaryTupleReader unpacker) {
        this.unpacker = unpacker;
    }

    public void skipValue() {
        ++this.index;
    }

    public byte readByte() {
        return this.unpacker.byteValue(this.index++);
    }

    public Byte readByteBoxed() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : Byte.valueOf(this.unpacker.byteValue(idx));
    }

    public short readShort() {
        return this.unpacker.shortValue(this.index++);
    }

    public Short readShortBoxed() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : Short.valueOf(this.unpacker.shortValue(idx));
    }

    public int readInt() {
        return this.unpacker.intValue(this.index++);
    }

    public Integer readIntBoxed() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : Integer.valueOf(this.unpacker.intValue(idx));
    }

    public long readLong() {
        return this.unpacker.longValue(this.index++);
    }

    public Long readLongBoxed() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : Long.valueOf(this.unpacker.longValue(idx));
    }

    public float readFloat() {
        return this.unpacker.floatValue(this.index++);
    }

    public Float readFloatBoxed() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : Float.valueOf(this.unpacker.floatValue(idx));
    }

    public double readDouble() {
        return this.unpacker.doubleValue(this.index++);
    }

    public Double readDoubleBoxed() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : Double.valueOf(this.unpacker.doubleValue(idx));
    }

    public String readString() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : this.unpacker.stringValue(idx);
    }

    public UUID readUuid() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : this.unpacker.uuidValue(idx);
    }

    public byte[] readBytes() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : this.unpacker.bytesValue(idx);
    }

    public BitSet readBitSet() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : this.unpacker.bitmaskValue(idx);
    }

    public BigInteger readBigInt() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : this.unpacker.numberValue(idx);
    }

    public BigDecimal readBigDecimal(int scale) {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : this.unpacker.decimalValue(idx, scale);
    }

    public LocalDate readDate() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : this.unpacker.dateValue(idx);
    }

    public LocalTime readTime() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : this.unpacker.timeValue(idx);
    }

    public Instant readTimestamp() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : this.unpacker.timestampValue(idx);
    }

    public LocalDateTime readDateTime() {
        int idx;
        return this.unpacker.hasNullValue(idx = this.index++) ? null : this.unpacker.dateTimeValue(idx);
    }
}

