/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Objects;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.event.ClientMessageUtils;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.tostring.S;

public class JdbcColumnMeta
extends Response {
    private boolean nullable;
    private String label;
    private String schemaName;
    private String tblName;
    private String colName;
    private int dataType;
    private String dataTypeName;
    private int precision;
    private int scale;
    private String dataTypeCls;

    public JdbcColumnMeta() {
    }

    public JdbcColumnMeta(String label, Class<?> cls) {
        this(label, null, null, null, cls, -1, -1, true);
    }

    public JdbcColumnMeta(String label, String schemaName, String tblName, String colName, Class<?> cls, int precision, int scale, boolean nullable) {
        this(label, schemaName, tblName, colName, cls.getName(), precision, scale, nullable);
    }

    public JdbcColumnMeta(String label, String schemaName, String tblName, String colName, String javaTypeName, int precision, int scale, boolean nullable) {
        this.label = label;
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.colName = colName;
        this.nullable = nullable;
        this.dataType = JdbcColumnMeta.type(javaTypeName);
        this.dataTypeName = JdbcColumnMeta.typeName(javaTypeName);
        this.dataTypeCls = javaTypeName;
        this.precision = precision;
        this.scale = scale;
        this.hasResults = true;
    }

    public String columnLabel() {
        return this.label;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String columnName() {
        return this.colName != null ? this.colName : this.label;
    }

    public int dataType() {
        return this.dataType;
    }

    public String dataTypeName() {
        return this.dataTypeName;
    }

    public String defaultValue() {
        return null;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String dataTypeClass() {
        return this.dataTypeCls;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.hasResults) {
            return;
        }
        packer.packString(this.label);
        ClientMessageUtils.writeStringNullable(packer, this.schemaName);
        ClientMessageUtils.writeStringNullable(packer, this.tblName);
        ClientMessageUtils.writeStringNullable(packer, this.colName);
        packer.packInt(this.dataType);
        packer.packString(this.dataTypeName);
        packer.packString(this.dataTypeCls);
        packer.packBoolean(this.nullable);
        packer.packInt(this.precision);
        packer.packInt(this.scale);
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.hasResults) {
            return;
        }
        this.label = unpacker.unpackString();
        this.schemaName = ClientMessageUtils.readStringNullable(unpacker);
        this.tblName = ClientMessageUtils.readStringNullable(unpacker);
        this.colName = ClientMessageUtils.readStringNullable(unpacker);
        this.dataType = unpacker.unpackInt();
        this.dataTypeName = unpacker.unpackString();
        this.dataTypeCls = unpacker.unpackString();
        this.nullable = unpacker.unpackBoolean();
        this.precision = unpacker.unpackInt();
        this.scale = unpacker.unpackInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcColumnMeta meta = (JdbcColumnMeta)o;
        return this.nullable == meta.nullable && this.dataType == meta.dataType && this.precision == meta.precision && this.scale == meta.scale && Objects.equals(this.schemaName, meta.schemaName) && Objects.equals(this.tblName, meta.tblName) && Objects.equals(this.colName, meta.colName) && Objects.equals(this.dataTypeCls, meta.dataTypeCls) && Objects.equals(this.dataTypeName, meta.dataTypeName);
    }

    public int hashCode() {
        int result = this.nullable ? 1 : 0;
        result = 31 * result + (this.schemaName != null ? this.schemaName.hashCode() : 0);
        result = 31 * result + (this.tblName != null ? this.tblName.hashCode() : 0);
        result = 31 * result + (this.colName != null ? this.colName.hashCode() : 0);
        result = 31 * result + (this.dataTypeCls != null ? this.dataTypeCls.hashCode() : 0);
        result = 31 * result + this.dataType;
        result = 31 * result + (this.dataTypeName != null ? this.dataTypeName.hashCode() : 0);
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    @Override
    public String toString() {
        return S.toString(JdbcColumnMeta.class, (Object)this);
    }

    private static int type(String cls) {
        if (Boolean.class.getName().equals(cls) || Boolean.TYPE.getName().equals(cls)) {
            return 16;
        }
        if (Byte.class.getName().equals(cls) || Byte.TYPE.getName().equals(cls)) {
            return -6;
        }
        if (Short.class.getName().equals(cls) || Short.TYPE.getName().equals(cls)) {
            return 5;
        }
        if (Integer.class.getName().equals(cls) || Integer.TYPE.getName().equals(cls)) {
            return 4;
        }
        if (Long.class.getName().equals(cls) || Long.TYPE.getName().equals(cls)) {
            return -5;
        }
        if (Float.class.getName().equals(cls) || Float.TYPE.getName().equals(cls)) {
            return 6;
        }
        if (Double.class.getName().equals(cls) || Double.TYPE.getName().equals(cls)) {
            return 8;
        }
        if (String.class.getName().equals(cls)) {
            return 12;
        }
        if (byte[].class.getName().equals(cls)) {
            return -2;
        }
        if (Time.class.getName().equals(cls)) {
            return 92;
        }
        if (Timestamp.class.getName().equals(cls)) {
            return 93;
        }
        if (Date.class.getName().equals(cls) || java.sql.Date.class.getName().equals(cls)) {
            return 91;
        }
        if (BigDecimal.class.getName().equals(cls)) {
            return 3;
        }
        return 1111;
    }

    private static String typeName(String cls) {
        if (Boolean.class.getName().equals(cls) || Boolean.TYPE.getName().equals(cls)) {
            return "BOOLEAN";
        }
        if (Byte.class.getName().equals(cls) || Byte.TYPE.getName().equals(cls)) {
            return "TINYINT";
        }
        if (Short.class.getName().equals(cls) || Short.TYPE.getName().equals(cls)) {
            return "SMALLINT";
        }
        if (Integer.class.getName().equals(cls) || Integer.TYPE.getName().equals(cls)) {
            return "INTEGER";
        }
        if (Long.class.getName().equals(cls) || Long.TYPE.getName().equals(cls)) {
            return "BIGINT";
        }
        if (Float.class.getName().equals(cls) || Float.TYPE.getName().equals(cls)) {
            return "FLOAT";
        }
        if (Double.class.getName().equals(cls) || Double.TYPE.getName().equals(cls)) {
            return "DOUBLE";
        }
        if (String.class.getName().equals(cls)) {
            return "VARCHAR";
        }
        if (byte[].class.getName().equals(cls)) {
            return "BINARY";
        }
        if (Time.class.getName().equals(cls)) {
            return "TIME";
        }
        if (Timestamp.class.getName().equals(cls)) {
            return "TIMESTAMP";
        }
        if (Date.class.getName().equals(cls) || java.sql.Date.class.getName().equals(cls)) {
            return "DATE";
        }
        if (BigDecimal.class.getName().equals(cls)) {
            return "DECIMAL";
        }
        return "OTHER";
    }
}

