/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.rpc.AppendEntriesRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

class AppendEntriesRequestDeserializer
implements MessageDeserializer<RpcRequests.AppendEntriesRequest> {
    private final AppendEntriesRequestBuilder msg;

    AppendEntriesRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.appendEntriesRequest();
    }

    public Class<RpcRequests.AppendEntriesRequest> klass() {
        return RpcRequests.AppendEntriesRequest.class;
    }

    public RpcRequests.AppendEntriesRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.committedIndex(reader.readLong("committedIndex"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.dataByteArray(reader.readByteArray("dataByteArray"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.entriesList(reader.readCollection("entriesList", MessageCollectionItemType.MSG));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.msg.groupId(reader.readString("groupId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.msg.peerId(reader.readString("peerId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.msg.prevLogIndex(reader.readLong("prevLogIndex"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.msg.prevLogTerm(reader.readLong("prevLogTerm"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.msg.serverId(reader.readString("serverId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.msg.term(reader.readLong("term"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.msg.timestampByteArray(reader.readByteArray("timestampByteArray"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.AppendEntriesRequest.class);
    }
}

