/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.reuse;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.freelist.PagesList;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagememory.reuse.ReuseBag;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

public class ReuseListImpl
extends PagesList
implements ReuseList {
    private static final AtomicReferenceFieldUpdater<ReuseListImpl, PagesList.Stripe[]> bucketUpdater = AtomicReferenceFieldUpdater.newUpdater(ReuseListImpl.class, PagesList.Stripe[].class, "bucket");
    private volatile PagesList.Stripe[] bucket;
    private final PagesList.PagesCache bucketCache;

    public ReuseListImpl(String name, int grpId, int partId, PageMemory pageMem, PageLockListener lockLsnr, IgniteLogger log, long metaPageId, boolean initNew, @Nullable AtomicLong pageListCacheLimit) throws IgniteInternalCheckedException {
        super(name, grpId, partId, pageMem, lockLsnr, log, 1, metaPageId);
        this.bucketCache = new PagesList.PagesCache(pageListCacheLimit);
        this.reuseList = this;
        this.init(metaPageId, initNew);
    }

    @Override
    protected boolean isReuseBucket(int bucket) {
        assert (bucket == 0) : bucket;
        return true;
    }

    @Override
    public void addForRecycle(ReuseBag bag) throws IgniteInternalCheckedException {
        this.put(bag, 0L, 0L, 0, IoStatisticsHolderNoOp.INSTANCE);
    }

    @Override
    public long takeRecycledPage() throws IgniteInternalCheckedException {
        return this.takeEmptyPage(0, null, IoStatisticsHolderNoOp.INSTANCE);
    }

    @Override
    public long initRecycledPage(long pageId, byte flag, PageIo initIo) throws IgniteInternalCheckedException {
        return this.initRecycledPage0(pageId, flag, initIo);
    }

    @Override
    public long recycledPagesCount() throws IgniteInternalCheckedException {
        return this.storedPagesCount(0);
    }

    @Override
    protected PagesList.Stripe[] getBucket(int bucket) {
        return this.bucket;
    }

    @Override
    protected int getBucketIndex(int freeSpace) {
        return 0;
    }

    @Override
    protected boolean casBucket(int bucket, PagesList.Stripe[] exp, PagesList.Stripe[] upd) {
        return bucketUpdater.compareAndSet(this, exp, upd);
    }

    @Override
    protected PagesList.PagesCache getBucketCache(int bucket, boolean create) {
        return this.bucketCache;
    }

    public String toString() {
        return "ReuseList [name=" + this.name() + "]";
    }
}

