/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.List;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.SplitterUtils;

public class SplitterAndCondition {
    private final GridSqlAst parent;
    private final int childIdx;

    public static void collectAndConditions(List<SplitterAndCondition> res, GridSqlAst parent, int childIdx) {
        GridSqlOperation op;
        Object child = parent.child(childIdx);
        if (child instanceof GridSqlOperation && (op = (GridSqlOperation)child).operationType() == GridSqlOperationType.AND) {
            SplitterAndCondition.collectAndConditions(res, op, 0);
            SplitterAndCondition.collectAndConditions(res, op, 1);
            return;
        }
        if (!SplitterUtils.isTrue(child)) {
            res.add(new SplitterAndCondition(parent, childIdx));
        }
    }

    private SplitterAndCondition(GridSqlAst parent, int childIdx) {
        this.parent = parent;
        this.childIdx = childIdx;
    }

    public <X extends GridSqlAst> X ast() {
        return (X)this.parent.child(this.childIdx);
    }

    public GridSqlAst parent() {
        return this.parent;
    }

    public int childIndex() {
        return this.childIdx;
    }
}

