/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.internal.S;

@Deprecated
public class GridAffinityAssignment
implements AffinityAssignment,
Serializable {
    private static final long serialVersionUID = 0L;
    private final AffinityTopologyVersion topVer;
    private List<List<ClusterNode>> assignment;
    private final Map<UUID, Set<Integer>> primary;
    private final Map<UUID, Set<Integer>> backup;
    private volatile transient List<HashSet<UUID>> assignmentIds;
    private volatile transient Set<ClusterNode> nodes;
    private volatile transient Set<ClusterNode> primaryPartsNodes;
    private transient List<List<ClusterNode>> idealAssignment;

    GridAffinityAssignment(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
        this.primary = new HashMap<UUID, Set<Integer>>();
        this.backup = new HashMap<UUID, Set<Integer>>();
    }

    GridAffinityAssignment(AffinityTopologyVersion topVer, List<List<ClusterNode>> assignment, List<List<ClusterNode>> idealAssignment) {
        assert (topVer != null);
        assert (assignment != null);
        assert (idealAssignment != null);
        this.topVer = topVer;
        this.assignment = assignment;
        this.idealAssignment = idealAssignment.equals(assignment) ? assignment : idealAssignment;
        this.primary = new HashMap<UUID, Set<Integer>>();
        this.backup = new HashMap<UUID, Set<Integer>>();
        this.initPrimaryBackupMaps();
    }

    GridAffinityAssignment(AffinityTopologyVersion topVer, GridAffinityAssignment aff) {
        this.topVer = topVer;
        this.assignment = aff.assignment;
        this.idealAssignment = aff.idealAssignment;
        this.primary = aff.primary;
        this.backup = aff.backup;
    }

    @Override
    public List<List<ClusterNode>> idealAssignment() {
        return this.idealAssignment;
    }

    @Override
    public List<List<ClusterNode>> assignment() {
        return this.assignment;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public List<ClusterNode> get(int part) {
        assert (part >= 0 && part < this.assignment.size()) : "Affinity partition is out of range [part=" + part + ", partitions=" + this.assignment.size() + "]";
        return this.assignment.get(part);
    }

    public HashSet<UUID> getIds(int part) {
        assert (part >= 0 && part < this.assignment.size()) : "Affinity partition is out of range [part=" + part + ", partitions=" + this.assignment.size() + "]";
        List<HashSet<UUID>> assignmentIds0 = this.assignmentIds;
        if (assignmentIds0 == null) {
            assignmentIds0 = new ArrayList<HashSet<UUID>>();
            for (List<ClusterNode> assignmentPart : this.assignment) {
                HashSet<UUID> partIds = new HashSet<UUID>();
                for (ClusterNode node : assignmentPart) {
                    partIds.add(node.id());
                }
                assignmentIds0.add(partIds);
            }
            this.assignmentIds = assignmentIds0;
        }
        return assignmentIds0.get(part);
    }

    @Override
    public Set<ClusterNode> nodes() {
        Set<ClusterNode> res = this.nodes;
        if (res == null) {
            res = new HashSet<ClusterNode>();
            for (int p = 0; p < this.assignment.size(); ++p) {
                List<ClusterNode> nodes = this.assignment.get(p);
                if (nodes.isEmpty()) continue;
                res.addAll(nodes);
            }
            this.nodes = res;
        }
        return res;
    }

    @Override
    public Set<ClusterNode> primaryPartitionNodes() {
        Set<ClusterNode> res = this.primaryPartsNodes;
        if (res == null) {
            res = new HashSet<ClusterNode>();
            for (int p = 0; p < this.assignment.size(); ++p) {
                List<ClusterNode> nodes = this.assignment.get(p);
                if (nodes.isEmpty()) continue;
                res.add(nodes.get(0));
            }
            this.primaryPartsNodes = res;
        }
        return res;
    }

    @Override
    public Set<Integer> primaryPartitions(UUID nodeId) {
        Set<Integer> set = this.primary.get(nodeId);
        return set == null ? Collections.emptySet() : set;
    }

    @Override
    public Set<Integer> backupPartitions(UUID nodeId) {
        Set<Integer> set = this.backup.get(nodeId);
        return set == null ? Collections.emptySet() : set;
    }

    @Override
    public Set<Integer> partitionPrimariesDifferentToIdeal() {
        return Collections.emptySet();
    }

    private void initPrimaryBackupMaps() {
        HashMap<UUID, HashSet<Integer>> tmpPrm = new HashMap<UUID, HashSet<Integer>>();
        HashMap tmpBkp = new HashMap();
        int partsCnt = this.assignment.size();
        for (int p = 0; p < partsCnt; ++p) {
            HashMap<UUID, HashSet<Integer>> tmp = tmpPrm;
            Map<UUID, Set<Integer>> map = this.primary;
            for (ClusterNode node : this.assignment.get(p)) {
                UUID id = node.id();
                HashSet<Integer> set = (HashSet<Integer>)tmp.get(id);
                if (set == null) {
                    set = new HashSet<Integer>();
                    tmp.put(id, set);
                    map.put(id, Collections.unmodifiableSet(set));
                }
                set.add(p);
                tmp = tmpBkp;
                map = this.backup;
            }
        }
    }

    public int hashCode() {
        return this.topVer.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AffinityAssignment)) {
            return false;
        }
        return this.topVer.equals(((AffinityAssignment)o).topologyVersion());
    }

    public String toString() {
        return S.toString(GridAffinityAssignment.class, this, super.toString());
    }
}

