/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metastorage.persistence;

import java.util.UUID;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageUpdateAckMessage;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

class DistributedMetaStorageUpdateMessage
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private final IgniteUuid id = IgniteUuid.randomUuid();
    @GridToStringInclude
    private final UUID reqId;
    @GridToStringInclude
    private final String key;
    private final byte[] valBytes;
    private String errorMsg;

    public DistributedMetaStorageUpdateMessage(UUID reqId, String key, byte[] valBytes) {
        this.reqId = reqId;
        this.key = key;
        this.valBytes = valBytes;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    public UUID requestId() {
        return this.reqId;
    }

    public String key() {
        return this.key;
    }

    public byte[] value() {
        return this.valBytes;
    }

    public boolean isAckMessage() {
        return false;
    }

    public void errorMessage(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    protected String errorMessage() {
        return this.errorMsg;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return new DistributedMetaStorageUpdateAckMessage(this.reqId, this.errorMsg);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        throw new UnsupportedOperationException("createDiscoCache");
    }

    public String toString() {
        return S.toString(DistributedMetaStorageUpdateMessage.class, this);
    }
}

