/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.rest;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.rest.SerializeException;

public class RestResult {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final int status;
    private final MultivaluedMap<String, Object> headers;
    private final String content;

    public RestResult(Response response) {
        this.status = response.getStatus();
        this.headers = response.getHeaders();
        this.content = response.readEntity(String.class);
    }

    public int status() {
        return this.status;
    }

    public MultivaluedMap<String, Object> headers() {
        return this.headers;
    }

    public String content() {
        return this.content;
    }

    public <T> T readObject(Class<T> clazz) {
        try {
            return MAPPER.readValue(this.content, clazz);
        }
        catch (Exception e) {
            throw new SerializeException("Failed to deserialize: %s", (Throwable)e, this.content);
        }
    }

    public <T> List<T> readList(String key, Class<T> clazz) {
        try {
            JsonNode root = MAPPER.readTree(this.content);
            JsonNode element = root.get(key);
            if (element == null) {
                throw new SerializeException("Can't find value of the key: %s in json.", key);
            }
            JavaType type = MAPPER.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, clazz);
            return (List)MAPPER.convertValue((Object)element, type);
        }
        catch (IOException e) {
            throw new SerializeException("Failed to deserialize %s", (Throwable)e, this.content);
        }
    }

    public <T> List<T> readList(Class<T> clazz) {
        JavaType type = MAPPER.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, clazz);
        try {
            return (List)MAPPER.readValue(this.content, type);
        }
        catch (IOException e) {
            throw new SerializeException("Failed to deserialize %s", (Throwable)e, this.content);
        }
    }

    public String toString() {
        return String.format("{status=%s, headers=%s, content=%s}", this.status, this.headers, this.content);
    }

    public static void registerModule(Module module) {
        MAPPER.registerModule(module);
    }
}

