/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hop.pipeline.transforms.loadsave.validator;

import java.util.Random;

public class EnumLoadSaveValidator<E extends Enum<E>> implements IFieldLoadSaveValidator<E> {

  private final Enum<E>[] values;

  public EnumLoadSaveValidator(E defaultValue) {
    this(defaultValue.getClass());
  }

  @SuppressWarnings({"unchecked", "rawtypes"})
  public EnumLoadSaveValidator(Class<? extends Enum> clazz) {
    this.values = clazz.getEnumConstants();
  }

  @SuppressWarnings("unchecked")
  @Override
  public E getTestObject() {
    return (E) values[new Random().nextInt(values.length)];
  }

  @Override
  public boolean validateTestObject(E testObject, Object actual) {
    return testObject == actual;
  }
}
