package org.apache.helix;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Base class for an exception thrown by Helix due to inconsistencies caught by Helix itself.
 */
public class HelixException extends RuntimeException {

  private static final long serialVersionUID = 6558251214364526257L;

  public HelixException(String message) {
    super(message);
  }

  /**
   * Create a HelixException that can optionally turn off stack trace. Its other characteristics are
   * the same as a HelixException with a message.
   * @param message the detail message
   * @param writableStackTrace whether or not the stack trace should be writable
   */
  public HelixException(String message, boolean writableStackTrace) {
    super(message, null, false, writableStackTrace);
  }

  public HelixException(Throwable cause) {
    super(cause);
  }

  public HelixException(String message, Throwable cause) {
    super(message, cause);
  }
}
