/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.util;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.procedure2.util.DelayedUtil;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestDelayedUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDelayedUtil.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestDelayedUtil.class);

    @Test
    public void testDelayedContainerEquals() {
        Object o1 = new Object();
        Object o2 = new Object();
        ZeroDelayContainer<Object> lnull = new ZeroDelayContainer<Object>(null);
        ZeroDelayContainer<Long> l10a = new ZeroDelayContainer<Long>(10L);
        ZeroDelayContainer<Long> l10b = new ZeroDelayContainer<Long>(10L);
        ZeroDelayContainer<Long> l15 = new ZeroDelayContainer<Long>(15L);
        ZeroDelayContainer<Object> onull = new ZeroDelayContainer<Object>(null);
        ZeroDelayContainer<Object> o1ca = new ZeroDelayContainer<Object>(o1);
        ZeroDelayContainer<Object> o1cb = new ZeroDelayContainer<Object>(o1);
        ZeroDelayContainer<Object> o2c = new ZeroDelayContainer<Object>(o2);
        ZeroDelayContainer[] items = new ZeroDelayContainer[]{lnull, l10a, l10b, l15, onull, o1ca, o1cb, o2c};
        this.assertContainersEquals(lnull, items, lnull, onull);
        this.assertContainersEquals(l10a, items, l10a, l10b);
        this.assertContainersEquals(l10b, items, l10a, l10b);
        this.assertContainersEquals(l15, items, l15);
        this.assertContainersEquals(onull, items, lnull, onull);
        this.assertContainersEquals(o1ca, items, o1ca, o1cb);
        this.assertContainersEquals(o1cb, items, o1ca, o1cb);
        this.assertContainersEquals(o2c, items, o2c);
    }

    private void assertContainersEquals(ZeroDelayContainer src, ZeroDelayContainer[] items, ZeroDelayContainer ... matches) {
        for (int i = 0; i < items.length; ++i) {
            boolean shouldMatch = false;
            for (int j = 0; j < matches.length; ++j) {
                if (items[i] != matches[j]) continue;
                shouldMatch = true;
                break;
            }
            boolean isMatching = src.equals((Object)items[i]);
            Assert.assertEquals((String)(src.getObject() + " unexpectedly match " + items[i].getObject()), (Object)shouldMatch, (Object)isMatching);
        }
    }

    private static class ZeroDelayContainer<T>
    extends DelayedUtil.DelayedContainer<T> {
        public ZeroDelayContainer(T object) {
            super(object);
        }

        public long getTimeout() {
            return 0L;
        }
    }
}

