/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.ClassLoaderBase;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.hadoop.io.IOUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.MapMaker;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CoprocessorClassLoader
extends ClassLoaderBase {
    private static final Logger LOG = LoggerFactory.getLogger(CoprocessorClassLoader.class);
    private static final String TMP_JARS_DIR = File.separator + "jars" + File.separator + "tmp" + File.separator;
    private static final ConcurrentMap<Path, CoprocessorClassLoader> classLoadersCache = new MapMaker().concurrencyLevel(3).weakValues().makeMap();
    private static final String[] CLASS_PREFIX_EXEMPTIONS = new String[]{"com.sun.", "java.", "javax.", "org.ietf", "org.omg", "org.w3c", "org.xml", "sunw.", "org.slf4j", "org.apache.log4j", "com.hadoop", "org.apache.hadoop.hbase"};
    private static final Pattern[] RESOURCE_LOAD_PARENT_FIRST_PATTERNS = new Pattern[]{Pattern.compile("^[^-]+-default\\.xml$")};
    private static final Pattern libJarPattern = Pattern.compile("[/]?lib/([^/]+\\.jar)");
    private static final KeyLocker<String> locker = new KeyLocker();
    static final HashSet<String> parentDirLockSet = new HashSet();

    private CoprocessorClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Path pathPattern, String pathPrefix, Configuration conf) throws IOException {
        String parentDirStr = conf.get("hbase.local.dir", "/tmp/hbase-local-dir") + TMP_JARS_DIR;
        HashSet<String> hashSet = parentDirLockSet;
        synchronized (hashSet) {
            if (!parentDirLockSet.contains(parentDirStr)) {
                Path parentDir = new Path(parentDirStr);
                LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
                fs.delete(parentDir, true);
                parentDirLockSet.add(parentDirStr);
                if (!fs.mkdirs(parentDir) && !fs.getFileStatus(parentDir).isDirectory()) {
                    throw new RuntimeException("Failed to create local dir " + parentDirStr + ", CoprocessorClassLoader failed to init");
                }
            }
        }
        FileSystem fs = pathPattern.getFileSystem(conf);
        Path pathPattern1 = fs.isDirectory(pathPattern) ? new Path(pathPattern, "*.jar") : pathPattern;
        FileStatus[] fileStatuses = fs.globStatus(pathPattern1);
        if (fileStatuses == null || fileStatuses.length == 0) {
            throw new FileNotFoundException(pathPattern1.toString());
        }
        boolean validFileEncountered = false;
        for (Path path : FileUtil.stat2Paths((FileStatus[])fileStatuses)) {
            if (!fs.isFile(path)) continue;
            File dst = new File(parentDirStr, "." + pathPrefix + "." + path.getName() + "." + EnvironmentEdgeManager.currentTime() + ".jar");
            fs.copyToLocalFile(path, new Path(dst.toString()));
            dst.deleteOnExit();
            this.addURL(dst.getCanonicalFile().toURI().toURL());
            try (JarFile jarFile = new JarFile(dst.toString());){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    Matcher m3 = libJarPattern.matcher(entry.getName());
                    if (!m3.matches()) continue;
                    File file = new File(parentDirStr, "." + pathPrefix + "." + path.getName() + "." + EnvironmentEdgeManager.currentTime() + "." + m3.group(1));
                    try (FileOutputStream outStream = new FileOutputStream(file);){
                        IOUtils.copyBytes((InputStream)jarFile.getInputStream(entry), (OutputStream)outStream, (Configuration)conf, (boolean)true);
                    }
                    file.deleteOnExit();
                    this.addURL(file.toURI().toURL());
                }
            }
            validFileEncountered = true;
        }
        if (!validFileEncountered) {
            throw new FileNotFoundException("No file found matching " + pathPattern1.toString());
        }
    }

    public static CoprocessorClassLoader getIfCached(Path path) {
        Preconditions.checkNotNull(path, "The jar path is null!");
        return (CoprocessorClassLoader)classLoadersCache.get(path);
    }

    public static Collection<? extends ClassLoader> getAllCached() {
        return classLoadersCache.values();
    }

    public static void clearCache() {
        classLoadersCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoprocessorClassLoader getClassLoader(Path path, final ClassLoader parent, String pathPrefix, Configuration conf) throws IOException {
        CoprocessorClassLoader cl = CoprocessorClassLoader.getIfCached(path);
        String pathStr = path.toString();
        if (cl != null) {
            LOG.debug("Found classloader " + cl + " for " + pathStr);
            return cl;
        }
        if (path.getFileSystem(conf).isFile(path) && !pathStr.endsWith(".jar")) {
            throw new IOException(pathStr + ": not a jar file?");
        }
        ReentrantLock lock = locker.acquireLock(pathStr);
        try {
            cl = CoprocessorClassLoader.getIfCached(path);
            if (cl != null) {
                LOG.debug("Found classloader " + cl + " for " + pathStr);
                CoprocessorClassLoader coprocessorClassLoader = cl;
                return coprocessorClassLoader;
            }
            cl = AccessController.doPrivileged(new PrivilegedAction<CoprocessorClassLoader>(){

                @Override
                public CoprocessorClassLoader run() {
                    return new CoprocessorClassLoader(parent);
                }
            });
            cl.init(path, pathPrefix, conf);
            CoprocessorClassLoader prev = classLoadersCache.putIfAbsent(path, cl);
            if (prev != null) {
                LOG.warn("THIS SHOULD NOT HAPPEN, a class loader is already cached for " + pathStr);
                cl = prev;
            }
            CoprocessorClassLoader coprocessorClassLoader = cl;
            return coprocessorClassLoader;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClass(String name, String[] includedClassPrefixes) throws ClassNotFoundException {
        if (this.isClassExempt(name, includedClassPrefixes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping exempt class " + name + " - delegating directly to parent");
            }
            return this.parent.loadClass(name);
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clasz = this.findLoadedClass(name);
            if (clasz != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Class " + name + " already loaded");
                }
            } else {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Finding class: " + name);
                    }
                    clasz = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Class " + name + " not found - delegating to parent");
                    }
                    try {
                        clasz = this.parent.loadClass(name);
                    }
                    catch (ClassNotFoundException e2) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Class " + name + " not found in parent loader");
                        }
                        throw e2;
                    }
                }
            }
            return clasz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        URL resource = null;
        boolean parentLoaded = false;
        if (this.loadResourceUsingParentFirst(name)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking parent first for resource " + name);
            }
            resource = super.getResource(name);
            parentLoaded = true;
        }
        if (resource == null) {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                resource = this.findResource(name);
                if (resource == null && !parentLoaded) {
                    resource = super.getResource(name);
                }
            }
        }
        return resource;
    }

    protected boolean isClassExempt(String name, String[] includedClassPrefixes) {
        if (includedClassPrefixes != null) {
            for (String clsName : includedClassPrefixes) {
                if (!name.startsWith(clsName)) continue;
                return false;
            }
        }
        for (String exemptPrefix : CLASS_PREFIX_EXEMPTIONS) {
            if (!name.startsWith(exemptPrefix)) continue;
            return true;
        }
        return false;
    }

    protected boolean loadResourceUsingParentFirst(String name) {
        for (Pattern resourcePattern : RESOURCE_LOAD_PARENT_FIRST_PATTERNS) {
            if (!resourcePattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }
}

