/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.memcache;

import java.util.List;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.FileRegion;
import org.apache.hbase.thirdparty.io.netty.handler.codec.MessageToMessageEncoder;
import org.apache.hbase.thirdparty.io.netty.handler.codec.memcache.LastMemcacheContent;
import org.apache.hbase.thirdparty.io.netty.handler.codec.memcache.MemcacheContent;
import org.apache.hbase.thirdparty.io.netty.handler.codec.memcache.MemcacheMessage;
import org.apache.hbase.thirdparty.io.netty.handler.codec.memcache.MemcacheObject;
import org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;

public abstract class AbstractMemcacheObjectEncoder<M extends MemcacheMessage>
extends MessageToMessageEncoder<Object> {
    private boolean expectingMoreContent;

    @Override
    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        if (msg instanceof MemcacheMessage) {
            if (this.expectingMoreContent) {
                throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(msg));
            }
            MemcacheMessage m3 = (MemcacheMessage)msg;
            out.add(this.encodeMessage(ctx, m3));
        }
        if (msg instanceof MemcacheContent || msg instanceof ByteBuf || msg instanceof FileRegion) {
            int contentLength = AbstractMemcacheObjectEncoder.contentLength(msg);
            if (contentLength > 0) {
                out.add(AbstractMemcacheObjectEncoder.encodeAndRetain(msg));
            } else {
                out.add(Unpooled.EMPTY_BUFFER);
            }
            this.expectingMoreContent = !(msg instanceof LastMemcacheContent);
        }
    }

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return msg instanceof MemcacheObject || msg instanceof ByteBuf || msg instanceof FileRegion;
    }

    protected abstract ByteBuf encodeMessage(ChannelHandlerContext var1, M var2);

    private static int contentLength(Object msg) {
        if (msg instanceof MemcacheContent) {
            return ((MemcacheContent)msg).content().readableBytes();
        }
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof FileRegion) {
            return (int)((FileRegion)msg).count();
        }
        throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(msg));
    }

    private static Object encodeAndRetain(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).retain();
        }
        if (msg instanceof MemcacheContent) {
            return ((MemcacheContent)msg).content().retain();
        }
        if (msg instanceof FileRegion) {
            return ((FileRegion)msg).retain();
        }
        throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(msg));
    }
}

