/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.util.TimeMeasurable;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class MovingAverage<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MovingAverage.class);
    protected final String label;

    protected MovingAverage(String label) {
        this.label = label;
    }

    protected long start() {
        return System.nanoTime();
    }

    protected long stop(long startTime) {
        return System.nanoTime() - startTime;
    }

    public T measure(TimeMeasurable<T> measurable) {
        long startTime = this.start();
        LOG.trace("{} - start to measure at: {} ns.", (Object)this.label, (Object)startTime);
        T result = measurable.measure();
        long elapsed = this.stop(startTime);
        LOG.trace("{} - elapse: {} ns.", (Object)this.label, (Object)elapsed);
        this.updateMostRecentTime(elapsed);
        return result;
    }

    protected abstract void updateMostRecentTime(long var1);

    public abstract double getAverageTime();
}

