/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.TestMetricsConfig;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;

public class TestFSNamesystemMBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            String snapshotStats = (String)mbs.getAttribute(mxbeanName, "SnapshotStats");
            Map stat = (Map)JSON.parse((String)snapshotStats);
            Assert.assertTrue((stat.containsKey("SnapshottableDirectories") && (Long)stat.get("SnapshottableDirectories") == (long)fsn.getNumSnapshottableDirs() ? 1 : 0) != 0);
            Assert.assertTrue((stat.containsKey("Snapshots") && (Long)stat.get("Snapshots") == (long)fsn.getNumSnapshots() ? 1 : 0) != 0);
            Object pendingDeletionBlocks = mbs.getAttribute(mxbeanName, "PendingDeletionBlocks");
            Assert.assertNotNull((Object)pendingDeletionBlocks);
            Assert.assertTrue((boolean)(pendingDeletionBlocks instanceof Long));
            Object encryptionZones = mbs.getAttribute(mxbeanName, "NumEncryptionZones");
            Assert.assertNotNull((Object)encryptionZones);
            Assert.assertTrue((boolean)(encryptionZones instanceof Integer));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithFSNamesystemWriteLock() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        FSNamesystem fsn = null;
        int jmxCachePeriod = 1;
        new ConfigBuilder().add("namenode.period", (Object)jmxCachePeriod).save(TestMetricsConfig.getTestFilename((String)"hadoop-metrics2-namenode"));
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            fsn = cluster.getNameNode().namesystem;
            fsn.writeLock();
            Thread.sleep(jmxCachePeriod * 1000);
            MBeanClient client = new MBeanClient();
            client.start();
            client.join(20000L);
            Assert.assertTrue((String)"JMX calls are blocked when FSNamesystem's writerlockis owned by another thread", (boolean)client.succeeded);
            client.interrupt();
        }
        finally {
            if (fsn != null && fsn.hasWriteLock()) {
                fsn.writeUnlock();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithFSEditLogLock() throws Exception {
        Configuration conf = new Configuration();
        int jmxCachePeriod = 1;
        new ConfigBuilder().add("namenode.period", (Object)jmxCachePeriod).save(TestMetricsConfig.getTestFilename((String)"hadoop-metrics2-namenode"));
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSEditLog fSEditLog = cluster.getNameNode().getFSImage().getEditLog();
            synchronized (fSEditLog) {
                Thread.sleep(jmxCachePeriod * 1000);
                MBeanClient client = new MBeanClient();
                client.start();
                client.join(20000L);
                Assert.assertTrue((String)"JMX calls are blocked when FSEditLog is synchronized by another thread", (boolean)client.succeeded);
                client.interrupt();
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testFsEditLogMetrics() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanNameFs = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            DistributedFileSystem fs = cluster.getFileSystem();
            int NUM_OPS = 10;
            for (int i = 0; i < 10; ++i) {
                Path path = new Path(String.format("/user%d", i));
                fs.mkdirs(path);
            }
            long syncCount = (Long)mbs.getAttribute(mxbeanNameFs, "TotalSyncCount");
            String syncTimes = (String)mbs.getAttribute(mxbeanNameFs, "TotalSyncTimes");
            Assert.assertTrue((syncCount > 0L ? 1 : 0) != 0);
            Assert.assertNotNull((Object)syncTimes);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static class MBeanClient
    extends Thread {
        private boolean succeeded = false;

        private MBeanClient() {
        }

        @Override
        public void run() {
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                ObjectName mxbeanNamefsn = new ObjectName("Hadoop:service=NameNode,name=FSNamesystem");
                ObjectName mxbeanNameFsns = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
                ObjectName mxbeanNameNni = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
                HashSet<ObjectName> mbeans = new HashSet<ObjectName>();
                mbeans.add(mxbeanNamefsn);
                mbeans.add(mxbeanNameFsns);
                mbeans.add(mxbeanNameNni);
                for (ObjectName mbean : mbeans) {
                    MBeanInfo attributes = mbs.getMBeanInfo(mbean);
                    for (MBeanAttributeInfo attributeInfo : attributes.getAttributes()) {
                        mbs.getAttribute(mbean, attributeInfo.getName());
                    }
                }
                this.succeeded = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

