/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.IteratorSelector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;

public class FifoOrderingPolicyWithExclusivePartitions<S extends SchedulableEntity>
implements OrderingPolicy<S> {
    private static final String DEFAULT_PARTITION = "DEFAULT_PARTITION";
    private Map<String, OrderingPolicy<S>> orderingPolicies = new HashMap<String, OrderingPolicy<S>>();

    public FifoOrderingPolicyWithExclusivePartitions() {
        this.orderingPolicies.put(DEFAULT_PARTITION, new FifoOrderingPolicy());
    }

    @Override
    public Collection<S> getSchedulableEntities() {
        return this.unionOrderingPolicies().getSchedulableEntities();
    }

    @Override
    public Iterator<S> getAssignmentIterator(IteratorSelector sel) {
        return this.getPartitionOrderingPolicy(sel.getPartition()).getAssignmentIterator(sel);
    }

    @Override
    public Iterator<S> getPreemptionIterator() {
        return this.unionOrderingPolicies().getPreemptionIterator();
    }

    private OrderingPolicy<S> unionOrderingPolicies() {
        FifoOrderingPolicy<S> ret = new FifoOrderingPolicy<S>();
        for (Map.Entry<String, OrderingPolicy<S>> entry : this.orderingPolicies.entrySet()) {
            ret.addAllSchedulableEntities(entry.getValue().getSchedulableEntities());
        }
        return ret;
    }

    @Override
    public void addSchedulableEntity(S s) {
        this.getPartitionOrderingPolicy(s.getPartition()).addSchedulableEntity(s);
    }

    @Override
    public boolean removeSchedulableEntity(S s) {
        return this.getPartitionOrderingPolicy(s.getPartition()).removeSchedulableEntity(s);
    }

    @Override
    public void addAllSchedulableEntities(Collection<S> sc) {
        for (SchedulableEntity entity : sc) {
            this.getPartitionOrderingPolicy(entity.getPartition()).addSchedulableEntity(entity);
        }
    }

    @Override
    public int getNumSchedulableEntities() {
        int ret = 0;
        for (Map.Entry<String, OrderingPolicy<S>> entry : this.orderingPolicies.entrySet()) {
            ret += entry.getValue().getNumSchedulableEntities();
        }
        return ret;
    }

    @Override
    public void containerAllocated(S schedulableEntity, RMContainer r) {
        this.getPartitionOrderingPolicy(schedulableEntity.getPartition()).containerAllocated(schedulableEntity, r);
    }

    @Override
    public void containerReleased(S schedulableEntity, RMContainer r) {
        this.getPartitionOrderingPolicy(schedulableEntity.getPartition()).containerReleased(schedulableEntity, r);
    }

    @Override
    public void demandUpdated(S schedulableEntity) {
        this.getPartitionOrderingPolicy(schedulableEntity.getPartition()).demandUpdated(schedulableEntity);
    }

    @Override
    public void configure(Map<String, String> conf) {
        if (conf == null) {
            return;
        }
        String partitions = conf.get("exclusive-enforced-partitions");
        if (partitions != null) {
            for (String partition : partitions.split(",")) {
                if ((partition = partition.trim()).isEmpty()) continue;
                this.orderingPolicies.put(partition, new FifoOrderingPolicy());
            }
        }
    }

    @Override
    public String getInfo() {
        return "FifoOrderingPolicyWithExclusivePartitions";
    }

    private OrderingPolicy<S> getPartitionOrderingPolicy(String partition) {
        String keyPartition = this.orderingPolicies.containsKey(partition) ? partition : DEFAULT_PARTITION;
        return this.orderingPolicies.get(keyPartition);
    }
}

