/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.util.resource.Resources;

public class FiCaSchedulerNode
extends SchedulerNode {
    private static final Log LOG = LogFactory.getLog(FiCaSchedulerNode.class);
    private Map<ContainerId, RMContainer> killableContainers = new HashMap<ContainerId, RMContainer>();
    private Resource totalKillableResources = Resource.newInstance((int)0, (int)0);

    public FiCaSchedulerNode(RMNode node, boolean usePortForNodeName, Set<String> nodeLabels) {
        super(node, usePortForNodeName, nodeLabels);
    }

    public FiCaSchedulerNode(RMNode node, boolean usePortForNodeName) {
        this(node, usePortForNodeName, CommonNodeLabelsManager.EMPTY_STRING_SET);
    }

    @Override
    public synchronized void reserveResource(SchedulerApplicationAttempt application, SchedulerRequestKey priority, RMContainer container) {
        RMContainer reservedContainer = this.getReservedContainer();
        if (reservedContainer != null) {
            if (!container.getContainer().getNodeId().equals((Object)this.getNodeID())) {
                throw new IllegalStateException("Trying to reserve container " + container + " on node " + container.getReservedNode() + " when currently" + " reserved resource " + reservedContainer + " on node " + reservedContainer.getReservedNode());
            }
            if (!reservedContainer.getContainer().getId().getApplicationAttemptId().equals((Object)container.getContainer().getId().getApplicationAttemptId())) {
                throw new IllegalStateException("Trying to reserve container " + container + " for application " + application.getApplicationAttemptId() + " when currently" + " reserved container " + reservedContainer + " on node " + this);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Updated reserved container " + container.getContainer().getId() + " on node " + this + " for application attempt " + application.getApplicationAttemptId()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reserved container " + container.getContainer().getId() + " on node " + this + " for application attempt " + application.getApplicationAttemptId()));
        }
        this.setReservedContainer(container);
    }

    @Override
    public synchronized void unreserveResource(SchedulerApplicationAttempt application) {
        ApplicationAttemptId reservedApplication;
        if (this.getReservedContainer() != null && this.getReservedContainer().getContainer() != null && this.getReservedContainer().getContainer().getId() != null && this.getReservedContainer().getContainer().getId().getApplicationAttemptId() != null && !(reservedApplication = this.getReservedContainer().getContainer().getId().getApplicationAttemptId()).equals((Object)application.getApplicationAttemptId())) {
            throw new IllegalStateException("Trying to unreserve  for application " + application.getApplicationAttemptId() + " when currently reserved " + " for application " + reservedApplication.getApplicationId() + " on node " + this);
        }
        this.setReservedContainer(null);
    }

    public synchronized void markContainerToKillable(ContainerId containerId) {
        RMContainer c = this.getContainer(containerId);
        if (c != null && !this.killableContainers.containsKey(containerId)) {
            this.killableContainers.put(containerId, c);
            Resources.addTo((Resource)this.totalKillableResources, (Resource)c.getAllocatedResource());
        }
    }

    public synchronized void markContainerToNonKillable(ContainerId containerId) {
        RMContainer c = this.getContainer(containerId);
        if (c != null && this.killableContainers.containsKey(containerId)) {
            this.killableContainers.remove(containerId);
            Resources.subtractFrom((Resource)this.totalKillableResources, (Resource)c.getAllocatedResource());
        }
    }

    @Override
    protected synchronized void updateResourceForReleasedContainer(Container container) {
        super.updateResourceForReleasedContainer(container);
        if (this.killableContainers.containsKey(container.getId())) {
            Resources.subtractFrom((Resource)this.totalKillableResources, (Resource)container.getResource());
            this.killableContainers.remove(container.getId());
        }
    }

    public synchronized Resource getTotalKillableResources() {
        return this.totalKillableResources;
    }

    public synchronized Map<ContainerId, RMContainer> getKillableContainers() {
        return Collections.unmodifiableMap(this.killableContainers);
    }

    @Override
    protected synchronized void allocateContainer(RMContainer rmContainer, boolean launchedOnNode) {
        super.allocateContainer(rmContainer, launchedOnNode);
        Container container = rmContainer.getContainer();
        LOG.info((Object)("Assigned container " + container.getId() + " of capacity " + container.getResource() + " on host " + this.getRMNode().getNodeAddress() + ", which has " + this.getNumContainers() + " containers, " + this.getAllocatedResource() + " used and " + this.getUnallocatedResource() + " available after allocation"));
    }
}

