/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBCKRegionServerAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(HBCKRegionServerAdmin.class);
    private final RpcControllerFactory rpcControllerFactory;
    private final AdminProtos.AdminService.BlockingInterface stub;
    private final ServerName server;

    private Pair<RpcControllerFactory, AdminProtos.AdminService.BlockingInterface> init2(Connection conn, ServerName server) throws IOException {
        try {
            Class<?> clusterConnClazz = Class.forName("org.apache.hadoop.hbase.client.ClusterConnection");
            Method getRpcControllerFactoryMethod = clusterConnClazz.getDeclaredMethod("getRpcControllerFactory", new Class[0]);
            getRpcControllerFactoryMethod.setAccessible(true);
            RpcControllerFactory rpcControllerFactory = (RpcControllerFactory)getRpcControllerFactoryMethod.invoke((Object)conn, new Object[0]);
            Method getAdminMethod = clusterConnClazz.getDeclaredMethod("getAdmin", ServerName.class);
            getAdminMethod.setAccessible(true);
            AdminProtos.AdminService.BlockingInterface stub = (AdminProtos.AdminService.BlockingInterface)getAdminMethod.invoke((Object)conn, server);
            return Pair.newPair((Object)rpcControllerFactory, (Object)stub);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("No ClusterConnection, should be HBase 3+", e);
            return null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    private Pair<RpcControllerFactory, AdminProtos.AdminService.BlockingInterface> init3(Connection conn, ServerName server) throws IOException {
        try {
            Method toAsyncConnectionMethod = conn.getClass().getMethod("toAsyncConnection", new Class[0]);
            toAsyncConnectionMethod.setAccessible(true);
            Object asyncConn = toAsyncConnectionMethod.invoke((Object)conn, new Object[0]);
            Field rpcControllerFactoryField = asyncConn.getClass().getDeclaredField("rpcControllerFactory");
            rpcControllerFactoryField.setAccessible(true);
            RpcControllerFactory rpcControllerFactory = (RpcControllerFactory)rpcControllerFactoryField.get(asyncConn);
            Field rpcClientField = asyncConn.getClass().getDeclaredField("rpcClient");
            rpcClientField.setAccessible(true);
            RpcClient rpcClient = (RpcClient)rpcClientField.get(asyncConn);
            Field userField = asyncConn.getClass().getDeclaredField("user");
            userField.setAccessible(true);
            User user = (User)userField.get(asyncConn);
            int rpcTimeoutMs = conn.getConfiguration().getInt("hbase.rpc.timeout", 60000);
            AdminProtos.AdminService.BlockingInterface stub = AdminProtos.AdminService.newBlockingStub((BlockingRpcChannel)rpcClient.createBlockingRpcChannel(server, user, rpcTimeoutMs));
            return Pair.newPair((Object)rpcControllerFactory, (Object)stub);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    public HBCKRegionServerAdmin(Connection conn, ServerName server) throws IOException {
        this.server = server;
        Pair<RpcControllerFactory, AdminProtos.AdminService.BlockingInterface> pair = this.init2(conn, server);
        if (pair == null) {
            pair = this.init3(conn, server);
        }
        this.rpcControllerFactory = (RpcControllerFactory)pair.getFirst();
        this.stub = (AdminProtos.AdminService.BlockingInterface)pair.getSecond();
    }

    public void closeRegion(byte[] regionName) throws IOException {
        HBaseRpcController hrc = this.rpcControllerFactory.newController();
        try {
            this.stub.closeRegion((RpcController)hrc, ProtobufUtil.buildCloseRegionRequest((ServerName)this.server, (byte[])regionName));
        }
        catch (ServiceException e) {
            throw ProtobufUtil.getRemoteException((ServiceException)e);
        }
    }

    public RegionInfo getRegionInfo(byte[] regionName) throws IOException {
        HBaseRpcController hrc = this.rpcControllerFactory.newController();
        try {
            AdminProtos.GetRegionInfoRequest request = RegionInfo.isEncodedRegionName((byte[])regionName) ? AdminProtos.GetRegionInfoRequest.newBuilder().setRegion(RequestConverter.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, (byte[])regionName)).build() : RequestConverter.buildGetRegionInfoRequest((byte[])regionName);
            AdminProtos.GetRegionInfoResponse response = this.stub.getRegionInfo((RpcController)hrc, request);
            return ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)response.getRegionInfo());
        }
        catch (ServiceException e) {
            throw ProtobufUtil.getRemoteException((ServiceException)e);
        }
    }
}

