/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations.security;

import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.ConnectionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.state.AcceptMessages;
import org.apache.geode.internal.protocol.protobuf.v1.state.RequireAuthentication;
import org.apache.geode.internal.protocol.protobuf.v1.state.TerminateConnection;
import org.apache.geode.internal.protocol.protobuf.v1.state.exception.ConnectionStateException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.protocol.serialization.ValueSerializer;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.logging.log4j.Logger;

public class HandshakeRequestOperationHandler
implements ProtobufOperationHandler<ConnectionAPI.HandshakeRequest, ConnectionAPI.HandshakeResponse> {
    private static final Logger logger = LogService.getLogger();

    @Override
    public Result<ConnectionAPI.HandshakeResponse> process(ProtobufSerializationService serializationService, ConnectionAPI.HandshakeRequest request, MessageExecutionContext messageExecutionContext) throws ConnectionStateException {
        String valueFormat;
        boolean authenticated = false;
        if (request.getCredentialsCount() > 0 || messageExecutionContext.getConnectionState() instanceof RequireAuthentication) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)request.getCredentialsMap());
            try {
                messageExecutionContext.authenticate(properties);
                messageExecutionContext.setState(new AcceptMessages());
                authenticated = true;
            }
            catch (AuthenticationFailedException e) {
                messageExecutionContext.getStatistics().incAuthenticationFailures();
                logger.debug("Authentication failed", (Throwable)e);
                messageExecutionContext.setState(new TerminateConnection());
            }
        }
        if ((valueFormat = request.getValueFormat()) != null && !valueFormat.isEmpty()) {
            ValueSerializer newSerializer = this.loadSerializer(valueFormat);
            messageExecutionContext.setValueSerializer(newSerializer);
        }
        return Success.of(ConnectionAPI.HandshakeResponse.newBuilder().setAuthenticated(authenticated).build());
    }

    private ValueSerializer loadSerializer(String valueFormat) throws ConnectionStateException {
        ServiceLoader<ValueSerializer> serviceLoader = ServiceLoader.load(ValueSerializer.class);
        for (ValueSerializer serializer : serviceLoader) {
            if (!serializer.getID().equals(valueFormat)) continue;
            return serializer;
        }
        throw new ConnectionStateException(BasicTypes.ErrorCode.INVALID_REQUEST, "Unable to find a ValueSerializer for format " + valueFormat);
    }
}

