/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.functions;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.CacheClientStatus;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.tier.InternalClientMembership;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.management.runtime.CacheServerInfo;
import org.apache.geode.management.runtime.MemberInformation;

public class GetMemberInformationFunction
implements InternalFunction {
    private static final long serialVersionUID = 1404642539058875565L;

    @Override
    public String getId() {
        return GetMemberInformationFunction.class.getName();
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean isHA() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public void execute(FunctionContext functionContext) {
        try {
            Cache cache = functionContext.getCache();
            InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
            DistributionConfig config = system.getConfig();
            DistributedMember member = ManagementUtils.getDistributedMemberByNameOrId(functionContext.getMemberName(), (InternalCache)functionContext.getCache());
            MemberInformation memberInfo = this.getMemberInformation(cache, config, member);
            functionContext.getResultSender().lastResult(memberInfo);
        }
        catch (Exception e) {
            functionContext.getResultSender().sendException(e);
        }
    }

    public MemberInformation getMemberInformation(Cache cache, DistributionConfig config, DistributedMember member) throws IOException {
        MemberInformation memberInfo = new MemberInformation();
        memberInfo.setMemberName(member.getName());
        memberInfo.setId(member.getId());
        memberInfo.setHost(member.getHost());
        memberInfo.setProcessId(member.getProcessId());
        SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent(config, SecurableCommunicationChannel.WEB);
        memberInfo.setWebSSL(sslConfig.isEnabled());
        memberInfo.setSecured(StringUtils.isNotBlank((CharSequence)config.getSecurityManager()));
        memberInfo.setGroups(config.getGroups());
        memberInfo.setLogFilePath(config.getLogFile().getCanonicalPath());
        memberInfo.setStatArchiveFilePath(config.getStatisticArchiveFile().getCanonicalPath());
        memberInfo.setWorkingDirPath(System.getProperty("user.dir"));
        memberInfo.setCacheXmlFilePath(config.getCacheXmlFile().getCanonicalPath());
        memberInfo.setLocators(config.getLocators());
        memberInfo.setServerBindAddress(config.getServerBindAddress());
        memberInfo.setOffHeapMemorySize(config.getOffHeapMemorySize());
        memberInfo.setHttpServicePort(config.getHttpServicePort());
        memberInfo.setHttpServiceBindAddress(config.getHttpServiceBindAddress());
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memUsage = memoryMXBean.getHeapMemoryUsage();
        memberInfo.setHeapUsage(this.bytesToMeg(memUsage.getUsed()));
        memberInfo.setMaxHeapSize(this.bytesToMeg(memUsage.getMax()));
        memberInfo.setInitHeapSize(this.bytesToMeg(memUsage.getInit()));
        memberInfo.setHostedRegions(ManagementUtils.getAllRegionNames(cache));
        List<CacheServer> csList = cache.getCacheServers();
        if (csList != null && !csList.isEmpty()) {
            memberInfo.setServer(true);
            for (CacheServer cs : csList) {
                CacheServerInfo cacheServerInfo = new CacheServerInfo();
                cacheServerInfo.setBindAddress(cs.getBindAddress());
                cacheServerInfo.setPort(cs.getPort());
                cacheServerInfo.setRunning(cs.isRunning());
                cacheServerInfo.setMaxConnections(cs.getMaxConnections());
                cacheServerInfo.setMaxThreads(cs.getMaxThreads());
                memberInfo.addCacheServerInfo(cacheServerInfo);
            }
            Map allConnectedClients = InternalClientMembership.getStatusForAllClientsIgnoreSubscriptionStatus();
            Iterator it = allConnectedClients.keySet().iterator();
            int numConnections = 0;
            while (it.hasNext()) {
                CacheClientStatus status = (CacheClientStatus)allConnectedClients.get(it.next());
                numConnections += status.getNumberOfConnections();
            }
            memberInfo.setClientCount(numConnections);
            ServerLauncher.ServerState state = ServerLauncher.getServerState();
            if (state != null) {
                memberInfo.setStatus(state.getStatus().getDescription());
            }
        } else {
            LocatorLauncher.LocatorState state;
            memberInfo.setServer(false);
            InternalLocator locator = InternalLocator.getLocator();
            if (locator != null) {
                memberInfo.setLocatorPort(locator.getPort().intValue());
            }
            if ((state = LocatorLauncher.getLocatorState()) != null) {
                memberInfo.setStatus(state.getStatus().getDescription());
            }
        }
        return memberInfo;
    }

    private long bytesToMeg(long bytes) {
        return bytes / 0x100000L;
    }
}

