/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.functions;

import java.util.Set;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.configuration.messages.ConfigurationResponse;
import org.apache.logging.log4j.Logger;

public class GetClusterConfigurationFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();

    @Override
    public void execute(FunctionContext context) {
        Set groups = (Set)context.getArguments();
        InternalLocator internalLocator = InternalLocator.getLocator();
        logger.info("Received request for configuration: {}", (Object)groups);
        if (!internalLocator.isSharedConfigurationEnabled()) {
            String errorMessage = "The cluster configuration service is not enabled on this member.";
            logger.warn(errorMessage);
            context.getResultSender().lastResult(new IllegalStateException(errorMessage));
            return;
        }
        if (internalLocator.isSharedConfigurationRunning()) {
            InternalConfigurationPersistenceService clusterConfigurationService = internalLocator.getConfigurationPersistenceService();
            try {
                ConfigurationResponse response = clusterConfigurationService.createConfigurationResponse(groups);
                context.getResultSender().lastResult(response);
            }
            catch (Exception exception) {
                logger.warn("Unable to retrieve the cluster configuration", (Throwable)exception);
                context.getResultSender().lastResult(exception);
            }
        } else {
            context.getResultSender().lastResult(null);
        }
    }
}

