/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.geode.CancelException;
import org.apache.geode.SerializationException;
import org.apache.geode.SystemFailure;
import org.apache.geode.alerting.internal.spi.AlertingAction;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.ConflationKey;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MemberShunnedException;
import org.apache.geode.distributed.internal.membership.api.Membership;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.monitoring.executor.AbstractExecutor;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.net.ByteBufferSharing;
import org.apache.geode.internal.net.ByteBufferVendor;
import org.apache.geode.internal.net.NioFilter;
import org.apache.geode.internal.net.NioPlainEngine;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.Versioning;
import org.apache.geode.internal.serialization.VersioningIO;
import org.apache.geode.internal.tcp.ByteBufferInputStream;
import org.apache.geode.internal.tcp.ConnectionException;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.internal.tcp.DirectReplySender;
import org.apache.geode.internal.tcp.MsgDestreamer;
import org.apache.geode.internal.tcp.MsgOutputStream;
import org.apache.geode.internal.tcp.MsgReader;
import org.apache.geode.internal.tcp.TCPConduit;
import org.apache.geode.internal.tcp.VersionedByteBufferInputStream;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class Connection
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    public static final String THREAD_KIND_IDENTIFIER = "P2P message reader";
    @MakeNotStatic
    private static int P2P_CONNECT_TIMEOUT;
    @MakeNotStatic
    private static boolean IS_P2P_CONNECT_TIMEOUT_INITIALIZED;
    static final int NORMAL_MSG_TYPE = 76;
    static final int CHUNKED_MSG_TYPE = 77;
    static final int END_CHUNKED_MSG_TYPE = 78;
    static final int DIRECT_ACK_BIT = 32;
    static final int MSG_HEADER_SIZE_OFFSET = 0;
    static final int MSG_HEADER_TYPE_OFFSET = 4;
    static final int MSG_HEADER_ID_OFFSET = 5;
    static final int MSG_HEADER_BYTES = 7;
    public static final int SMALL_BUFFER_SIZE;
    @MakeNotStatic
    private static final AtomicLong ID_COUNTER;
    @VisibleForTesting
    public static final String INITIATING_SUSPECT_PROCESSING = "member unexpectedly shut down shared, unordered connection";
    private final ConnectionTable owner;
    private final TCPConduit conduit;
    private NioFilter ioFilter;
    private volatile boolean isRunning;
    private boolean sharedResource;
    private volatile SystemTimer.SystemTimerTask idleTask;
    private static final boolean DOMINO_THREAD_OWNED_SOCKETS;
    private static final ThreadLocal<Boolean> isDominoThread;
    private final Socket socket;
    private final Object outLock = new Object();
    private final String conduitIdStr;
    private InternalDistributedMember remoteAddr;
    private KnownVersion remoteVersion;
    private final boolean isReceiver;
    private static final ThreadLocal<Integer> dominoCount;
    private int asyncDistributionTimeout;
    private int asyncQueueTimeout;
    private long asyncMaxQueueSize;
    private volatile boolean asyncQueuingInProgress;
    private final Map conflatedKeys = new HashMap();
    private final LinkedList outgoingQueue = new LinkedList();
    private long queuedBytes;
    private Thread pusherThread;
    private volatile boolean handshakeRead;
    private volatile boolean handshakeCancelled;
    private static final byte REPLY_CODE_OK = 69;
    private static final byte REPLY_CODE_OK_WITH_ASYNC_INFO = 70;
    private final Object handshakeSync = new Object();
    private volatile Thread readerThread;
    volatile boolean stopped = true;
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private volatile boolean readerShuttingDown;
    volatile boolean connected;
    private volatile boolean finishedConnecting;
    private volatile boolean accessed = true;
    private volatile boolean socketInUse;
    volatile boolean timedOut;
    private volatile SystemTimer.SystemTimerTask ackTimeoutTask;
    private long transmissionStartTime;
    private long ackWaitTimeout;
    private long ackSATimeout;
    private List ackConnectionGroup;
    private String ackThreadName;
    private ByteBufferVendor inputBufferVendor;
    private int messageLength;
    private byte messageType;
    private short messageId;
    private boolean lengthSet;
    private final Object destreamerLock = new Object();
    private MsgDestreamer idleMsgDestreamer;
    private HashMap destreamerMap;
    private boolean directAck;
    private boolean asyncMode;
    boolean preserveOrder;
    private long messagesSent;
    private long messagesReceived;
    private volatile long uniqueId;
    private int sendBufferSize = -1;
    private int recvBufferSize = -1;
    @MakeNotStatic
    private static final ByteBuffer okHandshakeBuf;
    public static final int MAX_MSG_SIZE = 0xFFFFFF;
    private static final int HANDSHAKE_TIMEOUT_MS;
    private static final byte HANDSHAKE_VERSION = 7;
    private final AtomicBoolean asyncCloseCalled = new AtomicBoolean();
    private static final int CONNECT_HANDSHAKE_SIZE = 4096;
    private static final int RECONNECT_WAIT_TIME;
    private static final boolean BATCH_SENDS;
    private static final int BATCH_BUFFER_SIZE;
    private static final int BATCH_FLUSH_MS;
    private final Object batchLock = new Object();
    private ByteBuffer fillBatchBuffer;
    private ByteBuffer sendBatchBuffer;
    private BatchBufferFlusher batchFlusher;
    private static final boolean SOCKET_WRITE_DISABLED;
    private final Object pusherSync = new Object();
    private boolean disconnectRequested;
    @MutableForTesting
    public static volatile boolean FORCE_ASYNC_QUEUE;
    private static final int MAX_WAIT_TIME = 32;
    private final Object stateLock = new Object();
    private byte connectionState = 0;
    private static final byte STATE_IDLE = 0;
    private static final byte STATE_SENDING = 1;
    private static final byte STATE_POST_SENDING = 2;
    private static final byte STATE_READING_ACK = 3;
    private static final byte STATE_RECEIVED_ACK = 4;
    private static final byte STATE_READING = 5;
    private volatile boolean ackTimedOut;
    private volatile boolean hasResidualReaderThread;

    protected Connection(ConnectionTable connectionTable, Socket socket) throws ConnectionException {
        if (connectionTable == null) {
            throw new IllegalArgumentException("Null ConnectionTable");
        }
        this.conduit = connectionTable.getConduit();
        this.isReceiver = true;
        this.owner = connectionTable;
        this.socket = socket;
        InetSocketAddress conduitSocketId = this.conduit.getSocketId();
        this.conduitIdStr = conduitSocketId.toString();
        this.handshakeRead = false;
        this.handshakeCancelled = false;
        this.connected = true;
        this.asyncMode = false;
        try {
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            this.setSendBufferSize(socket, SMALL_BUFFER_SIZE);
            this.setReceiveBufferSize(socket);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    private ThreadsMonitoring getThreadMonitoring() {
        return this.conduit.getDM().getThreadMonitoring();
    }

    public boolean isSharedResource() {
        return this.sharedResource;
    }

    @VisibleForTesting
    int getP2PConnectTimeout(DistributionConfig config) {
        if (AlertingAction.isThreadAlerting()) {
            return config.getMemberTimeout();
        }
        if (IS_P2P_CONNECT_TIMEOUT_INITIALIZED) {
            return P2P_CONNECT_TIMEOUT;
        }
        String connectTimeoutStr = System.getProperty("p2p.connectTimeout");
        P2P_CONNECT_TIMEOUT = connectTimeoutStr != null ? Integer.parseInt(connectTimeoutStr) : 6 * config.getMemberTimeout();
        IS_P2P_CONNECT_TIMEOUT_INITIALIZED = true;
        return P2P_CONNECT_TIMEOUT;
    }

    private static boolean tipDomino() {
        if (DOMINO_THREAD_OWNED_SOCKETS) {
            ConnectionTable.threadWantsOwnResources();
            isDominoThread.set(Boolean.TRUE);
            return true;
        }
        return false;
    }

    public static boolean isDominoThread() {
        return isDominoThread.get();
    }

    private void setSendBufferSize(Socket sock) {
        this.setSendBufferSize(sock, this.owner.getConduit().tcpBufferSize);
    }

    private void setReceiveBufferSize(Socket sock) {
        this.setReceiveBufferSize(sock, this.owner.getConduit().tcpBufferSize);
    }

    private void setSendBufferSize(Socket sock, int requestedSize) {
        this.setSocketBufferSize(sock, true, requestedSize);
    }

    private void setReceiveBufferSize(Socket sock, int requestedSize) {
        this.setSocketBufferSize(sock, false, requestedSize);
    }

    private void setSocketBufferSize(Socket sock, boolean send, int requestedSize) {
        if (requestedSize > 0) {
            try {
                int currentSize;
                int n = currentSize = send ? sock.getSendBufferSize() : sock.getReceiveBufferSize();
                if (currentSize == requestedSize) {
                    if (send) {
                        this.sendBufferSize = currentSize;
                    }
                    return;
                }
                if (send) {
                    sock.setSendBufferSize(requestedSize);
                } else {
                    sock.setReceiveBufferSize(requestedSize);
                }
            }
            catch (SocketException currentSize) {
                // empty catch block
            }
            try {
                int actualSize;
                int n = actualSize = send ? sock.getSendBufferSize() : sock.getReceiveBufferSize();
                if (send) {
                    this.sendBufferSize = actualSize;
                } else {
                    this.recvBufferSize = actualSize;
                }
                if (actualSize < requestedSize) {
                    logger.info("Socket {} is {} instead of the requested {}.", (Object)(send ? "send buffer size" : "receive buffer size"), (Object)actualSize, (Object)requestedSize);
                } else if (actualSize > requestedSize) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Socket {} buffer size is {} instead of the requested {}", (Object)(send ? "send" : "receive"), (Object)actualSize, (Object)requestedSize);
                    }
                    if (send) {
                        this.sendBufferSize = requestedSize;
                    } else {
                        this.recvBufferSize = requestedSize;
                    }
                }
            }
            catch (SocketException ignore) {
                if (send) {
                    this.sendBufferSize = requestedSize;
                }
                this.recvBufferSize = requestedSize;
            }
        }
    }

    int getSendBufferSize() {
        int result = this.sendBufferSize;
        if (result != -1) {
            return result;
        }
        try {
            result = this.getSocket().getSendBufferSize();
        }
        catch (SocketException ignore) {
            result = this.owner.getConduit().tcpBufferSize;
        }
        this.sendBufferSize = result;
        return result;
    }

    void initReceiver() {
        this.startReader(this.owner);
    }

    void setIdleTimeoutTask(SystemTimer.SystemTimerTask task) {
        this.idleTask = task;
    }

    boolean checkForIdleTimeout() {
        if (this.isSocketClosed()) {
            return true;
        }
        if (this.isSocketInUse() || this.sharedResource && !this.preserveOrder) {
            return false;
        }
        boolean isIdle = !this.accessed;
        this.accessed = false;
        if (isIdle) {
            this.timedOut = true;
            this.owner.getConduit().getStats().incLostLease();
            if (logger.isDebugEnabled()) {
                logger.debug("Closing idle connection {} shared={} ordered={}", (Object)this, (Object)this.sharedResource, (Object)this.preserveOrder);
            }
            try {
                this.closeForReconnect("idle connection timed out");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isIdle;
    }

    static int calcHdrSize(int byteSize) {
        if (byteSize > 0xFFFFFF) {
            throw new IllegalStateException(String.format("tcp message exceeded max size of %s", 0xFFFFFF));
        }
        int hdrSize = byteSize;
        return hdrSize |= 0x7000000;
    }

    static int calcMsgByteSize(int hdrSize) {
        return hdrSize & 0xFFFFFF;
    }

    static void calcHdrVersion(int hdrSize) throws IOException {
        byte ver = (byte)(hdrSize >> 24);
        if (ver != 7) {
            throw new IOException(String.format("Detected wrong version of GemFire product during handshake. Expected %s but found %s", (byte)7, ver));
        }
    }

    private void sendOKHandshakeReply() throws IOException, ConnectionException {
        ByteBuffer my_okHandshakeBuf;
        if (this.isReceiver) {
            DistributionConfig cfg = this.owner.getConduit().getConfig();
            ByteBuffer bb = BufferPool.useDirectBuffers ? ByteBuffer.allocateDirect(128) : ByteBuffer.allocate(128);
            bb.putInt(0);
            bb.put((byte)76);
            bb.putShort((short)-1);
            bb.put((byte)70);
            bb.putInt(cfg.getAsyncDistributionTimeout());
            bb.putInt(cfg.getAsyncQueueTimeout());
            bb.putInt(cfg.getAsyncMaxQueueSize());
            VersioningIO.writeOrdinal((ByteBuffer)bb, (short)KnownVersion.CURRENT.ordinal(), (boolean)true);
            bb.putInt(0, Connection.calcHdrSize(bb.position() - 7));
            my_okHandshakeBuf = bb;
            bb.flip();
        } else {
            my_okHandshakeBuf = okHandshakeBuf;
        }
        my_okHandshakeBuf.position(0);
        this.writeFully(this.getSocket().getChannel(), my_okHandshakeBuf, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void waitForHandshake() throws ConnectionException {
        boolean needToClose = false;
        String reason = null;
        try {
            Object object = this.handshakeSync;
            synchronized (object) {
                block26: {
                    if (!this.handshakeRead && !this.handshakeCancelled) {
                        block25: {
                            reason = "unknown";
                            boolean interrupted = Thread.interrupted();
                            boolean success = false;
                            try {
                                long endTime = System.currentTimeMillis() + (long)HANDSHAKE_TIMEOUT_MS;
                                long msToWait = HANDSHAKE_TIMEOUT_MS;
                                while (!this.handshakeRead && !this.handshakeCancelled && msToWait > 0L) {
                                    this.handshakeSync.wait(msToWait);
                                    if (this.handshakeRead || this.handshakeCancelled) continue;
                                    msToWait = endTime - System.currentTimeMillis();
                                }
                                if (!this.handshakeRead && !this.handshakeCancelled) {
                                    String peerName;
                                    reason = "handshake timed out";
                                    if (this.remoteAddr != null) {
                                        peerName = this.remoteAddr.toString();
                                        this.owner.getDM().getDistribution().suspectMember(this.remoteAddr, String.format("Connection handshake with %s timed out after waiting %s milliseconds.", peerName, HANDSHAKE_TIMEOUT_MS));
                                        throw new ConnectionException(String.format("Connection handshake with %s timed out after waiting %s milliseconds.", peerName, HANDSHAKE_TIMEOUT_MS));
                                    } else {
                                        peerName = "socket " + this.socket.getRemoteSocketAddress() + ":" + this.socket.getPort();
                                    }
                                    throw new ConnectionException(String.format("Connection handshake with %s timed out after waiting %s milliseconds.", peerName, HANDSHAKE_TIMEOUT_MS));
                                }
                                success = this.handshakeRead;
                                if (interrupted) {
                                    Thread.currentThread().interrupt();
                                }
                                if (!success) break block25;
                                if (!this.isReceiver) break block26;
                            }
                            catch (InterruptedException ex) {
                                block27: {
                                    try {
                                        interrupted = true;
                                        this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ex);
                                        reason = "interrupted";
                                        if (interrupted) {
                                            Thread.currentThread().interrupt();
                                        }
                                        if (!success) break block27;
                                        if (!this.isReceiver) break block26;
                                    }
                                    catch (Throwable throwable) {
                                        if (interrupted) {
                                            Thread.currentThread().interrupt();
                                        }
                                        if (success) {
                                            if (!this.isReceiver) throw throwable;
                                            needToClose = !this.owner.getConduit().getMembership().addSurpriseMember((MemberIdentifier)this.remoteAddr);
                                            if (!needToClose) throw throwable;
                                            reason = "this member is shunned";
                                            throw throwable;
                                        } else {
                                            needToClose = true;
                                        }
                                        throw throwable;
                                    }
                                    if (this.owner.getConduit().getMembership().addSurpriseMember((MemberIdentifier)this.remoteAddr)) return;
                                    boolean bl = true;
                                    needToClose = bl;
                                    if (needToClose) {
                                        reason = "this member is shunned";
                                    }
                                }
                                needToClose = true;
                            }
                            if (this.owner.getConduit().getMembership().addSurpriseMember((MemberIdentifier)this.remoteAddr)) return;
                            boolean bl = true;
                            needToClose = bl;
                            if (needToClose) {
                                reason = "this member is shunned";
                            }
                            break block26;
                        }
                        needToClose = true;
                    }
                }
            }
            if (!needToClose) return;
        }
        catch (Throwable throwable) {
            if (!needToClose) throw throwable;
            try {
                this.requestClose(reason);
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.requestClose(reason);
            return;
        }
        catch (Exception exception) {}
    }

    @VisibleForTesting
    void clearSSLInputBuffer() {
        if (this.getConduit().useSSL() && this.ioFilter != null) {
            try (ByteBufferSharing sharedBuffer = this.ioFilter.getUnwrappedBuffer();){
                sharedBuffer.getBuffer().position(0).limit(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void notifyHandshakeWaiter(boolean success) {
        Object object = this.handshakeSync;
        synchronized (object) {
            if (this.handshakeRead || this.handshakeCancelled) {
                return;
            }
            this.clearSSLInputBuffer();
            if (success) {
                this.handshakeRead = true;
            } else {
                this.handshakeCancelled = true;
            }
            this.handshakeSync.notifyAll();
        }
    }

    private void asyncClose(boolean beingSickForTests) {
        Socket s;
        if (beingSickForTests) {
            this.prepareForAsyncClose();
        } else if (this.asyncCloseCalled.compareAndSet(false, true) && (s = this.socket) != null && !s.isClosed()) {
            this.prepareForAsyncClose();
            this.owner.getSocketCloser().asyncClose(s, String.valueOf(this.remoteAddr), () -> this.ioFilter.close(s.getChannel()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareForAsyncClose() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.readerThread != null && this.isRunning && !this.readerShuttingDown && (this.connectionState == 5 || this.connectionState == 3)) {
                this.readerThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAddressCompletion() {
        InternalDistributedMember myAddr;
        InternalDistributedMember internalDistributedMember = myAddr = this.owner.getConduit().getMemberId();
        synchronized (internalDistributedMember) {
            while (!this.owner.getConduit().getCancelCriterion().isCancelInProgress() && myAddr.getInetAddress() == null && myAddr.getVmViewId() < 0) {
                try {
                    myAddr.wait(100L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ie);
                }
            }
            Assert.assertTrue(myAddr.getDirectChannelPort() == this.owner.getConduit().getPort());
        }
    }

    private void handshakeFromNewSender() throws IOException {
        this.waitForAddressCompletion();
        InternalDistributedMember myAddr = this.owner.getConduit().getMemberId();
        try (MsgOutputStream connectHandshake = new MsgOutputStream(4096);){
            connectHandshake.writeByte(0);
            connectHandshake.writeByte(7);
            InternalDataSerializer.invokeToData(myAddr, connectHandshake);
            connectHandshake.writeBoolean(this.sharedResource);
            connectHandshake.writeBoolean(this.preserveOrder);
            connectHandshake.writeLong(this.uniqueId);
            VersioningIO.writeOrdinal((DataOutput)connectHandshake, (short)KnownVersion.CURRENT.ordinal(), (boolean)true);
            connectHandshake.writeInt(dominoCount.get() + 1);
            connectHandshake.setMessageHeader(76, 73, (short)-1);
            this.writeFully(this.getSocket().getChannel(), connectHandshake.getContentBuffer(), false, null);
        }
    }

    private void attemptHandshake(ConnectionTable connTable) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("starting peer-to-peer handshake on socket {}", (Object)this.socket);
        }
        this.handshakeFromNewSender();
        this.startReader(connTable);
        this.waitForHandshake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection createSender(Membership<InternalDistributedMember> mgr, ConnectionTable t, boolean preserveOrder, InternalDistributedMember remoteAddr, boolean sharedResource, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        boolean success = false;
        Connection conn = null;
        boolean interrupted = Thread.interrupted();
        try {
            boolean connectionErrorLogged = false;
            long reconnectWaitTime = RECONNECT_WAIT_TIME;
            boolean suspected = false;
            boolean severeAlertIssued = false;
            boolean firstTime = true;
            boolean warningPrinted = false;
            while (!success) {
                t.getConduit().getCancelCriterion().checkCancelInProgress(null);
                long now = System.currentTimeMillis();
                if (!severeAlertIssued && ackSATimeout > 0L && startTime + ackTimeout < now) {
                    if (startTime + ackTimeout + ackSATimeout < now) {
                        if (remoteAddr != null) {
                            logger.fatal("Unable to form a TCP/IP connection to {} in over {} seconds", (Object)remoteAddr, (Object)((ackSATimeout + ackTimeout) / 1000L));
                        }
                        severeAlertIssued = true;
                    } else if (!suspected) {
                        if (remoteAddr != null) {
                            logger.warn("Unable to form a TCP/IP connection to {} in over {} seconds", (Object)remoteAddr, (Object)(ackTimeout / 1000L));
                        }
                        mgr.suspectMember((MemberIdentifier)remoteAddr, "Unable to form a TCP/IP connection in a reasonable amount of time");
                        suspected = true;
                    }
                    reconnectWaitTime = Math.min((long)RECONNECT_WAIT_TIME, ackSATimeout - (now - startTime - ackTimeout));
                    if (reconnectWaitTime <= 0L) {
                        reconnectWaitTime = RECONNECT_WAIT_TIME;
                    }
                } else if (!suspected && startTime > 0L && ackTimeout > 0L && startTime + ackTimeout < now) {
                    mgr.suspectMember((MemberIdentifier)remoteAddr, "Unable to form a TCP/IP connection in a reasonable amount of time");
                    suspected = true;
                }
                if (firstTime) {
                    firstTime = false;
                    if (!mgr.memberExists((MemberIdentifier)remoteAddr) || mgr.isShunned((MemberIdentifier)remoteAddr) || mgr.shutdownInProgress()) {
                        throw new IOException("Member " + remoteAddr + " left the system");
                    }
                } else {
                    if (AlertingAction.isThreadAlerting()) {
                        throw new IOException("Cannot form connection to alert listener " + remoteAddr);
                    }
                    interrupted = Thread.interrupted() || interrupted;
                    try {
                        Thread.sleep(reconnectWaitTime);
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                        t.getConduit().getCancelCriterion().checkCancelInProgress(ie);
                    }
                    t.getConduit().getCancelCriterion().checkCancelInProgress(null);
                    if (Connection.giveUpOnMember(mgr, remoteAddr)) {
                        throw new IOException(String.format("Member %s left the group", remoteAddr));
                    }
                    if (!warningPrinted) {
                        warningPrinted = true;
                        logger.warn("Connection: Attempting reconnect to peer {}", (Object)remoteAddr);
                    }
                    t.getConduit().getStats().incReconnectAttempts();
                }
                try {
                    conn = null;
                    conn = new Connection(t, preserveOrder, remoteAddr, sharedResource);
                }
                catch (SSLHandshakeException se) {
                    throw se;
                }
                catch (IOException ioe) {
                    if (Connection.giveUpOnMember(mgr, remoteAddr)) {
                        throw ioe;
                    }
                    t.getConduit().getCancelCriterion().checkCancelInProgress(null);
                    if ("Too many open files".equals(ioe.getMessage())) {
                        t.fileDescriptorsExhausted();
                    } else if (!connectionErrorLogged) {
                        connectionErrorLogged = true;
                        logger.info("Connection: shared={} ordered={} failed to connect to peer {} because: {}", (Object)sharedResource, (Object)preserveOrder, (Object)remoteAddr, (Object)(ioe.getCause() != null ? ioe.getCause() : ioe));
                    }
                }
                finally {
                    if (conn == null) {
                        t.getConduit().getStats().incFailedConnect();
                    }
                }
                if (conn == null) continue;
                try {
                    conn.attemptHandshake(t);
                    if (conn.isSocketClosed()) {
                        if (Connection.giveUpOnMember(mgr, remoteAddr)) {
                            throw new IOException(String.format("Member %s left the group", remoteAddr));
                        }
                        t.getConduit().getCancelCriterion().checkCancelInProgress(null);
                        continue;
                    }
                    success = true;
                }
                catch (ConnectionException e) {
                    if (Connection.giveUpOnMember(mgr, remoteAddr)) {
                        throw new IOException("Handshake failed", e);
                    }
                    t.getConduit().getCancelCriterion().checkCancelInProgress(null);
                    logger.info("Connection: shared={} ordered={} handshake failed to connect to peer {} because: {}", (Object)sharedResource, (Object)preserveOrder, (Object)remoteAddr, (Object)e);
                }
                catch (IOException e) {
                    if (Connection.giveUpOnMember(mgr, remoteAddr)) {
                        throw e;
                    }
                    t.getConduit().getCancelCriterion().checkCancelInProgress(null);
                    logger.info("Connection: shared={} ordered={} handshake failed to connect to peer {} because: {}", (Object)sharedResource, (Object)preserveOrder, (Object)remoteAddr, (Object)e);
                    if (sharedResource || !"Too many open files".equals(e.getMessage())) continue;
                    t.fileDescriptorsExhausted();
                }
                finally {
                    if (success) continue;
                    try {
                        conn.requestClose("failed handshake");
                    }
                    catch (Exception e) {}
                    conn = null;
                }
            }
            if (warningPrinted) {
                logger.info("{}: Successfully reestablished connection to peer {}", (Object)mgr.getLocalMember(), (Object)remoteAddr);
            }
        }
        finally {
            try {
                if (!success && conn != null) {
                    conn.requestClose("failed construction");
                    conn = null;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (conn == null) {
            throw new ConnectionException(String.format("Connection: failed construction for peer %s", remoteAddr));
        }
        if (preserveOrder && BATCH_SENDS) {
            conn.createBatchSendBuffer();
        }
        conn.finishedConnecting = true;
        return conn;
    }

    private static boolean giveUpOnMember(Membership<InternalDistributedMember> mgr, InternalDistributedMember remoteAddr) {
        return !mgr.memberExists((MemberIdentifier)remoteAddr) || mgr.isShunned((MemberIdentifier)remoteAddr) || mgr.shutdownInProgress();
    }

    private void setRemoteAddr(InternalDistributedMember m) {
        this.remoteAddr = this.owner.getDM().getCanonicalId(m);
        Membership<InternalDistributedMember> mgr = this.conduit.getMembership();
        mgr.addSurpriseMember((MemberIdentifier)m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection(ConnectionTable t, boolean preserveOrder, InternalDistributedMember remoteID, boolean sharedResource) throws IOException, DistributedSystemDisconnectedException {
        if (t == null) {
            throw new IllegalArgumentException("ConnectionTable is null.");
        }
        this.conduit = t.getConduit();
        this.isReceiver = false;
        this.owner = t;
        this.sharedResource = sharedResource;
        this.preserveOrder = preserveOrder;
        this.setRemoteAddr(remoteID);
        this.conduitIdStr = this.owner.getConduit().getSocketId().toString();
        this.handshakeRead = false;
        this.handshakeCancelled = false;
        this.connected = true;
        this.asyncMode = false;
        this.uniqueId = ID_COUNTER.getAndIncrement();
        InetSocketAddress addr = new InetSocketAddress(remoteID.getInetAddress(), remoteID.getDirectChannelPort());
        SocketChannel channel = SocketChannel.open();
        this.owner.addConnectingSocket(channel.socket(), addr.getAddress());
        try {
            channel.socket().setTcpNoDelay(true);
            channel.socket().setKeepAlive(SocketCreator.ENABLE_TCP_KEEP_ALIVE);
            if (!sharedResource) {
                this.setReceiveBufferSize(channel.socket(), this.owner.getConduit().tcpBufferSize);
            } else {
                this.setReceiveBufferSize(channel.socket(), SMALL_BUFFER_SIZE);
            }
            this.setSendBufferSize(channel.socket());
            channel.configureBlocking(true);
            int connectTime = this.getP2PConnectTimeout(this.conduit.getDM().getConfig());
            try {
                channel.socket().connect(addr, connectTime);
                this.createIoFilter(channel, true);
            }
            catch (NullPointerException e) {
                ConnectException c = new ConnectException("Encountered bug #45044 - retrying");
                c.initCause(e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                throw c;
            }
            catch (SSLException e) {
                ConnectException c = new ConnectException("Problem connecting to peer " + addr);
                c.initCause(e);
                throw c;
            }
            catch (CancelledKeyException | ClosedSelectorException e) {
                ConnectException c = new ConnectException(String.format("Attempt timed out after %s milliseconds", connectTime));
                c.initCause(e);
                throw c;
            }
        }
        finally {
            this.owner.removeConnectingSocket(channel.socket());
        }
        this.socket = channel.socket();
        if (logger.isDebugEnabled()) {
            logger.debug("Connection: connected to {} with IP address {}", (Object)remoteID, (Object)addr);
        }
        try {
            this.getSocket().setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    private void createBatchSendBuffer() {
        if (BufferPool.useDirectBuffers) {
            this.fillBatchBuffer = ByteBuffer.allocateDirect(BATCH_BUFFER_SIZE);
            this.sendBatchBuffer = ByteBuffer.allocateDirect(BATCH_BUFFER_SIZE);
        } else {
            this.fillBatchBuffer = ByteBuffer.allocate(BATCH_BUFFER_SIZE);
            this.sendBatchBuffer = ByteBuffer.allocate(BATCH_BUFFER_SIZE);
        }
        this.batchFlusher = new BatchBufferFlusher();
        this.batchFlusher.start();
    }

    void cleanUpOnIdleTaskCancel() {
        if (this.isReceiver) {
            this.owner.removeReceiver(this);
        }
    }

    private void closeBatchBuffer() {
        if (this.batchFlusher != null) {
            this.batchFlusher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void batchSend(ByteBuffer src) {
        if (SOCKET_WRITE_DISABLED) {
            return;
        }
        long start = DistributionStats.getStatTime();
        try {
            Assert.assertTrue(src.remaining() <= BATCH_BUFFER_SIZE, "Message size(" + src.remaining() + ") exceeded BATCH_BUFFER_SIZE(" + BATCH_BUFFER_SIZE + ")");
            while (true) {
                ByteBuffer dst;
                Object object = this.batchLock;
                synchronized (object) {
                    dst = this.fillBatchBuffer;
                    if (src.remaining() <= dst.remaining()) {
                        long copyStart = DistributionStats.getStatTime();
                        dst.put(src);
                        this.owner.getConduit().getStats().incBatchCopyTime(copyStart);
                        return;
                    }
                }
                this.batchFlusher.flushBuffer(dst);
            }
        }
        finally {
            this.owner.getConduit().getStats().incBatchSendTime(start);
        }
    }

    void requestClose(String reason) {
        this.close(reason, true, false, false, false);
    }

    boolean isClosing() {
        return this.closing.get();
    }

    void closePartialConnect(String reason, boolean beingSick) {
        this.close(reason, false, false, beingSick, false);
    }

    void closeForReconnect(String reason) {
        this.close(reason, true, false, false, false);
    }

    void closeOldConnection(String reason) {
        this.close(reason, true, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void close(String reason, boolean cleanupEndpoint, boolean p_removeEndpoint, boolean beingSick, boolean forceRemoval) {
        block41: {
            block42: {
                block43: {
                    boolean removeEndpoint;
                    block36: {
                        block35: {
                            block40: {
                                block38: {
                                    block39: {
                                        block37: {
                                            boolean onlyCleanup = this.closing.getAndSet(true);
                                            if (onlyCleanup && !forceRemoval) {
                                                return;
                                            }
                                            removeEndpoint = p_removeEndpoint;
                                            if (onlyCleanup) break block36;
                                            Connection connection = this;
                                            // MONITORENTER : connection
                                            this.stopped = true;
                                            if (!this.connected) break block37;
                                            if (!this.asyncQueuingInProgress || this.pusherThread == Thread.currentThread()) break block38;
                                            LinkedList linkedList = this.outgoingQueue;
                                            // MONITORENTER : linkedList
                                            break block39;
                                        }
                                        if (!forceRemoval) {
                                            removeEndpoint = false;
                                        }
                                        break block40;
                                    }
                                    while (this.asyncQueuingInProgress) {
                                        boolean interrupted = Thread.interrupted();
                                        try {
                                            this.outgoingQueue.wait();
                                        }
                                        catch (InterruptedException ie) {
                                            interrupted = true;
                                        }
                                        finally {
                                            if (!interrupted) continue;
                                            Thread.currentThread().interrupt();
                                        }
                                    }
                                    // MONITOREXIT : linkedList
                                }
                                this.connected = false;
                                DMStats stats = this.owner.getConduit().getStats();
                                if (this.finishedConnecting) {
                                    if (this.isReceiver) {
                                        stats.decReceivers();
                                    } else {
                                        stats.decSenders(this.sharedResource, this.preserveOrder);
                                    }
                                }
                            }
                            this.asyncClose(false);
                            if (!this.isReceiver && !this.hasResidualReaderThread()) {
                                this.inputBufferVendor.destruct();
                            }
                            this.lengthSet = false;
                            // MONITOREXIT : connection
                            this.notifyHandshakeWaiter(false);
                            boolean isIBM = false;
                            if (this.conduit.getConfig().getEnableNetworkPartitionDetection() || this.conduit.getMemberId().getVmKind() == 12 || this.conduit.getMemberId().getVmKind() == 11) {
                                isIBM = "IBM Corporation".equals(System.getProperty("java.vm.vendor"));
                            }
                            Thread readerThreadSnapshot = this.readerThread;
                            if (!beingSick && readerThreadSnapshot != null && !isIBM && this.isRunning && !this.readerShuttingDown && readerThreadSnapshot != Thread.currentThread()) {
                                try {
                                    readerThreadSnapshot.join(500L);
                                    readerThreadSnapshot = this.readerThread;
                                    if (!this.isRunning || this.readerShuttingDown || readerThreadSnapshot == null || this.owner.getDM().getRootCause() != null) break block35;
                                    readerThreadSnapshot.join(1500L);
                                    if (this.isRunning) {
                                        logger.info("Timed out waiting for readerThread on {} to finish.", (Object)this);
                                    }
                                }
                                catch (IllegalThreadStateException interrupted) {
                                }
                                catch (InterruptedException ignore) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                        this.closeBatchBuffer();
                        this.closeAllMsgDestreamers();
                    }
                    if (!cleanupEndpoint) break block41;
                    if (this.isReceiver) {
                        this.owner.removeReceiver(this);
                    }
                    if (!removeEndpoint) break block42;
                    if (!this.sharedResource) break block43;
                    if (!this.preserveOrder) {
                        if (!this.isReceiver && this.finishedConnecting) {
                            this.owner.removeEndpoint(this.remoteAddr, reason);
                        }
                        break block41;
                    } else {
                        this.owner.removeSharedConnection(reason, this.remoteAddr, this.preserveOrder, this);
                    }
                    break block41;
                }
                if (!this.isReceiver) {
                    this.owner.removeThreadConnection(this.remoteAddr, this);
                }
                break block41;
            }
            if (this.sharedResource) {
                this.owner.removeSharedConnection(reason, this.remoteAddr, this.preserveOrder, this);
            } else if (!this.isReceiver) {
                this.owner.removeThreadConnection(this.remoteAddr, this);
            }
        }
        if (this.idleTask != null) {
            SystemTimer.SystemTimerTask systemTimerTask = this.idleTask;
            // MONITORENTER : systemTimerTask
            this.idleTask.cancel();
            // MONITOREXIT : systemTimerTask
        }
        if (this.ackTimeoutTask == null) return;
        SystemTimer.SystemTimerTask systemTimerTask = this.ackTimeoutTask;
        // MONITORENTER : systemTimerTask
        this.ackTimeoutTask.cancel();
        // MONITOREXIT : systemTimerTask
    }

    private void startReader(ConnectionTable connTable) {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting thread for " + this.p2pReaderName());
        }
        Assert.assertTrue(!this.isRunning);
        this.stopped = false;
        this.isRunning = true;
        connTable.executeCommand(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.readerThread = Thread.currentThread();
        this.readerThread.setName(this.p2pReaderName());
        ConnectionTable.threadWantsSharedResources();
        try {
            this.readMessages();
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("Stopping {} for {}", (Object)this.p2pReaderName(), (Object)this.remoteAddr);
            }
            if (this.isReceiver) {
                try {
                    this.initiateSuspicionIfSharedUnordered();
                }
                catch (CancelException cancelException) {}
                if (!this.sharedResource) {
                    this.conduit.getStats().incThreadOwnedReceivers(-1L, dominoCount.get());
                }
                this.asyncClose(false);
                this.owner.removeAndCloseThreadOwnedSockets();
            } else if (this.sharedResource && !this.asyncMode) {
                this.asyncClose(false);
            }
            this.inputBufferVendor.destruct();
            this.notifyHandshakeWaiter(false);
            this.readerThread.setName("unused p2p reader");
            Object object = this.stateLock;
            synchronized (object) {
                this.isRunning = false;
                this.readerThread = null;
            }
        }
    }

    BufferPool getBufferPool() {
        return this.owner.getBufferPool();
    }

    private String p2pReaderName() {
        StringBuilder sb = new StringBuilder(64);
        if (this.isReceiver) {
            sb.append("P2P message reader@");
        } else if (this.handshakeRead) {
            sb.append("P2P message sender@");
        } else {
            sb.append("P2P handshake reader@");
        }
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        if (!this.isReceiver) {
            sb.append('-').append(this.getUniqueId());
        }
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    private void readMessages() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createIoFilter(SocketChannel channel, boolean clientSocket) throws IOException {
        if (this.getConduit().useSSL() && channel != null) {
            InetSocketAddress address = (InetSocketAddress)channel.getRemoteAddress();
            SSLEngine engine = this.getConduit().getSocketCreator().createSSLEngine(address.getHostString(), address.getPort(), clientSocket);
            int packetBufferSize = engine.getSession().getPacketBufferSize();
            this.inputBufferVendor = new ByteBufferVendor(this.getBufferPool().acquireDirectReceiveBuffer(packetBufferSize), BufferPool.BufferType.TRACKED_RECEIVER, this.getBufferPool());
            if (channel.socket().getReceiveBufferSize() < packetBufferSize) {
                channel.socket().setReceiveBufferSize(packetBufferSize);
            }
            if (channel.socket().getSendBufferSize() < packetBufferSize) {
                channel.socket().setSendBufferSize(packetBufferSize);
            }
            try (ByteBufferSharing inputSharing = this.inputBufferVendor.open();){
                ByteBuffer inputBuffer = inputSharing.getBuffer();
                this.ioFilter = this.getConduit().getSocketCreator().handshakeSSLSocketChannel(channel, engine, this.getConduit().idleConnectionTimeout, inputBuffer, this.getBufferPool());
            }
        } else {
            int allocSize = this.recvBufferSize == -1 ? this.owner.getConduit().tcpBufferSize : this.recvBufferSize;
            this.inputBufferVendor = new ByteBufferVendor(this.getBufferPool().acquireDirectReceiveBuffer(allocSize), BufferPool.BufferType.TRACKED_RECEIVER, this.getBufferPool());
            this.ioFilter = new NioPlainEngine(this.getBufferPool());
        }
    }

    private void initiateSuspicionIfSharedUnordered() {
        if (this.isReceiver && this.handshakeRead && !this.preserveOrder && this.sharedResource && !this.owner.getConduit().getCancelCriterion().isCancelInProgress()) {
            this.owner.getDM().getDistribution().suspectMember(this.getRemoteAddress(), INITIATING_SUSPECT_PROCESSING);
        }
    }

    private static boolean isIgnorableIOException(Exception e) {
        if (e instanceof ClosedChannelException) {
            return true;
        }
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.toString();
        }
        msg = msg.toLowerCase();
        if (e instanceof SSLException && msg.contains("status = closed")) {
            return true;
        }
        return msg.contains("forcibly closed") || msg.contains("reset by peer") || msg.contains("connection reset") || msg.contains("socket is closed");
    }

    private static boolean validMsgType(int msgType) {
        return msgType == 76 || msgType == 77 || msgType == 78;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllMsgDestreamers() {
        Object object = this.destreamerLock;
        synchronized (object) {
            if (this.idleMsgDestreamer != null) {
                this.idleMsgDestreamer.close();
                this.idleMsgDestreamer = null;
            }
            if (this.destreamerMap != null) {
                for (Object o : this.destreamerMap.values()) {
                    MsgDestreamer md = (MsgDestreamer)o;
                    md.close();
                }
                this.destreamerMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MsgDestreamer obtainMsgDestreamer(short msgId, KnownVersion v) {
        Object object = this.destreamerLock;
        synchronized (object) {
            Short key;
            MsgDestreamer result;
            if (this.destreamerMap == null) {
                this.destreamerMap = new HashMap();
            }
            if ((result = (MsgDestreamer)this.destreamerMap.get(key = Short.valueOf(msgId))) == null) {
                result = this.idleMsgDestreamer;
                if (result != null) {
                    this.idleMsgDestreamer = null;
                } else {
                    result = new MsgDestreamer(this.owner.getConduit().getStats(), this.conduit.getCancelCriterion(), v);
                }
                result.setName(this.p2pReaderName() + " msgId=" + msgId);
                this.destreamerMap.put(key, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseMsgDestreamer(short msgId, MsgDestreamer md) {
        Object object = this.destreamerLock;
        synchronized (object) {
            this.destreamerMap.remove(msgId);
            if (this.idleMsgDestreamer == null) {
                md.reset();
                this.idleMsgDestreamer = md;
            } else {
                md.close();
            }
        }
    }

    private void sendFailureReply(int rpId, String exMsg, Throwable ex, boolean directAck) {
        ReplyException exception = new ReplyException(exMsg, ex);
        if (directAck) {
            DirectReplySender dm = new DirectReplySender(this);
            ReplyMessage.send(this.getRemoteAddress(), rpId, exception, (ReplySender)dm);
        } else if (rpId != 0) {
            DistributionManager dm = this.owner.getDM();
            dm.getExecutors().getWaitingThreadPool().execute(() -> ReplyMessage.send(this.getRemoteAddress(), rpId, exception, (ReplySender)dm));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPreserialized(ByteBuffer buffer, boolean cacheContentChanges, DistributionMessage msg) throws IOException, ConnectionException {
        byte originalState;
        if (!this.connected) {
            throw new ConnectionException(String.format("Not connected to %s", this.remoteAddr));
        }
        if (this.batchFlusher != null) {
            this.batchSend(buffer);
            return;
        }
        boolean origSocketInUse = this.socketInUse;
        Object object = this.stateLock;
        synchronized (object) {
            originalState = this.connectionState;
            this.connectionState = 1;
        }
        this.socketInUse = true;
        try {
            SocketChannel channel = this.getSocket().getChannel();
            this.writeFully(channel, buffer, false, msg);
            if (cacheContentChanges) {
                ++this.messagesSent;
            }
        }
        finally {
            this.accessed();
            this.socketInUse = origSocketInUse;
            object = this.stateLock;
            synchronized (object) {
                this.connectionState = originalState;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInUse(boolean use, long startTime, long ackWaitThreshold, long ackSAThreshold, List connectionGroup) {
        Connection connection = this;
        synchronized (connection) {
            if (use && (ackWaitThreshold > 0L || ackSAThreshold > 0L)) {
                this.transmissionStartTime = startTime;
                this.ackWaitTimeout = ackWaitThreshold;
                this.ackSATimeout = ackSAThreshold;
                this.ackConnectionGroup = connectionGroup;
                this.ackThreadName = Thread.currentThread().getName();
            } else {
                this.ackWaitTimeout = 0L;
                this.ackSATimeout = 0L;
                this.ackConnectionGroup = null;
                this.ackThreadName = null;
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.connectionState = 0;
            }
            this.socketInUse = use;
        }
        if (!use) {
            this.accessed();
        }
    }

    @VisibleForTesting
    void setSharedUnorderedForTest() {
        this.preserveOrder = false;
        this.sharedResource = true;
        this.handshakeRead = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void scheduleAckTimeouts() {
        if (this.ackTimeoutTask == null) {
            long msAW = (long)this.owner.getDM().getConfig().getAckWaitThreshold() * 1000L;
            long msSA = (long)this.owner.getDM().getConfig().getAckSevereAlertThreshold() * 1000L;
            this.ackTimeoutTask = new SystemTimer.SystemTimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run2() {
                    byte connState;
                    if (Connection.this.isSocketClosed()) {
                        this.cancel();
                        return;
                    }
                    if (Connection.this.owner.isClosed()) {
                        this.cancel();
                        return;
                    }
                    Object object = Connection.this.stateLock;
                    synchronized (object) {
                        connState = Connection.this.connectionState;
                    }
                    boolean sentAlert = false;
                    Connection connection = Connection.this;
                    synchronized (connection) {
                        if (Connection.this.socketInUse) {
                            switch (connState) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    sentAlert = Connection.this.doSevereAlertProcessing();
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                                case 3: {
                                    sentAlert = Connection.this.doSevereAlertProcessing();
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                            }
                        }
                    }
                    List group = Connection.this.ackConnectionGroup;
                    if (sentAlert && group != null) {
                        for (Object o : group) {
                            Connection con = (Connection)o;
                            if (con == Connection.this) continue;
                            Connection connection2 = con;
                            connection2.transmissionStartTime = connection2.transmissionStartTime + con.ackSATimeout;
                        }
                    }
                }
            };
            ConnectionTable connectionTable = this.owner;
            synchronized (connectionTable) {
                SystemTimer timer = this.owner.getIdleConnTimer();
                if (timer != null) {
                    SystemTimer.SystemTimerTask systemTimerTask = this.ackTimeoutTask;
                    synchronized (systemTimerTask) {
                        if (!this.ackTimeoutTask.isCancelled()) {
                            if (msSA > 0L) {
                                timer.scheduleAtFixedRate(this.ackTimeoutTask, msAW, Math.min(msAW, msSA));
                            } else {
                                timer.schedule(this.ackTimeoutTask, msAW);
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean doSevereAlertProcessing() {
        long now = System.currentTimeMillis();
        if (this.ackSATimeout > 0L && this.transmissionStartTime + this.ackWaitTimeout + this.ackSATimeout <= now) {
            logger.fatal("{} seconds have elapsed waiting for a response from {} for thread {}", (Object)((this.ackWaitTimeout + this.ackSATimeout) / 1000L), (Object)this.getRemoteAddress(), (Object)this.ackThreadName);
            this.ackSATimeout = 0L;
            return true;
        }
        if (!this.ackTimedOut && 0L < this.ackWaitTimeout && this.transmissionStartTime + this.ackWaitTimeout <= now) {
            String state;
            logger.warn("{} seconds have elapsed waiting for a response from {} for thread {}", (Object)(this.ackWaitTimeout / 1000L), (Object)this.getRemoteAddress(), (Object)this.ackThreadName);
            this.ackTimedOut = true;
            String string = state = this.connectionState == 1 ? "Sender has been unable to transmit a message within ack-wait-threshold seconds" : "Sender has been unable to receive a response to a message within ack-wait-threshold seconds";
            if (this.ackSATimeout > 0L) {
                this.owner.getDM().getDistribution().suspectMembers(Collections.singleton(this.getRemoteAddress()), state);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean addToQueue(ByteBuffer buffer, DistributionMessage msg, boolean force) throws ConnectionException {
        long newQueueSize;
        boolean didConflation;
        int origBufferPos;
        int newBytes;
        Object objToQueue;
        long start;
        DMStats stats;
        block15: {
            ConflationKey ck;
            block16: {
                block17: {
                    ByteBuffer oldBuffer;
                    block18: {
                        stats = this.owner.getConduit().getStats();
                        start = DistributionStats.getStatTime();
                        try {
                            ck = null;
                            if (msg != null) {
                                ck = msg.getConflationKey();
                            }
                            objToQueue = null;
                            newBytes = buffer.remaining();
                            origBufferPos = buffer.position();
                            if (ck == null || !ck.allowsConflation()) {
                                ByteBuffer newbb = ByteBuffer.allocate(newBytes);
                                newbb.put(buffer);
                                newbb.flip();
                                objToQueue = newbb;
                            }
                            LinkedList linkedList = this.outgoingQueue;
                            // MONITORENTER : linkedList
                            if (this.disconnectRequested) {
                                buffer.position(origBufferPos);
                                throw new ConnectionException(String.format("Forced disconnect sent to %s", this.remoteAddr));
                            }
                            if (!force && !this.asyncQueuingInProgress) {
                                buffer.position(origBufferPos);
                                boolean bl = false;
                                // MONITOREXIT : linkedList
                                if (!DistributionStats.enableClockStats) return bl;
                                stats.incAsyncQueueAddTime(DistributionStats.getStatTime() - start);
                                return bl;
                            }
                            didConflation = false;
                            if (ck == null) break block15;
                            if (!ck.allowsConflation()) break block16;
                            objToQueue = ck;
                            ConflationKey oldValue = this.conflatedKeys.put(ck, ck);
                            if (oldValue == null) break block17;
                            ConflationKey oldck = oldValue;
                            oldBuffer = oldck.getBuffer();
                            oldck.setBuffer(null);
                            if (this.outgoingQueue.getLast() != oldck) break block18;
                            this.outgoingQueue.removeLast();
                        }
                        catch (Throwable throwable) {
                            if (!DistributionStats.enableClockStats) throw throwable;
                            stats.incAsyncQueueAddTime(DistributionStats.getStatTime() - start);
                            throw throwable;
                        }
                    }
                    int oldBytes = oldBuffer.remaining();
                    this.queuedBytes -= (long)oldBytes;
                    stats.incAsyncQueueSize(-oldBytes);
                    stats.incAsyncConflatedMsgs();
                    didConflation = true;
                    if (oldBuffer.capacity() >= newBytes) {
                        oldBuffer.clear();
                        oldBuffer.put(buffer);
                        oldBuffer.flip();
                        ck.setBuffer(oldBuffer);
                        break block15;
                    } else {
                        ByteBuffer newbb = ByteBuffer.allocate(newBytes);
                        newbb.put(buffer);
                        newbb.flip();
                        ck.setBuffer(newbb);
                    }
                    break block15;
                }
                ByteBuffer newbb = ByteBuffer.allocate(newBytes);
                newbb.put(buffer);
                newbb.flip();
                ck.setBuffer(newbb);
                break block15;
            }
            this.conflatedKeys.remove(ck);
        }
        if ((newQueueSize = (long)newBytes + this.queuedBytes) > this.asyncMaxQueueSize) {
            logger.warn("Queued bytes {} exceeds max of {}, asking slow receiver {} to disconnect.", (Object)newQueueSize, (Object)this.asyncMaxQueueSize, (Object)this.remoteAddr);
            stats.incAsyncQueueSizeExceeded(1);
            this.disconnectSlowReceiver();
            buffer.position(origBufferPos);
            boolean bl = false;
            // MONITOREXIT : linkedList
            if (!DistributionStats.enableClockStats) return bl;
            stats.incAsyncQueueAddTime(DistributionStats.getStatTime() - start);
            return bl;
        }
        this.outgoingQueue.addLast(objToQueue);
        this.queuedBytes += (long)newBytes;
        stats.incAsyncQueueSize(newBytes);
        if (!didConflation) {
            stats.incAsyncQueuedMsgs();
        }
        boolean bl = true;
        // MONITOREXIT : linkedList
        if (!DistributionStats.enableClockStats) return bl;
        stats.incAsyncQueueAddTime(DistributionStats.getStatTime() - start);
        return bl;
    }

    private boolean handleBlockedWrite(ByteBuffer buffer, DistributionMessage msg) throws ConnectionException {
        if (!this.addToQueue(buffer, msg, true)) {
            return false;
        }
        this.startMessagePusher();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startMessagePusher() {
        Object object = this.pusherSync;
        synchronized (object) {
            while (true) {
                if (this.pusherThread == null) {
                    this.asyncQueuingInProgress = true;
                    this.pusherThread = new LoggingThread("P2P async pusher to " + this.remoteAddr, this::runMessagePusher);
                    // MONITOREXIT @DISABLED, blocks:[3, 7, 8] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.pusherThread.start();
                    return;
                }
                boolean interrupted = Thread.interrupted();
                try {
                    this.pusherSync.wait();
                    continue;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ex);
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer takeFromOutgoingQueue() {
        DMStats stats = this.owner.getConduit().getStats();
        long start = DistributionStats.getStatTime();
        try {
            ByteBuffer result = null;
            LinkedList linkedList = this.outgoingQueue;
            synchronized (linkedList) {
                Object o;
                block11: {
                    if (!this.disconnectRequested) break block11;
                    this.asyncQueuingInProgress = false;
                    this.outgoingQueue.notifyAll();
                    ByteBuffer byteBuffer = null;
                    return byteBuffer;
                }
                while (!this.outgoingQueue.isEmpty() && (o = this.outgoingQueue.removeFirst()) != null) {
                    block13: {
                        block14: {
                            block12: {
                                if (!(o instanceof ConflationKey)) break block12;
                                result = ((ConflationKey)o).getBuffer();
                                if (result == null) break block13;
                                this.conflatedKeys.remove(o);
                                break block14;
                            }
                            result = (ByteBuffer)o;
                        }
                        int newBytes = result.remaining();
                        this.queuedBytes -= (long)newBytes;
                        stats.incAsyncQueueSize(-newBytes);
                        stats.incAsyncDequeuedMsgs();
                    }
                    if (result == null) continue;
                }
                if (result == null) {
                    this.asyncQueuingInProgress = false;
                    this.outgoingQueue.notifyAll();
                }
            }
            linkedList = result;
            return linkedList;
        }
        finally {
            if (DistributionStats.enableClockStats) {
                stats.incAsyncQueueRemoveTime(DistributionStats.getStatTime() - start);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectSlowReceiver() {
        LinkedList linkedList = this.outgoingQueue;
        synchronized (linkedList) {
            if (this.disconnectRequested) {
                return;
            }
            this.disconnectRequested = true;
        }
        DistributionManager dm = this.owner.getDM();
        if (dm == null) {
            this.owner.removeEndpoint(this.remoteAddr, "no distribution manager");
            return;
        }
        dm.getDistribution().requestMemberRemoval(this.remoteAddr, "Disconnected as a slow-receiver");
        while (dm.getOtherDistributionManagerIds().contains(this.remoteAddr)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ie);
                return;
            }
        }
        this.owner.removeEndpoint(this.remoteAddr, "Force disconnect timed out");
        if (dm.getOtherDistributionManagerIds().contains(this.remoteAddr) && logger.isDebugEnabled()) {
            int FORCE_TIMEOUT = 3000;
            logger.debug("Force disconnect timed out after waiting {} seconds", (Object)3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runMessagePusher() {
        try {
            DMStats stats = this.owner.getConduit().getStats();
            long threadStart = stats.startAsyncThread();
            try {
                stats.incAsyncQueues(1);
                stats.incAsyncThreads(1);
                try {
                    int flushId = 0;
                    while (this.asyncQueuingInProgress) {
                        if (!this.connected) return;
                        if (SystemFailure.getFailure() != null) {
                            Socket s = this.socket;
                            if (s != null) {
                                try {
                                    logger.debug("closing socket", (Throwable)new Exception("closing socket"));
                                    this.ioFilter.close(s.getChannel());
                                    s.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            SystemFailure.checkFailure();
                        }
                        if (this.owner.getConduit().getCancelCriterion().isCancelInProgress()) {
                            return;
                        }
                        ++flushId;
                        long flushStart = stats.startAsyncQueueFlush();
                        try {
                            long curQueuedBytes = this.queuedBytes;
                            if (curQueuedBytes > this.asyncMaxQueueSize) {
                                logger.warn("Queued bytes {} exceeds max of {}, asking slow receiver {} to disconnect.", (Object)curQueuedBytes, (Object)this.asyncMaxQueueSize, (Object)this.remoteAddr);
                                stats.incAsyncQueueSizeExceeded(1);
                                this.disconnectSlowReceiver();
                                return;
                            }
                            SocketChannel channel = this.getSocket().getChannel();
                            ByteBuffer bb = this.takeFromOutgoingQueue();
                            if (bb == null) {
                                if (!logger.isDebugEnabled()) return;
                                if (flushId != 1) return;
                                logger.debug("P2P pusher found empty queue");
                                return;
                            }
                            this.writeFully(channel, bb, true, null);
                            this.accessed();
                        }
                        finally {
                            stats.endAsyncQueueFlush(flushStart);
                        }
                    }
                    return;
                }
                finally {
                    LinkedList flushId = this.outgoingQueue;
                    synchronized (flushId) {
                        this.asyncQueuingInProgress = false;
                        this.outgoingQueue.notifyAll();
                    }
                }
            }
            catch (IOException ex) {
                String err = String.format("P2P pusher io exception for %s", this);
                if (!this.isSocketClosed() && logger.isDebugEnabled() && !Connection.isIgnorableIOException(ex)) {
                    logger.debug(err, (Throwable)ex);
                }
                try {
                    this.requestClose(err + ": " + ex);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                    return;
                }
            }
            catch (CancelException ex) {
                String err = String.format("P2P pusher %s caught CacheClosedException: %s", this, ex);
                logger.debug(err);
                try {
                    this.requestClose(err);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (Exception ex2) {
                    this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ex2);
                    if (!this.isSocketClosed()) {
                        logger.fatal(String.format("P2P pusher exception: %s", ex2), (Throwable)ex2);
                    }
                    try {
                        this.requestClose(String.format("P2P pusher exception: %s", ex2));
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                        return;
                    }
                }
            }
            finally {
                stats.incAsyncQueueSize(-this.queuedBytes);
                this.queuedBytes = 0L;
                stats.endAsyncThread(threadStart);
                stats.incAsyncThreads(-1);
                stats.incAsyncQueues(-1);
                if (logger.isDebugEnabled()) {
                    logger.debug("runMessagePusher terminated id={} from {}/{}", (Object)this.conduitIdStr, (Object)this.remoteAddr, (Object)this.remoteAddr);
                }
            }
        }
        finally {
            Object object = this.pusherSync;
            synchronized (object) {
                this.pusherThread = null;
                this.pusherSync.notifyAll();
            }
        }
    }

    private boolean useSyncWrites(boolean forceAsync) {
        if (forceAsync) {
            return false;
        }
        if (this.asyncQueuingInProgress) {
            return true;
        }
        if (this.isReceiver) {
            return true;
        }
        if (!this.preserveOrder) {
            return true;
        }
        return this.asyncDistributionTimeout == 0;
    }

    /*
     * Exception decompiling
     */
    private void writeAsync(SocketChannel channel, ByteBuffer buffer, boolean forceAsync, DistributionMessage p_msg, DMStats stats) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 20[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void writeFully(SocketChannel channel, ByteBuffer buffer, boolean forceAsync, DistributionMessage msg) throws IOException, ConnectionException {
        DMStats stats = this.owner.getConduit().getStats();
        if (!this.sharedResource) {
            stats.incTOSentMsg();
        }
        if (this.useSyncWrites(forceAsync)) {
            if (this.asyncQueuingInProgress && this.addToQueue(buffer, msg, false)) {
                return;
            }
            long startLock = stats.startSocketLock();
            Object object = this.outLock;
            synchronized (object) {
                stats.endSocketLock(startLock);
                if (this.asyncQueuingInProgress && this.addToQueue(buffer, msg, false)) {
                    return;
                }
                try (ByteBufferSharing outputSharing = this.ioFilter.wrap(buffer);){
                    ByteBuffer wrappedBuffer = outputSharing.getBuffer();
                    while (wrappedBuffer.remaining() > 0) {
                        int amtWritten = 0;
                        long start = stats.startSocketWrite(true);
                        try {
                            amtWritten = channel.write(wrappedBuffer);
                        }
                        finally {
                            stats.endSocketWrite(true, start, amtWritten, 0);
                        }
                    }
                }
            }
        }
        this.writeAsync(channel, buffer, forceAsync, msg, stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAck(DirectReplyProcessor processor) throws SocketTimeoutException, ConnectionException {
        if (this.isSocketClosed()) {
            throw new ConnectionException("connection is closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.connectionState = (byte)3;
        }
        boolean origSocketInUse = this.socketInUse;
        this.socketInUse = true;
        MsgReader msgReader = null;
        DMStats stats = this.owner.getConduit().getStats();
        KnownVersion version = this.getRemoteVersion();
        try {
            int len;
            ReplyMessage msg;
            msgReader = new MsgReader(this, this.ioFilter, version);
            try (ByteBufferSharing _unused = this.ioFilter.getUnwrappedBuffer();){
                MsgReader.Header header = msgReader.readHeader();
                if (header.getMessageType() == 76) {
                    msg = (ReplyMessage)msgReader.readMessage(header);
                    len = header.getMessageLength();
                } else {
                    MsgDestreamer destreamer = this.obtainMsgDestreamer(header.getMessageId(), version);
                    while (header.getMessageType() == 77) {
                        msgReader.readChunk(header, destreamer);
                        header = msgReader.readHeader();
                    }
                    msgReader.readChunk(header, destreamer);
                    msg = (ReplyMessage)destreamer.getMessage();
                    this.releaseMsgDestreamer(header.getMessageId(), destreamer);
                    len = destreamer.size();
                }
            }
            DistributionManager dm = this.owner.getDM();
            msg.setBytesRead(len);
            msg.setSender(this.remoteAddr);
            stats.incReceivedMessages(1L);
            stats.incReceivedBytes(msg.getBytesRead());
            stats.incMessageChannelTime(msg.resetTimestamp());
            msg.process(dm, processor);
        }
        catch (SocketTimeoutException timeout) {
            throw timeout;
        }
        catch (IOException e) {
            String err = String.format("ack read io exception for %s", this);
            if (!this.isSocketClosed() && logger.isDebugEnabled() && !Connection.isIgnorableIOException(e)) {
                logger.debug(err, (Throwable)e);
            }
            try {
                this.requestClose(err + ": " + e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ConnectionException(String.format("Unable to read direct ack because: %s", e));
        }
        catch (ConnectionException e) {
            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(e);
            throw e;
        }
        catch (Exception e) {
            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(e);
            if (!this.isSocketClosed()) {
                logger.fatal("ack read exception", (Throwable)e);
            }
            try {
                this.requestClose(String.format("ack read exception: %s", e));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ConnectionException(String.format("Unable to read direct ack because: %s", e));
        }
        finally {
            stats.incProcessedMessages(1L);
            this.accessed();
            this.socketInUse = origSocketInUse;
            if (this.ackTimedOut) {
                logger.info("Finished waiting for reply from {}", (Object)this.getRemoteAddress());
                this.ackTimedOut = false;
            }
            if (msgReader != null) {
                msgReader.close();
            }
        }
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.connectionState = (byte)4;
        }
    }

    private void processInputBuffer(AbstractExecutor threadMonitorExecutor) throws ConnectionException, IOException {
        try (ByteBufferSharing inputSharing = this.inputBufferVendor.open();){
            ByteBuffer inputBuffer = inputSharing.getBuffer();
            inputBuffer.flip();
            try (ByteBufferSharing sharedBuffer = this.ioFilter.unwrap(inputBuffer);){
                ByteBuffer peerDataBuffer = sharedBuffer.getBuffer();
                peerDataBuffer.flip();
                boolean done = false;
                while (true) {
                    if (done || !this.connected) break;
                    this.owner.getConduit().getCancelCriterion().checkCancelInProgress(null);
                    int remaining = peerDataBuffer.remaining();
                    if (this.lengthSet || remaining >= 7) {
                        int allocSize;
                        if (!this.lengthSet && this.readMessageHeader(peerDataBuffer)) {
                            break;
                        }
                        if (remaining >= this.messageLength + 7) {
                            this.lengthSet = false;
                            peerDataBuffer.position(peerDataBuffer.position() + 7);
                            int startPos = peerDataBuffer.position();
                            int oldLimit = peerDataBuffer.limit();
                            peerDataBuffer.limit(startPos + this.messageLength);
                            if (this.handshakeRead) {
                                try {
                                    this.readMessage(peerDataBuffer, threadMonitorExecutor);
                                }
                                catch (SerializationException e) {
                                    logger.info("input buffer startPos {} oldLimit {}", (Object)startPos, (Object)oldLimit);
                                    throw e;
                                }
                            }
                            try (ByteBufferInputStream bbis = new ByteBufferInputStream(peerDataBuffer);
                                 DataInputStream dis = new DataInputStream(bbis);){
                                if (!this.isReceiver) {
                                    this.readHandshakeForSender(dis, peerDataBuffer);
                                    return;
                                }
                                if (this.readHandshakeForReceiver(dis)) {
                                    this.ioFilter.doneReading(peerDataBuffer);
                                    return;
                                }
                            }
                            if (!this.connected) continue;
                            this.accessed();
                            peerDataBuffer.limit(oldLimit);
                            peerDataBuffer.position(startPos + this.messageLength);
                            continue;
                        }
                        done = true;
                        if (this.getConduit().useSSL()) {
                            this.ioFilter.doneReading(peerDataBuffer);
                            continue;
                        }
                        int oldBufferSize = inputBuffer.capacity();
                        if (oldBufferSize < (allocSize = this.messageLength + 7)) {
                            logger.info("Allocating larger network read buffer, new size is {} old size was {}.", (Object)allocSize, (Object)oldBufferSize);
                            inputBuffer = inputSharing.expandReadBufferIfNeeded(allocSize);
                            this.makeReadableBufferWriteable(inputBuffer);
                            continue;
                        }
                        if (inputBuffer.position() != 0) {
                            inputBuffer.compact();
                            continue;
                        }
                        this.makeReadableBufferWriteable(inputBuffer);
                        continue;
                    }
                    this.ioFilter.doneReading(peerDataBuffer);
                    done = true;
                }
            }
        }
    }

    private void makeReadableBufferWriteable(ByteBuffer inputBuffer) {
        inputBuffer.position(inputBuffer.limit());
        inputBuffer.limit(inputBuffer.capacity());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readHandshakeForReceiver(DataInput dis) {
        try {
            byte b = dis.readByte();
            if (b != 0) {
                throw new IllegalStateException(String.format("Detected old version (pre 5.0.1) of GemFire or non-GemFire during handshake due to initial byte being %s", b));
            }
            byte handshakeByte = dis.readByte();
            if (handshakeByte != 7) {
                throw new IllegalStateException(String.format("Detected wrong version of GemFire product during handshake. Expected %s but found %s", (byte)7, handshakeByte));
            }
            this.remoteAddr = DSFIDFactory.readInternalDistributedMember(dis);
            this.sharedResource = dis.readBoolean();
            this.preserveOrder = dis.readBoolean();
            this.uniqueId = dis.readLong();
            this.remoteVersion = Versioning.getKnownVersionOrDefault((Version)Versioning.getVersion((short)VersioningIO.readOrdinal((DataInput)dis)), null);
            int dominoNumber = 0;
            if (this.remoteVersion == null || this.remoteVersion.isNotOlderThan((Version)KnownVersion.GFE_80)) {
                dominoNumber = dis.readInt();
                if (this.sharedResource) {
                    dominoNumber = 0;
                }
                dominoCount.set(dominoNumber);
            }
            if (!this.sharedResource) {
                if (Connection.tipDomino()) {
                    logger.info("thread owned receiver forcing itself to send on thread owned sockets");
                } else {
                    ConnectionTable.threadWantsOwnResources();
                    if (logger.isDebugEnabled()) {
                        logger.debug("thread-owned receiver with domino count of {} will prefer sending on thread-owned sockets", (Object)dominoNumber);
                    }
                }
                this.conduit.getStats().incThreadOwnedReceivers(1L, dominoNumber);
                this.setSendBufferSize(this.socket);
            }
            this.setThreadName(dominoNumber);
        }
        catch (Exception e) {
            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(e);
            logger.fatal("Error deserializing P2P handshake message", (Throwable)e);
            this.readerShuttingDown = true;
            this.requestClose("Error deserializing P2P handshake message");
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("P2P handshake remoteAddr is {}{}", (Object)this.remoteAddr, (Object)(this.remoteVersion != null ? " (" + this.remoteVersion + ')' : ""));
        }
        try {
            boolean isSecure;
            String authInit = System.getProperty("gemfire.sys.security-peer-auth-init");
            boolean bl = isSecure = authInit != null && !authInit.isEmpty();
            if (isSecure) {
                if (!this.owner.getConduit().waitForMembershipCheck(this.remoteAddr)) {
                    this.notifyHandshakeWaiter(false);
                    logger.warn("{} timed out during a membership check.", (Object)this.p2pReaderName());
                    return true;
                }
                this.sendOKHandshakeReply();
                this.notifyHandshakeWaiter(true);
            } else {
                this.sendOKHandshakeReply();
                try {
                    this.notifyHandshakeWaiter(true);
                }
                catch (Exception e) {
                    logger.fatal("Uncaught exception from listener", (Throwable)e);
                }
            }
            this.finishedConnecting = true;
            return false;
        }
        catch (IOException ex) {
            String err = "Failed sending handshake reply";
            if (logger.isDebugEnabled()) {
                logger.debug("Failed sending handshake reply", (Throwable)ex);
            }
            this.readerShuttingDown = true;
            this.requestClose("Failed sending handshake reply: " + ex);
            return true;
        }
    }

    private boolean readMessageHeader(ByteBuffer peerDataBuffer) throws IOException {
        int headerStartPos = peerDataBuffer.position();
        this.messageLength = peerDataBuffer.getInt();
        Connection.calcHdrVersion(this.messageLength);
        this.messageLength = Connection.calcMsgByteSize(this.messageLength);
        this.messageType = peerDataBuffer.get();
        this.messageId = peerDataBuffer.getShort();
        boolean bl = this.directAck = (this.messageType & 0x20) != 0;
        if (this.directAck) {
            this.messageType = (byte)(this.messageType & 0xFFFFFFDF);
        }
        if (!Connection.validMsgType(this.messageType)) {
            Integer nioMessageTypeInteger = this.messageType;
            logger.fatal("Unknown P2P message type: {}", (Object)nioMessageTypeInteger);
            this.readerShuttingDown = true;
            this.requestClose(String.format("Unknown P2P message type: %s", nioMessageTypeInteger));
            return true;
        }
        this.lengthSet = true;
        peerDataBuffer.position(headerStartPos);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readMessage(ByteBuffer peerDataBuffer, AbstractExecutor threadMonitorExecutor) {
        int msgLength;
        if (this.messageType == 76) {
            this.owner.getConduit().getStats().incMessagesBeingReceived(true, this.messageLength);
            try (ByteBufferInputStream bbis = this.remoteVersion == null ? new ByteBufferInputStream(peerDataBuffer) : new VersionedByteBufferInputStream(peerDataBuffer, this.remoteVersion);){
                DistributionMessage msg;
                ReplyProcessor21.initMessageRPId();
                long startSer = this.owner.getConduit().getStats().startMsgDeserialization();
                int n = peerDataBuffer.position();
                try {
                    msg = (DistributionMessage)InternalDataSerializer.readDSFID(bbis);
                }
                catch (SerializationException e) {
                    logger.info("input buffer starting position {}  current position {} limit {} capacity {} message length {}", (Object)n, (Object)peerDataBuffer.position(), (Object)peerDataBuffer.limit(), (Object)peerDataBuffer.capacity(), (Object)this.messageLength);
                    throw e;
                }
                this.owner.getConduit().getStats().endMsgDeserialization(startSer);
                if (bbis.available() != 0) {
                    logger.warn("Message deserialization of {} did not read {} bytes.", (Object)msg, (Object)bbis.available());
                }
                try {
                    if (this.dispatchMessage(msg, this.messageLength, this.directAck, threadMonitorExecutor)) return;
                    this.directAck = false;
                    return;
                }
                catch (MemberShunnedException e) {
                    this.directAck = false;
                    return;
                }
                catch (Exception de) {
                    this.owner.getConduit().getCancelCriterion().checkCancelInProgress(de);
                    logger.fatal("Error dispatching message", (Throwable)de);
                    return;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.fatal("Throwable dispatching message", t);
                    return;
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                logger.fatal("Error deserializing message", t);
                SystemFailure.checkFailure();
                this.sendFailureReply(ReplyProcessor21.getMessageRPId(), "Error deserializing message", t, this.directAck);
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                if (!(t instanceof CancelException) || t instanceof CacheClosedException) return;
                throw (CancelException)t;
            }
            finally {
                ReplyProcessor21.clearMessageRPId();
            }
        }
        if (this.messageType == 77) {
            MsgDestreamer md = this.obtainMsgDestreamer(this.messageId, this.remoteVersion);
            this.owner.getConduit().getStats().incMessagesBeingReceived(md.size() == 0, this.messageLength);
            try {
                md.addChunk(peerDataBuffer, this.messageLength);
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        MsgDestreamer md = this.obtainMsgDestreamer(this.messageId, this.remoteVersion);
        this.owner.getConduit().getStats().incMessagesBeingReceived(md.size() == 0, this.messageLength);
        try {
            md.addChunk(peerDataBuffer, this.messageLength);
        }
        catch (IOException ex) {
            logger.fatal("Failed handling end chunk message", (Throwable)ex);
        }
        DistributionMessage msg = null;
        String failureMsg = null;
        Object var7_18 = null;
        int rpId = 0;
        boolean interrupted = false;
        try {
            msg = md.getMessage();
        }
        catch (ClassNotFoundException ex) {
            this.owner.getConduit().getStats().decMessagesBeingReceived(md.size());
            failureMsg = "ClassNotFound deserializing message";
            ClassNotFoundException classNotFoundException = ex;
            rpId = md.getRPid();
            this.logAtInfoAndFatal(failureMsg, classNotFoundException);
        }
        catch (IOException ex) {
            this.owner.getConduit().getStats().decMessagesBeingReceived(md.size());
            failureMsg = "IOException deserializing message";
            IOException iOException = ex;
            rpId = md.getRPid();
            this.logAtInfoAndFatal(failureMsg, iOException);
        }
        catch (InterruptedException ex) {
            interrupted = true;
            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ex);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(ex);
            this.owner.getConduit().getStats().decMessagesBeingReceived(md.size());
            failureMsg = "Unexpected failure deserializing message";
            Throwable throwable = ex;
            rpId = md.getRPid();
            this.logAtInfoAndFatal(failureMsg, throwable);
        }
        finally {
            msgLength = md.size();
            this.releaseMsgDestreamer(this.messageId, md);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (msg != null) {
            try {
                if (this.dispatchMessage(msg, msgLength, this.directAck, threadMonitorExecutor)) return;
                this.directAck = false;
                return;
            }
            catch (MemberShunnedException e) {
                this.directAck = false;
                return;
            }
            catch (Exception de) {
                this.owner.getConduit().getCancelCriterion().checkCancelInProgress(de);
                logger.fatal("Error dispatching message", (Throwable)de);
                return;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.fatal("Throwable dispatching message", t);
                return;
            }
        } else {
            void var7_22;
            if (var7_22 == null) return;
            this.sendFailureReply(rpId, failureMsg, (Throwable)var7_22, this.directAck);
        }
    }

    private void logAtInfoAndFatal(String failureMsg, Throwable failureEx) {
        logger.info(failureMsg, failureEx);
        logger.fatal(failureMsg, (Object)failureEx.toString());
    }

    void readHandshakeForSender(DataInputStream dis, ByteBuffer peerDataBuffer) {
        try {
            int replyCode = dis.readUnsignedByte();
            switch (replyCode) {
                case 69: {
                    this.ioFilter.doneReading(peerDataBuffer);
                    this.notifyHandshakeWaiter(true);
                    return;
                }
                case 70: {
                    this.asyncDistributionTimeout = dis.readInt();
                    this.asyncQueueTimeout = dis.readInt();
                    this.asyncMaxQueueSize = (long)dis.readInt() * 0x100000L;
                    if (this.asyncDistributionTimeout != 0) {
                        logger.info("{} async configuration received {}.", (Object)this.p2pReaderName(), (Object)(" asyncDistributionTimeout=" + this.asyncDistributionTimeout + " asyncQueueTimeout=" + this.asyncQueueTimeout + " asyncMaxQueueSize=" + this.asyncMaxQueueSize / 0x100000L));
                    }
                    this.remoteVersion = Versioning.getKnownVersionOrDefault((Version)Versioning.getVersion((short)VersioningIO.readOrdinal((DataInput)dis)), null);
                    this.ioFilter.doneReading(peerDataBuffer);
                    this.notifyHandshakeWaiter(true);
                    if (this.preserveOrder && this.asyncDistributionTimeout != 0) {
                        this.asyncMode = true;
                    }
                    return;
                }
            }
            String err = "Unknown handshake reply code: " + replyCode + " messageLength: " + this.messageLength;
            if (replyCode == 0 && logger.isDebugEnabled()) {
                logger.debug(err + " (peer probably departed ungracefully)");
            } else {
                logger.fatal(err);
            }
            this.readerShuttingDown = true;
            this.requestClose(err);
        }
        catch (Exception e) {
            this.owner.getConduit().getCancelCriterion().checkCancelInProgress(e);
            logger.fatal("Error deserializing P2P handshake reply", (Throwable)e);
            this.readerShuttingDown = true;
            this.requestClose("Error deserializing P2P handshake reply");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.fatal("Throwable deserializing P2P handshake reply", t);
            this.readerShuttingDown = true;
            this.requestClose("Throwable deserializing P2P handshake reply");
        }
    }

    private void setThreadName(int dominoNumber) {
        Thread.currentThread().setName("P2P message reader for " + this.remoteAddr + " " + (this.sharedResource ? "" : "un") + "shared " + (this.preserveOrder ? "" : "un") + "ordered sender uid=" + this.uniqueId + (dominoNumber > 0 ? " dom #" + dominoNumber : "") + " local port=" + this.socket.getLocalPort() + " remote port=" + this.socket.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatchMessage(DistributionMessage msg, int bytesRead, boolean directAck, AbstractExecutor threadMonitorExecutor) throws MemberShunnedException {
        threadMonitorExecutor.resumeMonitoring();
        try {
            msg.setDoDecMessagesBeingReceived(true);
            if (directAck) {
                Assert.assertTrue(!this.isSharedResource(), "We were asked to send a direct reply on a shared socket");
                msg.setReplySender(new DirectReplySender(this));
            }
            this.owner.getConduit().messageReceived(this, msg, bytesRead);
            boolean bl = true;
            return bl;
        }
        finally {
            threadMonitorExecutor.suspendMonitoring();
            if (msg.containsRegionContentChange()) {
                ++this.messagesReceived;
            }
        }
    }

    TCPConduit getConduit() {
        return this.conduit;
    }

    protected Socket getSocket() throws SocketException {
        Socket result = this.socket;
        if (result == null) {
            throw new SocketException("socket has been closed");
        }
        return result;
    }

    boolean isSocketClosed() {
        return this.socket.isClosed() || !this.socket.isConnected();
    }

    boolean isReceiverStopped() {
        return this.stopped;
    }

    private boolean isSocketInUse() {
        return this.socketInUse;
    }

    protected void accessed() {
        this.accessed = true;
    }

    public InternalDistributedMember getRemoteAddress() {
        return this.remoteAddr;
    }

    KnownVersion getRemoteVersion() {
        return this.remoteVersion;
    }

    public String toString() {
        return this.remoteAddr + "(uid=" + this.uniqueId + ")" + (this.remoteVersion != null && this.remoteVersion != KnownVersion.CURRENT ? "(v" + this.remoteVersion.toString() + ')' : "");
    }

    boolean getOriginatedHere() {
        return !this.isReceiver;
    }

    @VisibleForTesting
    public boolean hasResidualReaderThread() {
        return this.hasResidualReaderThread;
    }

    boolean getPreserveOrder() {
        return this.preserveOrder;
    }

    protected long getUniqueId() {
        return this.uniqueId;
    }

    long getMessagesReceived() {
        return this.messagesReceived;
    }

    long getMessagesSent() {
        return this.messagesSent;
    }

    static {
        SMALL_BUFFER_SIZE = Integer.getInteger("gemfire.SMALL_BUFFER_SIZE", 4096);
        ID_COUNTER = new AtomicLong(1L);
        DOMINO_THREAD_OWNED_SOCKETS = Boolean.getBoolean("p2p.ENABLE_DOMINO_THREAD_OWNED_SOCKETS");
        isDominoThread = ThreadLocal.withInitial(() -> Boolean.FALSE);
        dominoCount = ThreadLocal.withInitial(() -> 0);
        int msglen = 1;
        byte[] bytes = new byte[7 + msglen];
        msglen = Connection.calcHdrSize(msglen);
        bytes[0] = (byte)(msglen / 0x1000000 & 0xFF);
        bytes[1] = (byte)(msglen / 65536 & 0xFF);
        bytes[2] = (byte)(msglen / 256 & 0xFF);
        bytes[3] = (byte)(msglen & 0xFF);
        bytes[4] = 76;
        bytes[5] = -1;
        bytes[6] = -1;
        bytes[7] = 69;
        int allocSize = bytes.length;
        ByteBuffer bb = BufferPool.useDirectBuffers ? ByteBuffer.allocateDirect(allocSize) : ByteBuffer.allocate(allocSize);
        bb.put(bytes);
        okHandshakeBuf = bb;
        HANDSHAKE_TIMEOUT_MS = Integer.getInteger("p2p.handshakeTimeoutMs", 59000);
        RECONNECT_WAIT_TIME = Integer.getInteger("gemfire.RECONNECT_WAIT_TIME", 2000);
        BATCH_SENDS = Boolean.getBoolean("p2p.batchSends");
        BATCH_BUFFER_SIZE = Integer.getInteger("p2p.batchBufferSize", 0x100000);
        BATCH_FLUSH_MS = Integer.getInteger("p2p.batchFlushTime", 50);
        SOCKET_WRITE_DISABLED = Boolean.getBoolean("p2p.disableSocketWrite");
    }

    private class BatchBufferFlusher
    extends Thread {
        private volatile boolean flushNeeded;
        private volatile boolean timeToStop;
        private final DMStats stats;

        BatchBufferFlusher() {
            this.setDaemon(true);
            this.stats = Connection.this.owner.getConduit().getStats();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void flushBuffer(ByteBuffer bb) {
            long start = DistributionStats.getStatTime();
            try {
                Object object = this;
                synchronized (object) {
                    Object object2 = Connection.this.batchLock;
                    synchronized (object2) {
                        if (bb != Connection.this.fillBatchBuffer) {
                            return;
                        }
                    }
                    this.flushNeeded = true;
                    this.notifyAll();
                }
                object = Connection.this.batchLock;
                synchronized (object) {
                    while (bb == Connection.this.fillBatchBuffer) {
                        Connection.this.owner.getConduit().getCancelCriterion().checkCancelInProgress(null);
                        boolean interrupted = Thread.interrupted();
                        try {
                            Connection.this.batchLock.wait();
                        }
                        catch (InterruptedException ex) {
                            interrupted = true;
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                        }
                    }
                    return;
                }
            }
            finally {
                Connection.this.owner.getConduit().getStats().incBatchWaitTime(start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            BatchBufferFlusher batchBufferFlusher = this;
            synchronized (batchBufferFlusher) {
                this.timeToStop = true;
                this.flushNeeded = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BatchBufferFlusher batchBufferFlusher = this;
                synchronized (batchBufferFlusher) {
                    while (!this.timeToStop) {
                        if (!this.flushNeeded && Connection.this.fillBatchBuffer.position() <= BATCH_BUFFER_SIZE / 2) {
                            this.wait(BATCH_FLUSH_MS);
                        }
                        if (!this.flushNeeded && Connection.this.fillBatchBuffer.position() <= BATCH_BUFFER_SIZE / 2) continue;
                        long start = DistributionStats.getStatTime();
                        Object object = Connection.this.batchLock;
                        synchronized (object) {
                            this.flushNeeded = false;
                            ByteBuffer tmp = Connection.this.fillBatchBuffer;
                            Connection.this.fillBatchBuffer = Connection.this.sendBatchBuffer;
                            Connection.this.sendBatchBuffer = tmp;
                            Connection.this.batchLock.notifyAll();
                        }
                        if (Connection.this.sendBatchBuffer.position() > 0) {
                            boolean origSocketInUse = Connection.this.socketInUse;
                            Connection.this.socketInUse = true;
                            try {
                                Connection.this.sendBatchBuffer.flip();
                                SocketChannel channel = Connection.this.getSocket().getChannel();
                                Connection.this.writeFully(channel, Connection.this.sendBatchBuffer, false, null);
                                Connection.this.sendBatchBuffer.clear();
                            }
                            catch (IOException | ConnectionException ex) {
                                logger.fatal("Exception flushing batch send buffer: %s", (Throwable)ex);
                                Connection.this.readerShuttingDown = true;
                                Connection.this.requestClose(String.format("Exception flushing batch send buffer: %s", ex));
                            }
                            finally {
                                Connection.this.accessed();
                                Connection.this.socketInUse = origSocketInUse;
                            }
                        }
                        this.stats.incBatchFlushTime(start);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

