/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.geode.DataSerializer;
import org.apache.geode.LogWriter;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.tier.Encryptor;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.GemFireSecurityException;

public class EncryptorImpl
implements Encryptor {
    private static final BigInteger dhP = new BigInteger("135287020639910739997189928970717021771311421882765429190887700940242697307989907008041927806610978529253822307916592536509818186767394634756714063947534092593553024224277712367371302394452615862654308111809029797196494501056604787763641987260783383085570220968104473500348898008043285865193451061481841186553");
    private static final BigInteger dhG = new BigInteger("130583456807197150961665134075139695376245536366239321690167044250081505657615277976871655435431431908701485776974110415733273525810283593126577393912282416840649805564834470583437473176415335737232689814802018696718110109967325936556664646275595822588612548788965341273697569202082715873518528062345259949959");
    private static final int dhL = 1023;
    private Cipher _encrypt;
    private Cipher _decrypt;
    private PublicKey clientPublicKey;
    private String clientSKAlgo;
    @MakeNotStatic
    private static PrivateKey dhPrivateKey;
    @MakeNotStatic
    private static PublicKey dhPublicKey;
    @MakeNotStatic
    private static String dhSKAlgo;
    @MakeNotStatic
    private static String certificateFilePath;
    @MakeNotStatic
    private static HashMap certificateMap;
    @MakeNotStatic
    private static String privateKeyAlias;
    @MakeNotStatic
    private static String privateKeySubject;
    @MakeNotStatic
    private static PrivateKey privateKeyEncrypt;
    @MakeNotStatic
    private static String privateKeySignAlgo;
    @MakeNotStatic
    private static SecureRandom random;
    private byte appSecureMode = 0;
    private LogWriter logWriter;

    EncryptorImpl(EncryptorImpl encryptor) {
        this.appSecureMode = encryptor.appSecureMode;
        this.logWriter = encryptor.logWriter;
    }

    public EncryptorImpl(LogWriter logWriter) {
        this.logWriter = logWriter;
    }

    void setAppSecureMode(byte appSecureMode) {
        this.appSecureMode = appSecureMode;
    }

    public static byte[] decryptBytes(byte[] data, Cipher decrypt) throws Exception {
        return decrypt.doFinal(data);
    }

    protected Cipher getDecryptCipher(String dhSKAlgo, PublicKey publicKey) throws Exception {
        if (this._decrypt == null) {
            Cipher decrypt;
            KeyAgreement ka = KeyAgreement.getInstance("DH");
            ka.init(dhPrivateKey);
            ka.doPhase(publicKey, true);
            int keysize = EncryptorImpl.getKeySize(dhSKAlgo);
            int blocksize = EncryptorImpl.getBlockSize(dhSKAlgo);
            if (keysize == -1 || blocksize == -1) {
                SecretKey sKey = ka.generateSecret(dhSKAlgo);
                decrypt = Cipher.getInstance(dhSKAlgo);
                decrypt.init(2, sKey);
            } else {
                String algoStr = EncryptorImpl.getDhAlgoStr(dhSKAlgo);
                byte[] sKeyBytes = ka.generateSecret();
                SecretKeySpec sks = new SecretKeySpec(sKeyBytes, 0, keysize, algoStr);
                IvParameterSpec ivps = new IvParameterSpec(sKeyBytes, keysize, blocksize);
                decrypt = Cipher.getInstance(algoStr + "/CBC/PKCS5Padding");
                decrypt.init(2, (Key)sks, ivps);
            }
            this._decrypt = decrypt;
        }
        return this._decrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCertsMap(Properties props) throws Exception {
        certificateMap = new HashMap();
        certificateFilePath = props.getProperty("security-client-kspath");
        if (certificateFilePath != null && certificateFilePath.length() > 0) {
            KeyStore ks = KeyStore.getInstance("JKS");
            String keyStorePass = props.getProperty("security-client-kspasswd");
            char[] passPhrase = keyStorePass != null ? keyStorePass.toCharArray() : null;
            try (FileInputStream keystorefile = new FileInputStream(certificateFilePath);){
                ks.load(keystorefile, passPhrase);
            }
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = ks.getCertificate(alias);
                if (!(cert instanceof X509Certificate)) continue;
                String subject = ((X509Certificate)cert).getSubjectDN().getName();
                certificateMap.put(subject, cert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPrivateKey(Properties props) throws Exception {
        String privateKeyFilePath = props.getProperty("security-server-kspath");
        privateKeyAlias = "";
        privateKeyEncrypt = null;
        if (privateKeyFilePath != null && privateKeyFilePath.length() > 0) {
            String keyStorePass;
            KeyStore ks = KeyStore.getInstance("PKCS12");
            privateKeyAlias = props.getProperty("security-server-ksalias");
            if (privateKeyAlias == null) {
                privateKeyAlias = "";
            }
            char[] passPhrase = (keyStorePass = props.getProperty("security-server-kspasswd")) != null ? keyStorePass.toCharArray() : null;
            try (FileInputStream privateKeyFile = new FileInputStream(privateKeyFilePath);){
                ks.load(privateKeyFile, passPhrase);
            }
            Key key = ks.getKey(privateKeyAlias, passPhrase);
            Certificate keyCert = ks.getCertificate(privateKeyAlias);
            if (key instanceof PrivateKey && keyCert instanceof X509Certificate) {
                privateKeyEncrypt = (PrivateKey)key;
                privateKeySignAlgo = ((X509Certificate)keyCert).getSigAlgName();
                privateKeySubject = ((X509Certificate)keyCert).getSubjectDN().getName();
            }
        }
    }

    public static void initDHKeys(DistributionConfig config) throws Exception {
        dhSKAlgo = config.getSecurityClientDHAlgo();
        dhPrivateKey = null;
        dhPublicKey = null;
        if (dhSKAlgo != null && dhSKAlgo.length() > 0) {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DH");
            DHParameterSpec dhSpec = new DHParameterSpec(dhP, dhG, 1023);
            keyGen.initialize(dhSpec);
            KeyPair keypair = keyGen.generateKeyPair();
            dhPrivateKey = keypair.getPrivate();
            dhPublicKey = keypair.getPublic();
            random = new SecureRandom();
            byte[] someBytes = new byte[48];
            random.nextBytes(someBytes);
        }
    }

    @Override
    public byte[] decryptBytes(byte[] data) throws Exception {
        if (this.appSecureMode == 2) {
            String algo = null;
            algo = this.clientSKAlgo != null ? this.clientSKAlgo : dhSKAlgo;
            Cipher c = this.getDecryptCipher(algo, this.clientPublicKey);
            return EncryptorImpl.decryptBytes(data, c);
        }
        return data;
    }

    @Override
    public byte[] encryptBytes(byte[] data) throws Exception {
        if (this.appSecureMode == 2) {
            String algo = null;
            algo = this.clientSKAlgo != null ? this.clientSKAlgo : dhSKAlgo;
            return EncryptorImpl.encryptBytes(data, this.getEncryptCipher(algo, this.clientPublicKey));
        }
        return data;
    }

    public static byte[] encryptBytes(byte[] data, Cipher encrypt) throws Exception {
        return encrypt.doFinal(data);
    }

    protected Cipher getEncryptCipher(String dhSKAlgo, PublicKey publicKey) throws Exception {
        if (this._encrypt == null) {
            Cipher encrypt;
            KeyAgreement ka = KeyAgreement.getInstance("DH");
            ka.init(dhPrivateKey);
            ka.doPhase(publicKey, true);
            int keysize = EncryptorImpl.getKeySize(dhSKAlgo);
            int blocksize = EncryptorImpl.getBlockSize(dhSKAlgo);
            if (keysize == -1 || blocksize == -1) {
                SecretKey sKey = ka.generateSecret(dhSKAlgo);
                encrypt = Cipher.getInstance(dhSKAlgo);
                encrypt.init(1, sKey);
            } else {
                String dhAlgoStr = EncryptorImpl.getDhAlgoStr(dhSKAlgo);
                byte[] sKeyBytes = ka.generateSecret();
                SecretKeySpec sks = new SecretKeySpec(sKeyBytes, 0, keysize, dhAlgoStr);
                IvParameterSpec ivps = new IvParameterSpec(sKeyBytes, keysize, blocksize);
                encrypt = Cipher.getInstance(dhAlgoStr + "/CBC/PKCS5Padding");
                encrypt.init(1, (Key)sks, ivps);
            }
            this._encrypt = encrypt;
        }
        return this._encrypt;
    }

    boolean isEnabled() {
        return dhSKAlgo != null && dhSKAlgo.length() > 0;
    }

    byte writeEncryptedCredential(DataOutputStream dos, DataInputStream dis, HeapDataOutputStream heapdos) throws IOException {
        byte acceptanceCode;
        block21: {
            try {
                boolean requireAuthentication;
                this.logWriter.fine("HandShake: using Diffie-Hellman key exchange with algo " + dhSKAlgo);
                boolean bl = requireAuthentication = certificateFilePath != null && certificateFilePath.length() > 0;
                if (requireAuthentication) {
                    this.logWriter.fine("HandShake: server authentication using digital signature required");
                }
                heapdos.writeByte(2);
                this.appSecureMode = (byte)2;
                heapdos.writeBoolean(requireAuthentication);
                DataSerializer.writeString(dhSKAlgo, heapdos);
                byte[] keyBytes = dhPublicKey.getEncoded();
                DataSerializer.writeByteArray(keyBytes, heapdos);
                byte[] clientChallenge = null;
                if (requireAuthentication) {
                    clientChallenge = new byte[64];
                    random.nextBytes(clientChallenge);
                    DataSerializer.writeByteArray(clientChallenge, heapdos);
                }
                heapdos.flush();
                dos.write(heapdos.toByteArray());
                dos.flush();
                acceptanceCode = dis.readByte();
                if (acceptanceCode != 59) break block21;
                keyBytes = DataSerializer.readByteArray(dis);
                if (requireAuthentication) {
                    String subject = DataSerializer.readString(dis);
                    byte[] signatureBytes = DataSerializer.readByteArray(dis);
                    if (!certificateMap.containsKey(subject)) {
                        throw new AuthenticationFailedException(String.format("HandShake failed to find public key for server with subject %s", subject));
                    }
                    X509Certificate cert = (X509Certificate)certificateMap.get(subject);
                    Signature sig = Signature.getInstance(cert.getSigAlgName());
                    sig.initVerify(cert);
                    sig.update(clientChallenge);
                    if (!sig.verify(signatureBytes)) {
                        throw new AuthenticationFailedException("Mismatch in client challenge bytes. Malicious server?");
                    }
                    this.logWriter.fine("HandShake: Successfully verified the digital signature from server");
                }
                byte[] serverChallenge = DataSerializer.readByteArray(dis);
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
                KeyFactory keyFact = KeyFactory.getInstance("DH");
                this.clientPublicKey = keyFact.generatePublic(x509KeySpec);
                try (HeapDataOutputStream hdos = new HeapDataOutputStream(KnownVersion.CURRENT);){
                    DataSerializer.writeByteArray(serverChallenge, hdos);
                    byte[] encBytes = EncryptorImpl.encryptBytes(hdos.toByteArray(), this.getEncryptCipher(dhSKAlgo, this.clientPublicKey));
                    DataSerializer.writeByteArray(encBytes, dos);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (GemFireSecurityException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new AuthenticationFailedException("HandShake failed in Diffie-Hellman key exchange", ex);
            }
        }
        return acceptanceCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte writeEncryptedCredentials(DataOutputStream dos, DataInputStream dis, Properties p_credentials, HeapDataOutputStream heapdos) throws IOException {
        byte acceptanceCode;
        block12: {
            try {
                boolean requireAuthentication;
                this.logWriter.fine("HandShake: using Diffie-Hellman key exchange with algo " + dhSKAlgo);
                boolean bl = requireAuthentication = certificateFilePath != null && certificateFilePath.length() > 0;
                if (requireAuthentication) {
                    this.logWriter.fine("HandShake: server authentication using digital signature required");
                }
                heapdos.writeByte(2);
                heapdos.writeBoolean(requireAuthentication);
                DataSerializer.writeString(dhSKAlgo, heapdos);
                byte[] keyBytes = dhPublicKey.getEncoded();
                DataSerializer.writeByteArray(keyBytes, heapdos);
                byte[] clientChallenge = null;
                if (requireAuthentication) {
                    clientChallenge = new byte[64];
                    random.nextBytes(clientChallenge);
                    DataSerializer.writeByteArray(clientChallenge, heapdos);
                }
                heapdos.flush();
                dos.write(heapdos.toByteArray());
                dos.flush();
                acceptanceCode = dis.readByte();
                if (acceptanceCode != 59) break block12;
                keyBytes = DataSerializer.readByteArray(dis);
                if (requireAuthentication) {
                    String subject = DataSerializer.readString(dis);
                    byte[] signatureBytes = DataSerializer.readByteArray(dis);
                    if (!certificateMap.containsKey(subject)) {
                        throw new AuthenticationFailedException(String.format("HandShake failed to find public key for server with subject %s", subject));
                    }
                    X509Certificate cert = (X509Certificate)certificateMap.get(subject);
                    Signature sig = Signature.getInstance(cert.getSigAlgName());
                    sig.initVerify(cert);
                    sig.update(clientChallenge);
                    if (!sig.verify(signatureBytes)) {
                        throw new AuthenticationFailedException("Mismatch in client challenge bytes. Malicious server?");
                    }
                    this.logWriter.fine("HandShake: Successfully verified the digital signature from server");
                }
                byte[] challenge = DataSerializer.readByteArray(dis);
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
                KeyFactory keyFact = KeyFactory.getInstance("DH");
                this.clientPublicKey = keyFact.generatePublic(x509KeySpec);
                try (HeapDataOutputStream hdos = new HeapDataOutputStream(KnownVersion.CURRENT);){
                    DataSerializer.writeProperties(p_credentials, hdos);
                    DataSerializer.writeByteArray(challenge, hdos);
                    byte[] encBytes = EncryptorImpl.encryptBytes(hdos.toByteArray(), this.getEncryptCipher(dhSKAlgo, this.clientPublicKey));
                    DataSerializer.writeByteArray(encBytes, dos);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (GemFireSecurityException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new AuthenticationFailedException("HandShake failed in Diffie-Hellman key exchange", ex);
            }
        }
        return acceptanceCode;
    }

    void readEncryptedCredentials(DataInputStream dis, DataOutputStream dos, DistributedSystem system, boolean requireAuthentication) throws Exception {
        this.appSecureMode = (byte)2;
        boolean sendAuthentication = dis.readBoolean();
        InternalLogWriter securityLogWriter = (InternalLogWriter)system.getSecurityLogWriter();
        this.clientSKAlgo = DataSerializer.readString(dis);
        byte[] keyBytes = DataSerializer.readByteArray(dis);
        byte[] challenge = null;
        if (requireAuthentication) {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFact = KeyFactory.getInstance("DH");
            this.clientPublicKey = keyFact.generatePublic(x509KeySpec);
            keyBytes = dhPublicKey.getEncoded();
            challenge = new byte[64];
            random.nextBytes(challenge);
            if (sendAuthentication) {
                byte[] clientChallenge = DataSerializer.readByteArray(dis);
                if (privateKeyEncrypt == null) {
                    throw new AuthenticationFailedException("Server private key not available for creating signature.");
                }
                Signature sig = Signature.getInstance(privateKeySignAlgo);
                sig.initSign(privateKeyEncrypt);
                sig.update(clientChallenge);
                byte[] signedBytes = sig.sign();
                dos.writeByte(59);
                DataSerializer.writeByteArray(keyBytes, dos);
                DataSerializer.writeString(privateKeySubject, dos);
                DataSerializer.writeByteArray(signedBytes, dos);
                securityLogWriter.fine("HandShake: sent the signed client challenge");
            } else {
                dos.writeByte(59);
                DataSerializer.writeByteArray(keyBytes, dos);
            }
            DataSerializer.writeByteArray(challenge, dos);
            securityLogWriter.fine("HandShake: sent the public key and challenge");
            dos.flush();
            byte[] encBytes = DataSerializer.readByteArray(dis);
            Cipher c = this.getDecryptCipher(this.clientSKAlgo, this.clientPublicKey);
            byte[] credentialBytes = EncryptorImpl.decryptBytes(encBytes, c);
            ByteArrayDataInput dinp = new ByteArrayDataInput(credentialBytes);
            byte[] challengeRes = DataSerializer.readByteArray((DataInput)dinp);
            if (!Arrays.equals(challenge, challengeRes)) {
                throw new AuthenticationFailedException("Mismatch in challenge bytes. Malicious client?");
            }
            dinp.close();
        } else {
            if (sendAuthentication) {
                DataSerializer.readByteArray(dis);
            }
            dos.writeByte(66);
            dos.flush();
        }
    }

    static Properties getDecryptedCredentials(DataInputStream dis, DataOutputStream dos, DistributedSystem system, boolean requireAuthentication, Properties credentials) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, ClassNotFoundException {
        boolean sendAuthentication = dis.readBoolean();
        InternalLogWriter securityLogWriter = (InternalLogWriter)system.getSecurityLogWriter();
        String skAlgo = DataSerializer.readString(dis);
        byte[] keyBytes = DataSerializer.readByteArray(dis);
        byte[] challenge = null;
        PublicKey pubKey = null;
        if (requireAuthentication) {
            Cipher decrypt;
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFact = KeyFactory.getInstance("DH");
            pubKey = keyFact.generatePublic(x509KeySpec);
            keyBytes = dhPublicKey.getEncoded();
            challenge = new byte[64];
            random.nextBytes(challenge);
            if (sendAuthentication) {
                byte[] clientChallenge = DataSerializer.readByteArray(dis);
                if (privateKeyEncrypt == null) {
                    throw new AuthenticationFailedException("Server private key not available for creating signature.");
                }
                Signature sig = Signature.getInstance(privateKeySignAlgo);
                sig.initSign(privateKeyEncrypt);
                sig.update(clientChallenge);
                byte[] signedBytes = sig.sign();
                dos.writeByte(59);
                DataSerializer.writeByteArray(keyBytes, dos);
                DataSerializer.writeString(privateKeySubject, dos);
                DataSerializer.writeByteArray(signedBytes, dos);
                securityLogWriter.fine("HandShake: sent the signed client challenge");
            } else {
                dos.writeByte(59);
                DataSerializer.writeByteArray(keyBytes, dos);
            }
            DataSerializer.writeByteArray(challenge, dos);
            securityLogWriter.fine("HandShake: sent the public key and challenge");
            dos.flush();
            byte[] encBytes = DataSerializer.readByteArray(dis);
            KeyAgreement ka = KeyAgreement.getInstance("DH");
            ka.init(dhPrivateKey);
            ka.doPhase(pubKey, true);
            int keysize = EncryptorImpl.getKeySize(skAlgo);
            int blocksize = EncryptorImpl.getBlockSize(skAlgo);
            if (keysize == -1 || blocksize == -1) {
                SecretKey sKey = ka.generateSecret(skAlgo);
                decrypt = Cipher.getInstance(skAlgo);
                decrypt.init(2, sKey);
            } else {
                String algoStr = EncryptorImpl.getDhAlgoStr(skAlgo);
                byte[] sKeyBytes = ka.generateSecret();
                SecretKeySpec sks = new SecretKeySpec(sKeyBytes, 0, keysize, algoStr);
                IvParameterSpec ivps = new IvParameterSpec(sKeyBytes, keysize, blocksize);
                decrypt = Cipher.getInstance(algoStr + "/CBC/PKCS5Padding");
                decrypt.init(2, (Key)sks, ivps);
            }
            byte[] credentialBytes = decrypt.doFinal(encBytes);
            ByteArrayDataInput dinp = new ByteArrayDataInput(credentialBytes);
            credentials = DataSerializer.readProperties((DataInput)dinp);
            byte[] challengeRes = DataSerializer.readByteArray((DataInput)dinp);
            if (!Arrays.equals(challenge, challengeRes)) {
                throw new AuthenticationFailedException("Mismatch in challenge bytes. Malicious client?");
            }
            dinp.close();
        } else {
            if (sendAuthentication) {
                DataSerializer.readByteArray(dis);
            }
            dos.writeByte(66);
            dos.flush();
        }
        return credentials;
    }

    private static int getKeySize(String skAlgo) {
        String algoStr;
        int colIdx = skAlgo.indexOf(58);
        int algoKeySize = 0;
        if (colIdx >= 0) {
            algoStr = skAlgo.substring(0, colIdx);
            algoKeySize = Integer.parseInt(skAlgo.substring(colIdx + 1));
        } else {
            algoStr = skAlgo;
        }
        int keysize = -1;
        if (algoStr.equalsIgnoreCase("DESede")) {
            keysize = 24;
        } else if (algoStr.equalsIgnoreCase("Blowfish")) {
            keysize = algoKeySize > 128 ? algoKeySize / 8 : 16;
        } else if (algoStr.equalsIgnoreCase("AES")) {
            keysize = algoKeySize != 192 && algoKeySize != 256 ? 16 : algoKeySize / 8;
        }
        return keysize;
    }

    private static String getDhAlgoStr(String skAlgo) {
        int colIdx = skAlgo.indexOf(58);
        String algoStr = colIdx >= 0 ? skAlgo.substring(0, colIdx) : skAlgo;
        return algoStr;
    }

    private static int getBlockSize(String skAlgo) {
        int blocksize = -1;
        String algoStr = EncryptorImpl.getDhAlgoStr(skAlgo);
        if (algoStr.equalsIgnoreCase("DESede")) {
            blocksize = 8;
        } else if (algoStr.equalsIgnoreCase("Blowfish")) {
            blocksize = 8;
        } else if (algoStr.equalsIgnoreCase("AES")) {
            blocksize = 16;
        }
        return blocksize;
    }
}

