/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.geode.cache.IncompatibleVersionException;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.tcpserver.ProtocolChecker;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolProcessor;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolService;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolServiceLoader;
import org.apache.geode.internal.cache.client.protocol.exception.ServiceLoadingFailureException;
import org.apache.geode.internal.cache.client.protocol.exception.ServiceVersionNotFoundException;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ProtocolCheckerImpl
implements ProtocolChecker {
    private static final Logger logger = LogService.getLogger();
    public final InternalLocator internalLocator;
    public final ClientProtocolServiceLoader clientProtocolServiceLoader;

    public ProtocolCheckerImpl(InternalLocator internalLocator, ClientProtocolServiceLoader clientProtocolServiceLoader) {
        this.internalLocator = internalLocator;
        this.clientProtocolServiceLoader = clientProtocolServiceLoader;
    }

    public boolean checkProtocol(Socket socket, DataInputStream input, int firstByte) throws Exception {
        boolean handled = false;
        if (firstByte == CommunicationMode.ProtobufClientServerProtocol.getModeNumber()) {
            this.handleProtobufConnection(socket, input);
            handled = true;
        } else if (CommunicationMode.isValidMode(firstByte)) {
            socket.getOutputStream().write(67);
            throw new Exception("Improperly configured client detected - use addPoolLocator to configure its locators instead of addPoolServer.");
        }
        return handled;
    }

    public void handleProtobufConnection(Socket socket, DataInputStream input) throws Exception {
        if (!Boolean.getBoolean("geode.feature-protobuf-protocol")) {
            logger.warn("Incoming protobuf connection, but protobuf not enabled on this locator.");
            socket.close();
            return;
        }
        try {
            ClientProtocolService clientProtocolService = this.clientProtocolServiceLoader.lookupService();
            clientProtocolService.initializeStatistics("LocatorStats", this.internalLocator.getDistributedSystem());
            try (ClientProtocolProcessor pipeline = clientProtocolService.createProcessorForLocator(this.internalLocator, this.internalLocator.getCache().getSecurityService());){
                while (!pipeline.socketProcessingIsFinished()) {
                    pipeline.processMessage(input, socket.getOutputStream());
                }
            }
            catch (IncompatibleVersionException e) {
                logger.error("Unexpected exception in client message processing", (Throwable)e);
            }
        }
        catch (ServiceLoadingFailureException e) {
            logger.error("There was an error looking up the client protocol service", (Throwable)e);
            socket.close();
            throw new IOException("There was an error looking up the client protocol service", e);
        }
        catch (ServiceVersionNotFoundException e) {
            logger.error("Unable to find service matching the client protocol version byte", (Throwable)e);
            socket.close();
            throw new IOException("Unable to find service matching the client protocol version byte", e);
        }
    }
}

