/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.RemoteInputStreamServer;
import com.healthmarketscience.rmiio.RemoteIteratorServer;
import com.healthmarketscience.rmiio.RemoteStreamMonitor;
import com.healthmarketscience.rmiio.util.EncodingInputStream;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EncodingRemoteIteratorServer<DataType>
extends RemoteIteratorServer<DataType> {
    protected OutputStream _localOStream;

    public EncodingRemoteIteratorServer() throws IOException {
        this(true, RemoteInputStreamServer.DUMMY_MONITOR);
    }

    public EncodingRemoteIteratorServer(boolean useCompression) throws IOException {
        this(useCompression, false, RemoteInputStreamServer.DUMMY_MONITOR);
    }

    public EncodingRemoteIteratorServer(boolean useCompression, boolean noDelay) throws IOException {
        this(useCompression, noDelay, RemoteInputStreamServer.DUMMY_MONITOR);
    }

    public EncodingRemoteIteratorServer(boolean useCompression, RemoteStreamMonitor<RemoteInputStreamServer> monitor) throws IOException {
        this(useCompression, false, monitor);
    }

    public EncodingRemoteIteratorServer(boolean useCompression, boolean noDelay, RemoteStreamMonitor<RemoteInputStreamServer> monitor) throws IOException {
        this(useCompression, noDelay, monitor, 7168);
    }

    public EncodingRemoteIteratorServer(boolean useCompression, boolean noDelay, RemoteStreamMonitor<RemoteInputStreamServer> monitor, int chunkSize) throws IOException {
        super(new EncodingInputStreamImpl(chunkSize, noDelay && !useCompression), useCompression, monitor, chunkSize);
        ((EncodingInputStreamImpl)this._localIStream).setOuter(this);
        this._localOStream = ((EncodingInputStreamImpl)this._localIStream).getOutputStream();
    }

    protected void closeIterator() throws IOException {
        this._localOStream.close();
    }

    protected abstract boolean writeNextObject() throws IOException;

    private static class EncodingInputStreamImpl
    extends EncodingInputStream {
        private EncodingRemoteIteratorServer _outer;

        private EncodingInputStreamImpl(int chunkSize, boolean noDelay) {
            super(chunkSize, noDelay);
        }

        private void setOuter(EncodingRemoteIteratorServer outer) {
            this._outer = outer;
        }

        private OutputStream getOutputStream() {
            return this.createOutputStream();
        }

        public void encode(int suggestedLength) throws IOException {
            if (!this._outer.writeNextObject()) {
                this._outer.closeIterator();
            }
        }
    }
}

