/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.pubsub;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.redis.internal.netty.Client;
import org.apache.geode.redis.internal.pubsub.Subscriptions;

public class PublishResultCollector {
    private final CountDownLatch countDownLatch;
    private final Subscriptions subscriptions;
    private final AtomicLong successCount = new AtomicLong();

    public PublishResultCollector(int resultsExpected, Subscriptions subscriptions) {
        this.countDownLatch = new CountDownLatch(resultsExpected);
        this.subscriptions = subscriptions;
    }

    public void success() {
        this.successCount.incrementAndGet();
        this.countDownLatch.countDown();
    }

    public void failure(Client result) {
        this.pruneFailure(result);
        this.countDownLatch.countDown();
    }

    public long getSuccessCount() {
        this.waitForResults();
        return this.successCount.get();
    }

    private void pruneFailure(Client c) {
        if (c.isDead()) {
            this.subscriptions.remove(c);
        }
    }

    private void waitForResults() {
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

