/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.server;

import java.text.DecimalFormat;
import java.util.List;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;
import org.apache.geode.redis.internal.statistics.RedisStats;

public class InfoExecutor
extends AbstractExecutor {
    private static final Long ONE_MEGABYTE = 0x100000L;
    private DecimalFormat decimalFormat = new DecimalFormat("0.00");

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        List<ByteArrayWrapper> commands = command.getProcessedCommandWrappers();
        String result = this.containsSectionParameter(commands) ? this.getSpecifiedSection(context, commands) : this.getAllSections(context);
        return RedisResponse.bulkString(result);
    }

    private boolean containsSectionParameter(List<ByteArrayWrapper> commands) {
        return commands.size() == 2;
    }

    private String getSpecifiedSection(ExecutionHandlerContext context, List<ByteArrayWrapper> commands) {
        String result;
        String section;
        switch (section = commands.get(1).toString().toLowerCase()) {
            case "server": {
                result = this.getServerSection(context);
                break;
            }
            case "cluster": {
                result = this.getClusterSection();
                break;
            }
            case "persistence": {
                result = this.getPersistenceSection();
                break;
            }
            case "replication": {
                result = this.getReplicationSection();
                break;
            }
            case "stats": {
                result = this.getStatsSection(context);
                break;
            }
            case "clients": {
                result = this.getClientsSection(context);
                break;
            }
            case "memory": {
                result = this.getMemorySection(context);
                break;
            }
            case "keyspace": {
                result = this.getKeyspaceSection(context);
                break;
            }
            case "default": 
            case "all": {
                result = this.getAllSections(context);
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    private String getStatsSection(ExecutionHandlerContext context) {
        RedisStats redisStats = context.getRedisStats();
        String instantaneous_input_kbps = this.decimalFormat.format(redisStats.getNetworkKiloBytesReadOverLastSecond());
        String STATS_STRING = "# Stats\r\ntotal_commands_processed:" + redisStats.getCommandsProcessed() + "\r\ninstantaneous_ops_per_sec:" + redisStats.getOpsPerformedOverLastSecond() + "\r\ntotal_net_input_bytes:" + redisStats.getTotalNetworkBytesRead() + "\r\ninstantaneous_input_kbps:" + instantaneous_input_kbps + "\r\ntotal_connections_received:" + redisStats.getTotalConnectionsReceived() + "\r\nkeyspace_hits:" + redisStats.getKeyspaceHits() + "\r\nkeyspace_misses:" + redisStats.getKeyspaceMisses() + "\r\nevicted_keys:0\r\nrejected_connections:0\r\n";
        return STATS_STRING;
    }

    private String getServerSection(ExecutionHandlerContext context) {
        String CURRENT_REDIS_VERSION = "5.0.6";
        int TCP_PORT = context.getServerPort();
        RedisStats redisStats = context.getRedisStats();
        String SERVER_STRING = "# Server\r\nredis_version:5.0.6\r\nredis_mode:standalone\r\ntcp_port:" + TCP_PORT + "\r\nuptime_in_seconds:" + redisStats.getUptimeInSeconds() + "\r\nuptime_in_days:" + redisStats.getUptimeInDays() + "\r\n";
        return SERVER_STRING;
    }

    private String getClientsSection(ExecutionHandlerContext context) {
        RedisStats redisStats = context.getRedisStats();
        String CLIENTS_STRING = "# Clients\r\nconnected_clients:" + redisStats.getConnectedClients() + "\r\nblocked_clients:0\r\n";
        return CLIENTS_STRING;
    }

    private String getMemorySection(ExecutionHandlerContext context) {
        PartitionedRegion pr = (PartitionedRegion)context.getRegionProvider().getDataRegion();
        long usedMemory = pr.getDataStore().currentAllocatedMemory();
        String MEMORY_STRING = "# Memory\r\nmaxmemory:" + (long)pr.getLocalMaxMemory() * ONE_MEGABYTE + "\r\nused_memory:" + usedMemory + "\r\nmem_fragmentation_ratio:1.00\r\n";
        return MEMORY_STRING;
    }

    private String getKeyspaceSection(ExecutionHandlerContext context) {
        int numberOfKeys = context.getRegionProvider().getDataRegion().size();
        String keyspaceString = "# Keyspace\r\n";
        if (numberOfKeys > 0) {
            keyspaceString = keyspaceString + "db0:keys=" + numberOfKeys + ",expires=0,avg_ttl=0\r\n";
        }
        return keyspaceString;
    }

    private String getPersistenceSection() {
        String PERSISTENCE_STRING = "# Persistence\r\nloading:0\r\nrdb_changes_since_last_save:0\r\nrdb_last_save_time:0\r\n";
        return "# Persistence\r\nloading:0\r\nrdb_changes_since_last_save:0\r\nrdb_last_save_time:0\r\n";
    }

    private String getClusterSection() {
        return "# Cluster\r\ncluster_enabled:0\r\n";
    }

    private String getReplicationSection() {
        return "# Replication\r\nrole:master\r\nconnected_slaves:0\r\n";
    }

    private String getAllSections(ExecutionHandlerContext context) {
        String SECTION_SEPARATOR = "\r\n";
        return this.getServerSection(context) + "\r\n" + this.getClientsSection(context) + "\r\n" + this.getMemorySection(context) + "\r\n" + this.getPersistenceSection() + "\r\n" + this.getStatsSection(context) + "\r\n" + this.getKeyspaceSection(context) + "\r\n" + this.getReplicationSection() + "\r\n" + this.getClusterSection();
    }
}

