/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.executor.cluster.CRC16;

public class RedisKey
extends ByteArrayWrapper
implements DataSerializableFixedID {
    private int crc16;

    public RedisKey() {
    }

    public RedisKey(byte[] value) {
        super(value);
        int startHashtag = Integer.MAX_VALUE;
        int endHashtag = 0;
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == 123 && startHashtag == Integer.MAX_VALUE) {
                startHashtag = i;
                continue;
            }
            if (value[i] != 125) continue;
            endHashtag = i;
            break;
        }
        if (endHashtag - startHashtag <= 1) {
            startHashtag = -1;
            endHashtag = value.length;
        }
        this.crc16 = CRC16.calculate(value, startHashtag + 1, endHashtag);
    }

    @Override
    public int getDSFID() {
        return 160;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeShort(this.crc16);
        super.toData(out, context);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.crc16 = in.readShort() & 0xFFFF;
        super.fromData(in, context);
    }

    @Override
    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    public int getCrc16() {
        return this.crc16;
    }
}

