/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import java.util.concurrent.ExecutorService;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.internal.statistics.StatisticsClockFactory;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.PassiveExpirationManager;
import org.apache.geode.redis.internal.RegionProvider;
import org.apache.geode.redis.internal.executor.CommandFunction;
import org.apache.geode.redis.internal.executor.SynchronizedStripedExecutor;
import org.apache.geode.redis.internal.executor.key.RenameFunction;
import org.apache.geode.redis.internal.netty.NettyRedisServer;
import org.apache.geode.redis.internal.pubsub.PubSub;
import org.apache.geode.redis.internal.pubsub.PubSubImpl;
import org.apache.geode.redis.internal.pubsub.Subscriptions;
import org.apache.geode.redis.internal.statistics.GeodeRedisStats;
import org.apache.geode.redis.internal.statistics.RedisStats;
import org.apache.logging.log4j.Logger;

public class GeodeRedisServer {
    public static final int DEFAULT_REDIS_SERVER_PORT = 6379;
    public static final String ENABLE_UNSUPPORTED_COMMANDS_PARAM = "enable-unsupported-commands";
    private static boolean unsupportedCommandsEnabled;
    private static final Logger logger;
    private final PassiveExpirationManager passiveExpirationManager;
    private final NettyRedisServer nettyRedisServer;
    private final RegionProvider regionProvider;
    private final PubSub pubSub;
    private final RedisStats redisStats;
    private final ExecutorService redisCommandExecutor;
    private boolean shutdown;

    public GeodeRedisServer(String bindAddress, int port, InternalCache cache) {
        unsupportedCommandsEnabled = Boolean.getBoolean(ENABLE_UNSUPPORTED_COMMANDS_PARAM);
        this.pubSub = new PubSubImpl(new Subscriptions());
        this.redisStats = GeodeRedisServer.createStats(cache);
        SynchronizedStripedExecutor stripedExecutor = new SynchronizedStripedExecutor();
        this.regionProvider = new RegionProvider(cache);
        CommandFunction.register(this.regionProvider.getDataRegion(), stripedExecutor, this.redisStats);
        RenameFunction.register(this.regionProvider.getDataRegion(), stripedExecutor, this.redisStats);
        this.passiveExpirationManager = new PassiveExpirationManager(this.regionProvider.getDataRegion(), this.redisStats);
        this.redisCommandExecutor = LoggingExecutors.newCachedThreadPool((String)"GeodeRedisServer-Command-", (boolean)true);
        this.nettyRedisServer = new NettyRedisServer(() -> cache.getInternalDistributedSystem().getConfig(), this.regionProvider, this.pubSub, this::allowUnsupportedCommands, this::shutdown, port, bindAddress, this.redisStats, this.redisCommandExecutor);
    }

    @VisibleForTesting
    public int getSubscriptionCount() {
        return ((PubSubImpl)this.pubSub).getSubscriptionCount();
    }

    private static RedisStats createStats(InternalCache cache) {
        InternalDistributedSystem system = cache.getInternalDistributedSystem();
        StatisticsClock statisticsClock = StatisticsClockFactory.clock((boolean)true);
        return new RedisStats(statisticsClock, new GeodeRedisStats((StatisticsFactory)system.getStatisticsManager(), "redisStats", statisticsClock));
    }

    @VisibleForTesting
    public RedisStats getStats() {
        return this.redisStats;
    }

    @VisibleForTesting
    public void setAllowUnsupportedCommands(boolean allowUnsupportedCommands) {
        unsupportedCommandsEnabled = allowUnsupportedCommands;
    }

    public boolean allowUnsupportedCommands() {
        return unsupportedCommandsEnabled;
    }

    public RegionProvider getRegionProvider() {
        return this.regionProvider;
    }

    public int getPort() {
        return this.nettyRedisServer.getPort();
    }

    public synchronized void shutdown() {
        if (!this.shutdown) {
            logger.info("GeodeRedisServer shutting down");
            this.passiveExpirationManager.stop();
            this.nettyRedisServer.stop();
            this.redisCommandExecutor.shutdown();
            this.redisStats.close();
            this.shutdown = true;
        }
    }

    static {
        logger = LogService.getLogger();
    }
}

