/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.sink.writer.BufferedRequestState;
import org.apache.flink.connector.base.sink.writer.RequestEntryWrapper;
import org.apache.flink.core.io.SimpleVersionedSerializer;

@PublicEvolving
public abstract class AsyncSinkWriterStateSerializer<RequestEntryT extends Serializable>
implements SimpleVersionedSerializer<BufferedRequestState<RequestEntryT>> {
    private static final long DATA_IDENTIFIER = -1L;

    public byte[] serialize(BufferedRequestState<RequestEntryT> obj) throws IOException {
        List<RequestEntryWrapper<RequestEntryT>> bufferState = obj.getBufferedRequestEntries();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeLong(-1L);
                out.writeInt(bufferState.size());
                for (RequestEntryWrapper requestEntryWrapper : bufferState) {
                    out.writeLong(requestEntryWrapper.getSize());
                    this.serializeRequestToStream((Serializable)requestEntryWrapper.getRequestEntry(), out);
                }
                object = baos.toByteArray();
            }
            return object;
        }
    }

    public BufferedRequestState<RequestEntryT> deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            BufferedRequestState bufferedRequestState;
            try (DataInputStream in = new DataInputStream(bais);){
                this.validateIdentifier(in);
                int size = in.readInt();
                ArrayList serializedState = new ArrayList();
                for (int i = 0; i < size; ++i) {
                    long requestSize = in.readLong();
                    RequestEntryT request = this.deserializeRequestFromStream(requestSize, in);
                    serializedState.add(new RequestEntryWrapper<RequestEntryT>(request, requestSize));
                }
                bufferedRequestState = new BufferedRequestState(serializedState);
            }
            return bufferedRequestState;
        }
    }

    protected abstract void serializeRequestToStream(RequestEntryT var1, DataOutputStream var2) throws IOException;

    protected abstract RequestEntryT deserializeRequestFromStream(long var1, DataInputStream var3) throws IOException;

    private void validateIdentifier(DataInputStream in) throws IOException {
        if (in.readLong() != -1L) {
            throw new IllegalStateException("Corrupted data to deserialize");
        }
    }
}

