/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.batch.compact;

import java.util.LinkedHashMap;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.FileSystemFactory;
import org.apache.flink.connector.file.table.OutputFormatFactory;
import org.apache.flink.connector.file.table.PartitionComputer;
import org.apache.flink.connector.file.table.PartitionTempFileManager;
import org.apache.flink.connector.file.table.PartitionWriter;
import org.apache.flink.connector.file.table.PartitionWriterFactory;
import org.apache.flink.connector.file.table.stream.compact.CompactMessages;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.TableException;

public class BatchFileWriter<T>
extends AbstractStreamOperator<CompactMessages.CoordinatorInput>
implements OneInputStreamOperator<T, CompactMessages.CoordinatorInput>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final FileSystemFactory fsFactory;
    private final Path tmpPath;
    private final String[] partitionColumns;
    private final boolean dynamicGrouped;
    private final LinkedHashMap<String, String> staticPartitions;
    private final PartitionComputer<T> computer;
    private final OutputFormatFactory<T> formatFactory;
    private final OutputFileConfig outputFileConfig;
    private transient PartitionWriter<T> writer;

    public BatchFileWriter(FileSystemFactory fsFactory, Path tmpPath, String[] partitionColumns, boolean dynamicGrouped, LinkedHashMap<String, String> staticPartitions, OutputFormatFactory<T> formatFactory, PartitionComputer<T> computer, OutputFileConfig outputFileConfig) {
        this.fsFactory = fsFactory;
        this.tmpPath = tmpPath;
        this.partitionColumns = partitionColumns;
        this.dynamicGrouped = dynamicGrouped;
        this.staticPartitions = staticPartitions;
        this.formatFactory = formatFactory;
        this.computer = computer;
        this.outputFileConfig = outputFileConfig;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    public void open() throws Exception {
        try {
            PartitionTempFileManager fileManager = new PartitionTempFileManager(this.fsFactory, this.tmpPath, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber(), this.outputFileConfig);
            Configuration config = this.getContainingTask().getEnvironment().getTaskManagerInfo().getConfiguration();
            PartitionWriter.Context<T> context = new PartitionWriter.Context<T>(config, this.formatFactory);
            PartitionWriter.PartitionWriterListener writerListener = (partition, file) -> this.output.collect((Object)new StreamRecord((Object)new CompactMessages.InputFile(partition, file)));
            this.writer = PartitionWriterFactory.get(this.partitionColumns.length - this.staticPartitions.size() > 0, this.dynamicGrouped, this.staticPartitions).create(context, fileManager, this.computer, writerListener);
        }
        catch (Exception e) {
            throw new TableException("Exception in open", (Throwable)e);
        }
    }

    public void processElement(StreamRecord<T> element) throws Exception {
        try {
            this.writer.write(element.getValue());
        }
        catch (Exception e) {
            throw new TableException("Exception in writeRecord", (Throwable)e);
        }
    }

    public void endInput() throws Exception {
    }

    public void close() throws Exception {
        try {
            this.staticPartitions.clear();
            this.writer.close();
        }
        catch (Exception e) {
            throw new TableException("Exception in close", (Throwable)e);
        }
    }
}

