/*
 * Decompiled with CFR 0.152.
 */
package flash.graphics.images;

import flash.graphics.images.BitmapImage;
import flash.graphics.images.ImageUtil;
import flash.util.FileUtils;
import flash.util.Trace;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class JPEGImage
extends BitmapImage {
    protected InputStream inputStream;
    protected long length;
    protected byte[] data;

    public JPEGImage(String location, long modified, long length, InputStream inputStream) throws IOException {
        this.location = location;
        this.modified = modified;
        this.length = length;
        this.inputStream = inputStream;
        Image image = ImageUtil.getImage(this.getData());
        this.init(image);
    }

    public JPEGImage(File imageFile) {
        try {
            this.location = imageFile.getAbsolutePath();
            this.modified = imageFile.lastModified();
            this.length = imageFile.length();
            this.inputStream = new FileInputStream(imageFile);
            Image image = Toolkit.getDefaultToolkit().getImage(this.location);
            this.init(image);
        }
        catch (InternalError ie) {
            if (Trace.error) {
                ie.printStackTrace();
            }
            throw new InternalError("An error occurred because there is no graphics environment available.  Please set the headless-server setting in the configuration file to true.");
        }
        catch (NoClassDefFoundError ce) {
            if (Trace.error) {
                ce.printStackTrace();
            }
            throw new InternalError("An error occurred because there is no graphics environment available.  Please set the headless-server setting in the configuration file to true.");
        }
        catch (Exception ex) {
            throw new RuntimeException("Error reading image from file " + this.location + ". " + ex.getMessage());
        }
    }

    public JPEGImage(URL imageURL) {
        try {
            Image image = Toolkit.getDefaultToolkit().getImage(imageURL);
            this.inputStream = imageURL.openStream();
            URLConnection conn = imageURL.openConnection();
            this.location = imageURL.toString();
            this.modified = conn.getLastModified();
            this.length = conn.getContentLength();
            this.init(image);
        }
        catch (InternalError ie) {
            if (Trace.error) {
                ie.printStackTrace();
            }
            throw new InternalError("An error occurred because there is no graphics environment available.  Please set the headless-server setting in the configuration file to true.");
        }
        catch (NoClassDefFoundError ce) {
            if (Trace.error) {
                ce.printStackTrace();
            }
            throw new InternalError("An error occurred because there is no graphics environment available.  Please set the headless-server setting in the configuration file to true.");
        }
        catch (Exception ex) {
            throw new RuntimeException("Error reading image from URL. " + this.location + ". " + ex.getMessage());
        }
    }

    public JPEGImage(InputStream is, long length) {
        this.inputStream = is;
        this.location = "Synthetic";
        this.modified = System.currentTimeMillis();
        this.length = length;
    }

    private void init(Image image) {
        PixelGrabber pixelGrabber = ImageUtil.getPixelGrabber(image, this.location);
        this.width = pixelGrabber.getWidth();
        this.height = pixelGrabber.getHeight();
    }

    public long getLength() {
        return this.length;
    }

    public byte[] getData() throws IOException {
        if (this.data == null) {
            this.data = FileUtils.toByteArray(this.inputStream, (int)this.length);
        }
        return this.data;
    }

    public void dispose() {
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

