/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flash.localization.LocalizationManager;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Logger;
import flex2.compiler.util.AbstractLogAdapter;
import flex2.compiler.util.LineNumberMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MxmlLogAdapter
extends AbstractLogAdapter {
    private LineNumberMap map;
    private List<LineNumberMap> extras;
    private Map renamedVariableMap;
    private Map<String, String> messages;

    public MxmlLogAdapter(Logger original, LineNumberMap map) {
        super(original);
        this.map = map;
    }

    public void setRenamedVariableMap(Map renamedVariableMap) {
        this.renamedVariableMap = renamedVariableMap;
    }

    public void addLineNumberMap(LineNumberMap map) {
        if (this.extras == null) {
            this.extras = new ArrayList<LineNumberMap>(5);
        }
        this.extras.add(map);
    }

    public void addLineNumberMaps(Collection<LineNumberMap> c) {
        if (c != null && this.extras == null) {
            this.extras = new ArrayList<LineNumberMap>(5);
        }
        if (c != null) {
            this.extras.addAll(c);
        }
    }

    @Override
    public void logInfo(String path, String info) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            this.original.logInfo(map.getOldName(), info);
        } else {
            this.original.logInfo(path, info);
        }
    }

    @Override
    public void logDebug(String path, String debug) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            this.original.logDebug(map.getOldName(), debug);
        } else {
            this.original.logDebug(path, debug);
        }
    }

    @Override
    public void logWarning(String path, String warning) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            this.original.logWarning(map.getOldName(), warning);
        } else {
            this.original.logWarning(path, warning);
        }
    }

    @Override
    public void logWarning(String path, String warning, int errorCode) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            this.original.logWarning(map.getOldName(), warning, errorCode);
        } else {
            this.original.logWarning(path, warning, errorCode);
        }
    }

    @Override
    public void logError(String path, String error) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            this.original.logError(map.getOldName(), error);
        } else {
            this.original.logError(path, error);
        }
    }

    @Override
    public void logError(String path, String error, int errorCode) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            this.original.logError(map.getOldName(), error, errorCode);
        } else {
            this.original.logError(path, error, errorCode);
        }
    }

    @Override
    public void logInfo(String path, int line, String info) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logInfo(map.getOldName(), map.get(line), info);
            } else {
                this.original.logInfo(path, line, info);
            }
        } else {
            this.original.logInfo(path, line, info);
        }
    }

    @Override
    public void logDebug(String path, int line, String debug) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logDebug(map.getOldName(), map.get(line), debug);
            } else {
                this.original.logDebug(path, line, debug);
            }
        } else {
            this.original.logDebug(path, line, debug);
        }
    }

    @Override
    public void logWarning(String path, int line, String warning) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logWarning(map.getOldName(), map.get(line), warning);
            } else {
                this.original.logWarning(path, line, warning);
            }
        } else {
            this.original.logWarning(path, line, warning);
        }
    }

    @Override
    public void logWarning(String path, int line, String warning, int errorCode) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logWarning(map.getOldName(), map.get(line), warning, errorCode);
            } else {
                this.original.logWarning(path, line, warning, errorCode);
            }
        } else {
            this.original.logWarning(path, line, warning, errorCode);
        }
    }

    @Override
    public void logError(String path, int line, String error) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logError(map.getOldName(), map.get(line), error);
            } else {
                this.original.logError(path, line, error);
            }
        } else {
            this.original.logError(path, line, error);
        }
    }

    @Override
    public void logError(String path, int line, String error, int errorCode) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logError(map.getOldName(), map.get(line), error, errorCode);
            } else {
                this.original.logError(path, line, error, errorCode);
            }
        } else {
            this.original.logError(path, line, error, errorCode);
        }
    }

    @Override
    public void logInfo(String path, int line, int col, String info) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logInfo(map.getOldName(), map.get(line), info);
            } else {
                this.original.logInfo(path, line, col, info);
            }
        } else {
            this.original.logInfo(path, line, col, info);
        }
    }

    @Override
    public void logDebug(String path, int line, int col, String debug) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logDebug(map.getOldName(), map.get(line), debug);
            } else {
                this.original.logDebug(path, line, col, debug);
            }
        } else {
            this.original.logDebug(path, line, col, debug);
        }
    }

    @Override
    public void logWarning(String path, int line, int col, String warning) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logWarning(map.getOldName(), map.get(line), warning);
            } else {
                this.original.logWarning(path, line, col, warning);
            }
        } else {
            this.original.logWarning(path, line, col, warning);
        }
    }

    @Override
    public void logError(String path, int line, int col, String error) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                this.original.logError(map.getOldName(), map.get(line), error);
            } else {
                this.original.logError(path, line, col, error);
            }
        } else {
            this.original.logError(path, line, col, error);
        }
    }

    @Override
    public void logWarning(String path, int line, int col, String warning, String source) {
        warning = this.mapRenamedVariables(warning);
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                String key;
                if (this.messages == null) {
                    this.messages = new HashMap<String, String>();
                }
                if (!warning.equals(this.messages.get(key = map.getOldName() + map.get(line)))) {
                    this.original.logWarning(map.getOldName(), map.get(line), warning);
                    this.messages.put(key, warning);
                }
            } else {
                this.original.logWarning(path, line, col, warning, source);
            }
        } else {
            this.original.logWarning(path, line, col, warning, source);
        }
    }

    @Override
    public void logWarning(String path, int line, int col, String warning, String source, int errorCode) {
        warning = this.mapRenamedVariables(warning);
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                String key;
                if (this.messages == null) {
                    this.messages = new HashMap<String, String>();
                }
                if (!warning.equals(this.messages.get(key = map.getOldName() + map.get(line)))) {
                    this.original.logWarning(map.getOldName(), map.get(line), warning, errorCode);
                    this.messages.put(key, warning);
                }
            } else {
                this.original.logWarning(path, line, col, warning, source, errorCode);
            }
        } else {
            this.original.logWarning(path, line, col, warning, source, errorCode);
        }
    }

    @Override
    public void logError(String path, int line, int col, String error, String source) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                String key;
                if (this.messages == null) {
                    this.messages = new HashMap<String, String>();
                }
                if (!error.equals(this.messages.get(key = map.getOldName() + map.get(line)))) {
                    this.original.logError(map.getOldName(), map.get(line), error);
                    this.messages.put(key, error);
                }
            } else {
                this.original.logError(path, line, col, error, source);
            }
        } else {
            this.original.logError(path, line, col, error, source);
        }
    }

    @Override
    public void logError(String path, int line, int col, String error, String source, int errorCode) {
        LineNumberMap map = null;
        map = this.matchPath(path);
        if (map != null) {
            if (this.isUserDefined(map, line)) {
                String key;
                if (this.messages == null) {
                    this.messages = new HashMap<String, String>();
                }
                if (!error.equals(this.messages.get(key = map.getOldName() + map.get(line)))) {
                    this.original.logError(map.getOldName(), map.get(line), error, errorCode);
                    this.messages.put(key, error);
                }
            } else {
                this.original.logError(path, line, col, error, source, errorCode);
            }
        } else {
            this.original.logError(path, line, col, error, source, errorCode);
        }
    }

    @Override
    public void log(ILocalizableMessage m) {
        this.log(m, null);
    }

    @Override
    public void log(ILocalizableMessage m, String source) {
        LineNumberMap map = null;
        map = this.matchPath(m.getPath());
        if (map != null) {
            if (this.isUserDefined(map, m.getLine())) {
                m.setPath(map.getOldName());
                m.setLine(map.get(m.getLine()));
                m.setColumn(-1);
                source = null;
            } else assert (false) : "codegen-specific error...";
        }
        if (source == null) {
            this.original.log(m);
        } else {
            this.original.log(m, source);
        }
    }

    @Override
    public void needsCompilation(String path, String reason) {
        this.original.needsCompilation(path, reason);
    }

    @Override
    public void includedFileUpdated(String path) {
        this.original.includedFileUpdated(path);
    }

    @Override
    public void includedFileAffected(String path) {
        this.original.includedFileAffected(path);
    }

    @Override
    public void setLocalizationManager(LocalizationManager mgr) {
    }

    private LineNumberMap matchPath(String path) {
        int size;
        if (this.map != null && this.map.getNewName().equals(path)) {
            return this.map;
        }
        int n = size = this.extras == null ? 0 : this.extras.size();
        for (int i = 0; i < size; ++i) {
            LineNumberMap m = this.extras.get(i);
            if (!m.getNewName().equals(path)) continue;
            return m;
        }
        return null;
    }

    private boolean isUserDefined(LineNumberMap map, int line) {
        return map.get(line) > 0;
    }

    private String mapRenamedVariables(String message) {
        if (this.renamedVariableMap != null) {
            for (Map.Entry entry : this.renamedVariableMap.entrySet()) {
                String newVariableName = (String)entry.getKey();
                String oldVariableName = (String)entry.getValue();
                message = message.replaceAll("'" + newVariableName + "'", "'" + oldVariableName + "'");
            }
        }
        return message;
    }
}

