/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Logger;
import flex2.compiler.util.AbstractLogAdapter;
import java.util.HashMap;
import java.util.Map;

public class AbstractSyntaxTreeLogAdapter
extends AbstractLogAdapter {
    private Map<String, String> messages = new HashMap<String, String>();

    public AbstractSyntaxTreeLogAdapter(Logger original) {
        super(original);
    }

    public void log(ILocalizableMessage m, String source) {
        this.original.log(m);
    }

    public void logWarning(String path, int line, String warning, int errorCode) {
        String key = path + line;
        if (!warning.equals(this.messages.get(key))) {
            this.original.logWarning(path, line, warning, errorCode);
            this.messages.put(key, warning);
        }
    }

    public void logWarning(String path, int line, int col, String warning, String source) {
        String key = path + line;
        if (!warning.equals(this.messages.get(key))) {
            this.original.logWarning(path, line, warning);
            this.messages.put(key, warning);
        }
    }

    public void logWarning(String path, int line, int col, String warning, String source, int errorCode) {
        String key = path + line;
        if (!warning.equals(this.messages.get(key))) {
            this.original.logWarning(path, line, warning, errorCode);
            this.messages.put(key, warning);
        }
    }

    public void logError(String path, int line, String error, int errorCode) {
        String key = path + line;
        if (!error.equals(this.messages.get(key))) {
            this.original.logError(path, line, error, errorCode);
            this.messages.put(key, error);
        }
    }

    public void logError(String path, int line, int col, String error, String source) {
        String key = path + line;
        if (!error.equals(this.messages.get(key))) {
            this.original.logError(path, line, error);
            this.messages.put(key, error);
        }
    }

    public void logError(String path, int line, int col, String error, String source, int errorCode) {
        String key = path + line;
        if (!error.equals(this.messages.get(key))) {
            this.original.logError(path, line, error, errorCode);
            this.messages.put(key, error);
        }
    }
}

