/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.as3.binding.ArrayElementWatcher;
import flex2.compiler.as3.binding.Watcher;

public class PropertyWatcher
extends Watcher {
    private String property;
    private boolean suppressed;
    private boolean staticProperty;

    public PropertyWatcher(int id, String property) {
        super(id);
        this.property = property;
        this.suppressed = false;
    }

    public boolean shouldWriteSelf() {
        boolean result;
        boolean bl = result = !this.suppressed;
        if (this.suppressed) {
            for (Watcher watcher : this.childWatchers.values()) {
                if (watcher instanceof ArrayElementWatcher || !watcher.shouldWriteSelf()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public String getPathToProperty() {
        String result;
        Watcher parent = this.getParent();
        if (parent instanceof PropertyWatcher) {
            PropertyWatcher parentPropertyWatcher = (PropertyWatcher)parent;
            result = parentPropertyWatcher.getPathToProperty() + "." + this.property;
        } else {
            result = this.property;
        }
        return result;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean getStaticProperty() {
        return this.staticProperty;
    }

    public void setStaticProperty(boolean staticProperty) {
        this.staticProperty = staticProperty;
    }

    public void suppress() {
        this.suppressed = true;
    }
}

