/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.util.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ExceptionUtil {
    public static String[] unwrapMethods = new String[]{"getRootCause", "getTargetException", "getTargetError", "getException", "getCausedByException", "getLinkedException"};

    public static Throwable wrappedException(Throwable t) {
        return t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : ExceptionUtil.getRootCauseWithReflection(t);
    }

    public static Throwable baseException(Throwable t) {
        Throwable wrapped = ExceptionUtil.wrappedException(t);
        return wrapped != null ? ExceptionUtil.baseException(wrapped) : t;
    }

    public static String toString(Throwable t) {
        StringWriter strWrt = new StringWriter();
        t.printStackTrace(new PrintWriter(strWrt));
        return strWrt.toString();
    }

    public static String getStackTraceUpTo(Throwable t, String prefix) {
        StringTokenizer tokens = new StringTokenizer(ExceptionUtil.toString(t), "\n\r");
        StringBuffer trace = new StringBuffer();
        boolean done = false;
        String lookingFor = "at " + prefix;
        while (!done && tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            if (token.indexOf(lookingFor) == -1) {
                trace.append(token);
            } else {
                done = true;
            }
            trace.append(StringUtils.NEWLINE);
        }
        return trace.toString();
    }

    public static String getStackTraceLines(Throwable t, int numLines) {
        StringTokenizer tokens = new StringTokenizer(ExceptionUtil.toString(t), "\n\r");
        StringBuffer trace = new StringBuffer();
        for (int i = 0; i < numLines; ++i) {
            String token = tokens.nextToken();
            trace.append(token);
            trace.append(StringUtils.NEWLINE);
        }
        return trace.toString();
    }

    public static String getCallAt(Throwable t, int nth) {
        StringTokenizer tokens = new StringTokenizer(ExceptionUtil.toString(t), "\n\r");
        try {
            for (int i = 0; i <= nth; ++i) {
                tokens.nextToken();
            }
            String token = tokens.nextToken();
            int index1 = token.indexOf(32);
            int index2 = token.indexOf(40);
            StringBuffer call = new StringBuffer();
            call.append(token.substring(index1 < 0 ? 0 : index1 + 1, index2 < 0 ? call.length() : index2));
            int index3 = token.indexOf(58, index2 < 0 ? 0 : index2);
            if (index3 >= 0) {
                int index4 = token.indexOf(41, index3);
                call.append(token.substring(index3, index4 < 0 ? token.length() : index4));
            }
            return call.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            return "unknown";
        }
    }

    public static String exceptionToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        ExceptionUtil.printExceptionStack(t, out, 0);
        return sw.toString();
    }

    public static String exceptionFollowedByRootCausesToString(Throwable t) {
        StringBuffer output = new StringBuffer();
        Throwable root = t;
        while (root != null) {
            output.append(root == t ? (root instanceof Exception ? "  Exception: " : "  Error: ") : "  Root cause: ");
            output.append(ExceptionUtil.toString(root));
            Throwable cause = root.getCause();
            if (cause != (root = ExceptionUtil.wrappedException(root))) continue;
            break;
        }
        return output.toString();
    }

    protected static void printExceptionStack(Throwable th, PrintWriter out, int depth) {
        boolean printStackDepth = depth > 0;
        Throwable wrappedException = ExceptionUtil.wrappedException(th);
        if (wrappedException != null) {
            printStackDepth = true;
            ExceptionUtil.printExceptionStack(wrappedException, out, depth + 1);
        }
        if (printStackDepth) {
            out.write("[" + depth + "]");
        }
        th.printStackTrace(out);
    }

    private static Throwable getRootCauseWithReflection(Throwable t) {
        for (int i = 0; i < unwrapMethods.length; ++i) {
            Method m = null;
            try {
                m = t.getClass().getMethod(unwrapMethods[i], null);
                return (Throwable)m.invoke((Object)t, (Object[])null);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }
}

