/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc.zip;

import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.zip.ExtraFieldUtils;
import flex2.compiler.swc.zip.ZipExtraField;
import flex2.compiler.swc.zip.ZipShort;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ZipEntry
extends java.util.zip.ZipEntry
implements Cloneable {
    private static final int PLATFORM_UNIX = 3;
    private static final int PLATFORM_FAT = 0;
    private int internalAttributes = 0;
    private int platform = 0;
    private long externalAttributes = 0L;
    private Vector<ZipExtraField> extraFields = new Vector();
    private String name = null;
    private Long compressedSize = null;
    private static Method setCompressedSizeMethod = null;
    private static Object lockReflection = new Object();
    private static boolean triedToGetMethod = false;

    public ZipEntry(String name) {
        super(name);
    }

    public ZipEntry(java.util.zip.ZipEntry entry) {
        super(entry.getName());
        byte[] extra;
        long crc;
        long cSize;
        this.setComment(entry.getComment());
        this.setMethod(entry.getMethod());
        this.setTime(entry.getTime());
        long size = entry.getSize();
        if (size > 0L) {
            this.setSize(size);
        }
        if ((cSize = entry.getCompressedSize()) > 0L) {
            this.setComprSize(cSize);
        }
        if ((crc = entry.getCrc()) > 0L) {
            this.setCrc(crc);
        }
        if ((extra = entry.getExtra()) != null) {
            this.setExtraFields(ExtraFieldUtils.parse(extra));
        } else {
            this.setExtra();
        }
    }

    public ZipEntry(ZipEntry entry) {
        this((java.util.zip.ZipEntry)entry);
        this.setInternalAttributes(entry.getInternalAttributes());
        this.setExternalAttributes(entry.getExternalAttributes());
        this.setExtraFields(entry.getExtraFields());
    }

    protected ZipEntry() {
        super("");
    }

    public Object clone() {
        try {
            Vector tmpExtraFields;
            long crc;
            long cSize;
            ZipEntry e = (ZipEntry)super.clone();
            e.setName(this.getName());
            e.setComment(this.getComment());
            e.setMethod(this.getMethod());
            e.setTime(this.getTime());
            long size = this.getSize();
            if (size > 0L) {
                e.setSize(size);
            }
            if ((cSize = this.getCompressedSize()) > 0L) {
                e.setComprSize(cSize);
            }
            if ((crc = this.getCrc()) > 0L) {
                e.setCrc(crc);
            }
            e.extraFields = tmpExtraFields = (Vector)this.extraFields.clone();
            e.setInternalAttributes(this.getInternalAttributes());
            e.setExternalAttributes(this.getExternalAttributes());
            e.setExtraFields(this.getExtraFields());
            return e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int value) {
        this.internalAttributes = value;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long value) {
        this.externalAttributes = value;
    }

    public void setUnixMode(int mode) {
        this.setExternalAttributes(mode << 16 | ((mode & 0x80) == 0 ? 1 : 0) | (this.isDirectory() ? 16 : 0));
        this.platform = 3;
    }

    public int getUnixMode() {
        return (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int platform) {
        this.platform = platform;
    }

    public void setExtraFields(ZipExtraField[] fields) {
        this.extraFields.removeAllElements();
        for (int i = 0; i < fields.length; ++i) {
            this.extraFields.addElement(fields[i]);
        }
        this.setExtra();
    }

    public ZipExtraField[] getExtraFields() {
        Object[] result = new ZipExtraField[this.extraFields.size()];
        this.extraFields.copyInto(result);
        return result;
    }

    public void addExtraField(ZipExtraField ze) {
        ZipShort type = ze.getHeaderId();
        boolean done = false;
        for (int i = 0; !done && i < this.extraFields.size(); ++i) {
            if (!this.extraFields.elementAt(i).getHeaderId().equals(type)) continue;
            this.extraFields.setElementAt(ze, i);
            done = true;
        }
        if (!done) {
            this.extraFields.addElement(ze);
        }
        this.setExtra();
    }

    public void removeExtraField(ZipShort type) {
        boolean done = false;
        for (int i = 0; !done && i < this.extraFields.size(); ++i) {
            if (!this.extraFields.elementAt(i).getHeaderId().equals(type)) continue;
            this.extraFields.removeElementAt(i);
            done = true;
        }
        if (!done) {
            throw new NoSuchElementException();
        }
        this.setExtra();
    }

    public void setExtra(byte[] extra) throws RuntimeException {
        try {
            this.setExtraFields(ExtraFieldUtils.parse(extra));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getExtraFields()));
    }

    public byte[] getLocalFileDataExtra() {
        byte[] extra = this.getExtra();
        return extra != null ? extra : new byte[]{};
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getExtraFields());
    }

    public void setComprSize(long size) {
        if (ZipEntry.haveSetCompressedSize()) {
            ZipEntry.performSetCompressedSize(this, size);
        } else {
            this.compressedSize = new Long(size);
        }
    }

    public long getCompressedSize() {
        if (this.compressedSize != null) {
            return this.compressedSize;
        }
        return super.getCompressedSize();
    }

    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    protected void setName(String name) {
        this.name = name;
    }

    private static boolean haveSetCompressedSize() {
        ZipEntry.checkSCS();
        return setCompressedSizeMethod != null;
    }

    private static void performSetCompressedSize(ZipEntry ze, long size) {
        Object[] s = new Object[]{new Long(size)};
        try {
            setCompressedSizeMethod.invoke((Object)ze, s);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            throw new SwcException.CouldNotSetZipSize(ze.getName(), nested.getMessage());
        }
        catch (Throwable other) {
            throw new SwcException.CouldNotSetZipSize(ze.getName(), other.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkSCS() {
        if (!triedToGetMethod) {
            Object object = lockReflection;
            synchronized (object) {
                triedToGetMethod = true;
                try {
                    setCompressedSizeMethod = java.util.zip.ZipEntry.class.getMethod("setCompressedSize", Long.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
    }
}

