/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.AbstractConfigurationParser;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ClientConfiguration;
import flex.messaging.config.ClusterSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.DestinationSettings;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.config.LocalFileResolver;
import flex.messaging.config.ServiceSettings;
import flex.messaging.config.TokenReplacer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ClientConfigurationParser
extends AbstractConfigurationParser {
    @Override
    protected void parseTopLevelConfig(Document doc) {
        Node root = this.selectSingleNode(doc, "/services-config");
        if (root != null) {
            this.allowedChildElements(root, SERVICES_CONFIG_CHILDREN);
            this.channelsSection(root);
            this.services(root);
            this.clusters(root);
            this.flexClient(root);
        }
    }

    private void channelsSection(Node root) {
        Node channelsNode = this.selectSingleNode(root, "channels");
        if (channelsNode != null) {
            this.allowedAttributesOrElements(channelsNode, CHANNELS_CHILDREN);
            NodeList channels = this.selectNodeList(channelsNode, "channel-definition");
            for (int i = 0; i < channels.getLength(); ++i) {
                Node channel = channels.item(i);
                this.channelDefinition(channel);
            }
            NodeList includes = this.selectNodeList(channelsNode, "channel-include");
            for (int i = 0; i < includes.getLength(); ++i) {
                Node include = includes.item(i);
                this.channelInclude(include);
            }
        }
    }

    private void channelDefinition(Node channel) {
        this.requiredAttributesOrElements(channel, CHANNEL_DEFINITION_REQ_CHILDREN);
        this.allowedAttributesOrElements(channel, CHANNEL_DEFINITION_CHILDREN);
        String id = this.getAttributeOrChildElement(channel, "id").trim();
        if (ClientConfigurationParser.isValidID(id)) {
            String enableSmallMessages;
            ConfigMap map;
            ConfigMap serialization;
            if (this.config.getChannelSettings(id) != null) {
                ConfigurationException e = new ConfigurationException();
                e.setMessage(11127, new Object[]{id});
                throw e;
            }
            ChannelSettings channelSettings = new ChannelSettings(id);
            Node endpoint = this.selectSingleNode(channel, "endpoint");
            if (endpoint != null) {
                this.allowedAttributesOrElements(endpoint, ENDPOINT_CHILDREN);
                String uri = this.getAttributeOrChildElement(endpoint, "url");
                if (uri == null || "".equals(uri)) {
                    uri = this.getAttributeOrChildElement(endpoint, "uri");
                }
                channelSettings.setUri(uri);
                this.config.addChannelSettings(id, channelSettings);
            }
            this.channelServerOnlyAttribute(channel, channelSettings);
            this.addProperty(channel, channelSettings, "polling-enabled");
            this.addProperty(channel, channelSettings, "polling-interval-millis");
            this.addProperty(channel, channelSettings, "piggybacking-enabled");
            this.addProperty(channel, channelSettings, "login-after-disconnect");
            this.addProperty(channel, channelSettings, "record-message-sizes");
            this.addProperty(channel, channelSettings, "record-message-times");
            this.addProperty(channel, channelSettings, "connect-timeout-seconds");
            this.addProperty(channel, channelSettings, "polling-interval-seconds");
            this.addProperty(channel, channelSettings, "client-load-balancing");
            this.addProperty(channel, channelSettings, "request-timeout-seconds");
            NodeList properties = this.selectNodeList(channel, "properties/serialization");
            if (properties.getLength() > 0 && (serialization = (map = this.properties(properties, this.getSourceFileOf(channel))).getPropertyAsMap("serialization", null)) != null && (enableSmallMessages = serialization.getProperty("enable-small-messages")) != null) {
                ConfigMap clientMap = new ConfigMap();
                clientMap.addProperty("enable-small-messages", enableSmallMessages);
                channelSettings.addProperty("serialization", clientMap);
            }
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10110, new Object[]{"channel-definition", id});
            String details = "An id must be non-empty and not contain any list delimiter characters, i.e. commas, semi-colons or colons.";
            ex.setDetails(details);
            throw ex;
        }
    }

    private void channelServerOnlyAttribute(Node channel, ChannelSettings channelSettings) {
        boolean serverOnly;
        String clientType = this.getAttributeOrChildElement(channel, "class");
        clientType = clientType.length() > 0 ? clientType : null;
        String serverOnlyString = this.getAttributeOrChildElement(channel, "server-only");
        boolean bl = serverOnly = serverOnlyString.length() > 0 && Boolean.valueOf(serverOnlyString) != false;
        if (clientType == null && !serverOnly) {
            boolean serverOnlyProtocol;
            String url = channelSettings.getUri();
            boolean bl2 = serverOnlyProtocol = url.startsWith("samfsocket") || url.startsWith("amfsocket") || url.startsWith("ws");
            if (!serverOnlyProtocol) {
                ConfigurationException ce = new ConfigurationException();
                ce.setMessage(11139, new Object[]{channelSettings.getId()});
                throw ce;
            }
            channelSettings.setServerOnly(true);
        } else {
            if (clientType != null && serverOnly) {
                ConfigurationException ce = new ConfigurationException();
                ce.setMessage(11140, new Object[]{channelSettings.getId()});
                throw ce;
            }
            if (serverOnly) {
                channelSettings.setServerOnly(true);
            } else {
                channelSettings.setClientType(clientType);
            }
        }
    }

    private void addProperty(Node channel, ChannelSettings channelSettings, String property) {
        NodeList properties = this.selectNodeList(channel, "properties/" + property);
        if (properties.getLength() > 0) {
            ConfigMap map = this.properties(properties, this.getSourceFileOf(channel));
            if ("client-load-balancing".equals(property)) {
                ConfigMap clientLoadBalancingMap = map.getPropertyAsMap("client-load-balancing", null);
                if (clientLoadBalancingMap == null) {
                    ConfigurationException ce = new ConfigurationException();
                    ce.setMessage(11141, new Object[]{"client-load-balancing", channelSettings.getId()});
                    throw ce;
                }
                List urls = clientLoadBalancingMap.getPropertyAsList("url", null);
                this.addClientLoadBalancingUrls(urls, channelSettings.getId());
            }
            channelSettings.addProperties(map);
        }
    }

    private void addClientLoadBalancingUrls(List urls, String endpointId) {
        if (urls == null || urls.isEmpty()) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(11141, new Object[]{"client-load-balancing", endpointId});
            throw ce;
        }
        HashSet<String> clientLoadBalancingUrls = new HashSet<String>();
        Iterator iterator = urls.iterator();
        while (iterator.hasNext()) {
            String url = (String)iterator.next();
            if (url == null || url.length() == 0) {
                ConfigurationException ce = new ConfigurationException();
                ce.setMessage(11142, new Object[]{"client-load-balancing", endpointId});
                throw ce;
            }
            if (TokenReplacer.containsTokens(url)) {
                ConfigurationException ce = new ConfigurationException();
                ce.setMessage(11147, new Object[]{"client-load-balancing", endpointId});
                throw ce;
            }
            if (clientLoadBalancingUrls.contains(url)) {
                iterator.remove();
                continue;
            }
            clientLoadBalancingUrls.add(url);
        }
    }

    private void channelInclude(Node channelInclude) {
        this.allowedAttributesOrElements(channelInclude, CHANNEL_INCLUDE_CHILDREN);
        String src = this.getAttributeOrChildElement(channelInclude, "file-path");
        String dir = this.getAttributeOrChildElement(channelInclude, "directory-path");
        if (src.length() > 0) {
            this.channelIncludeFile(src);
        } else if (dir.length() > 0) {
            this.channelIncludeDirectory(dir);
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10118, new Object[]{channelInclude.getNodeName(), "file-path", "directory-path"});
            throw ex;
        }
    }

    private void channelIncludeFile(String src) {
        Document doc = this.loadDocument(src, this.fileResolver.getIncludedFile(src));
        if (this.fileResolver instanceof LocalFileResolver) {
            LocalFileResolver local = (LocalFileResolver)this.fileResolver;
            ((ClientConfiguration)this.config).addConfigPath(local.getIncludedPath(src), local.getIncludedLastModified(src));
        }
        doc.getDocumentElement().normalize();
        Node channelsNode = this.selectSingleNode(doc, "channels");
        if (channelsNode != null) {
            this.allowedChildElements(channelsNode, CHANNELS_CHILDREN);
            NodeList channels = this.selectNodeList(channelsNode, "channel-definition");
            for (int a = 0; a < channels.getLength(); ++a) {
                Node service = channels.item(a);
                this.channelDefinition(service);
            }
            this.fileResolver.popIncludedFile();
        } else {
            Node channel = this.selectSingleNode(doc, "/channel-definition");
            if (channel != null) {
                this.channelDefinition(channel);
                this.fileResolver.popIncludedFile();
            } else {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10112, new Object[]{"channel-include", src, "channels", "channel-definition"});
                throw ex;
            }
        }
    }

    private void channelIncludeDirectory(String dir) {
        List files = this.fileResolver.getFiles(dir);
        for (int i = 0; i < files.size(); ++i) {
            String src = (String)files.get(i);
            this.channelIncludeFile(src);
        }
    }

    private void services(Node root) {
        Node servicesNode = this.selectSingleNode(root, "services");
        if (servicesNode != null) {
            Node service;
            int i;
            this.allowedChildElements(servicesNode, SERVICES_CHILDREN);
            Node defaultChannels = this.selectSingleNode(servicesNode, "default-channels");
            if (defaultChannels != null) {
                this.allowedChildElements(defaultChannels, DEFAULT_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(defaultChannels, "channel");
                for (int c = 0; c < channels.getLength(); ++c) {
                    Node chan = channels.item(c);
                    this.allowedAttributes(chan, new String[]{"ref"});
                    this.defaultChannel(chan);
                }
            }
            NodeList services = this.selectNodeList(servicesNode, "service-include");
            for (i = 0; i < services.getLength(); ++i) {
                service = services.item(i);
                this.serviceInclude(service);
            }
            services = this.selectNodeList(servicesNode, "service");
            for (i = 0; i < services.getLength(); ++i) {
                service = services.item(i);
                this.service(service);
            }
        }
    }

    private void clusters(Node root) {
        Node clusteringNode = this.selectSingleNode(root, "clusters");
        if (clusteringNode != null) {
            this.allowedAttributesOrElements(clusteringNode, CLUSTERING_CHILDREN);
            NodeList clusters = this.selectNodeList(clusteringNode, "cluster");
            for (int i = 0; i < clusters.getLength(); ++i) {
                String ulb;
                Node cluster = clusters.item(i);
                this.requiredAttributesOrElements(cluster, CLUSTER_DEFINITION_CHILDREN);
                String clusterName = this.getAttributeOrChildElement(cluster, "id");
                if (!ClientConfigurationParser.isValidID(clusterName)) continue;
                String propsFileName = this.getAttributeOrChildElement(cluster, "properties");
                ClusterSettings clusterSettings = new ClusterSettings();
                clusterSettings.setClusterName(clusterName);
                clusterSettings.setPropsFileName(propsFileName);
                String defaultValue = this.getAttributeOrChildElement(cluster, "default");
                if (defaultValue != null && defaultValue.length() > 0) {
                    if (defaultValue.equalsIgnoreCase("true")) {
                        clusterSettings.setDefault(true);
                    } else if (!defaultValue.equalsIgnoreCase("false")) {
                        ConfigurationException e = new ConfigurationException();
                        e.setMessage(10215, new Object[]{clusterName, defaultValue});
                        throw e;
                    }
                }
                if ((ulb = this.getAttributeOrChildElement(cluster, "url-load-balancing")) != null && ulb.length() > 0) {
                    if (ulb.equalsIgnoreCase("false")) {
                        clusterSettings.setURLLoadBalancing(false);
                    } else if (!ulb.equalsIgnoreCase("true")) {
                        ConfigurationException e = new ConfigurationException();
                        e.setMessage(10216, new Object[]{clusterName, ulb});
                        throw e;
                    }
                }
                ((ClientConfiguration)this.config).addClusterSettings(clusterSettings);
            }
        }
    }

    private void serviceInclude(Node serviceInclude) {
        this.allowedAttributesOrElements(serviceInclude, SERVICE_INCLUDE_CHILDREN);
        String src = this.getAttributeOrChildElement(serviceInclude, "file-path");
        String dir = this.getAttributeOrChildElement(serviceInclude, "directory-path");
        if (src.length() > 0) {
            this.serviceIncludeFile(src);
        } else if (dir.length() > 0) {
            this.serviceIncludeDirectory(dir);
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10118, new Object[]{serviceInclude.getNodeName(), "file-path", "directory-path"});
            throw ex;
        }
    }

    private void serviceIncludeFile(String src) {
        Document doc = this.loadDocument(src, this.fileResolver.getIncludedFile(src));
        if (this.fileResolver instanceof LocalFileResolver) {
            LocalFileResolver local = (LocalFileResolver)this.fileResolver;
            ((ClientConfiguration)this.config).addConfigPath(local.getIncludedPath(src), local.getIncludedLastModified(src));
        }
        doc.getDocumentElement().normalize();
        Node servicesNode = this.selectSingleNode(doc, "services");
        if (servicesNode != null) {
            this.allowedChildElements(servicesNode, SERVICES_CHILDREN);
            NodeList services = this.selectNodeList(servicesNode, "services");
            for (int a = 0; a < services.getLength(); ++a) {
                Node service = services.item(a);
                this.service(service);
            }
            this.fileResolver.popIncludedFile();
        } else {
            Node service = this.selectSingleNode(doc, "/service");
            if (service != null) {
                this.service(service);
                this.fileResolver.popIncludedFile();
            } else {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10112, new Object[]{"service-include", src, "services", "service"});
                throw ex;
            }
        }
    }

    private void serviceIncludeDirectory(String dir) {
        List files = this.fileResolver.getFiles(dir);
        for (int i = 0; i < files.size(); ++i) {
            String src = (String)files.get(i);
            this.serviceIncludeFile(src);
        }
    }

    private void service(Node service) {
        this.requiredAttributesOrElements(service, SERVICE_REQ_CHILDREN);
        this.allowedAttributesOrElements(service, SERVICE_CHILDREN);
        String id = this.getAttributeOrChildElement(service, "id");
        if (ClientConfigurationParser.isValidID(id)) {
            Node dest;
            int i;
            ServiceSettings serviceSettings = this.config.getServiceSettings(id);
            if (serviceSettings == null) {
                serviceSettings = new ServiceSettings(id);
                NodeList properties = this.selectNodeList(service, "properties/*");
                if (properties.getLength() > 0) {
                    ConfigMap map = this.properties(properties, this.getSourceFileOf(service));
                    serviceSettings.addProperties(map);
                }
            } else {
                ConfigurationException e = new ConfigurationException();
                e.setMessage(10113, new Object[]{id});
                throw e;
            }
            this.config.addServiceSettings(serviceSettings);
            String className = this.getAttributeOrChildElement(service, "class");
            if (className.length() <= 0) {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10114, new Object[]{"service", id});
                throw ex;
            }
            serviceSettings.setClassName(className);
            Node defaultChannels = this.selectSingleNode(service, "default-channels");
            if (defaultChannels != null) {
                this.allowedChildElements(defaultChannels, DEFAULT_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(defaultChannels, "channel");
                for (int c = 0; c < channels.getLength(); ++c) {
                    Node chan = channels.item(c);
                    this.allowedAttributes(chan, new String[]{"ref"});
                    this.defaultChannel(chan, serviceSettings);
                }
            } else if (this.config.getDefaultChannels().size() > 0) {
                for (String channelId : this.config.getDefaultChannels()) {
                    ChannelSettings channel = this.config.getChannelSettings(channelId);
                    serviceSettings.addDefaultChannel(channel);
                }
            }
            NodeList list = this.selectNodeList(service, "destination");
            for (i = 0; i < list.getLength(); ++i) {
                dest = list.item(i);
                this.destination(dest, serviceSettings);
            }
            list = this.selectNodeList(service, "destination-include");
            for (i = 0; i < list.getLength(); ++i) {
                dest = list.item(i);
                this.destinationInclude(dest, serviceSettings);
            }
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10110, new Object[]{"service", id});
            throw ex;
        }
    }

    private void defaultChannel(Node chan) {
        ChannelSettings channel;
        String ref = this.getAttributeOrChildElement(chan, "ref");
        if (ref.length() > 0) {
            channel = this.config.getChannelSettings(ref);
            if (channel == null) {
                ConfigurationException e = new ConfigurationException();
                e.setMessage(10109, new Object[]{"channel", ref});
                throw e;
            }
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10116, new Object[]{"MessageBroker"});
            throw ex;
        }
        this.config.addDefaultChannel(channel.getId());
    }

    private void defaultChannel(Node chan, ServiceSettings serviceSettings) {
        ChannelSettings channel;
        String ref = this.getAttributeOrChildElement(chan, "ref").trim();
        if (ref.length() > 0) {
            channel = this.config.getChannelSettings(ref);
            if (channel == null) {
                ConfigurationException e = new ConfigurationException();
                e.setMessage(10109, new Object[]{"channel", ref});
                throw e;
            }
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10116, new Object[]{serviceSettings.getId()});
            throw ex;
        }
        serviceSettings.addDefaultChannel(channel);
    }

    private void destinationInclude(Node destInclude, ServiceSettings serviceSettings) {
        this.allowedAttributesOrElements(destInclude, DESTINATION_INCLUDE_CHILDREN);
        String src = this.getAttributeOrChildElement(destInclude, "file-path");
        String dir = this.getAttributeOrChildElement(destInclude, "directory-path");
        if (src.length() > 0) {
            this.destinationIncludeFile(serviceSettings, src);
        } else if (dir.length() > 0) {
            this.destinationIncludeDirectory(serviceSettings, dir);
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10118, new Object[]{destInclude.getNodeName(), "file-path", "directory-path"});
            throw ex;
        }
    }

    private void destinationIncludeDirectory(ServiceSettings serviceSettings, String dir) {
        List files = this.fileResolver.getFiles(dir);
        for (int i = 0; i < files.size(); ++i) {
            String src = (String)files.get(i);
            this.destinationIncludeFile(serviceSettings, src);
        }
    }

    private void destinationIncludeFile(ServiceSettings serviceSettings, String src) {
        Document doc = this.loadDocument(src, this.fileResolver.getIncludedFile(src));
        if (this.fileResolver instanceof LocalFileResolver) {
            LocalFileResolver local = (LocalFileResolver)this.fileResolver;
            ((ClientConfiguration)this.config).addConfigPath(local.getIncludedPath(src), local.getIncludedLastModified(src));
        }
        doc.getDocumentElement().normalize();
        Node destinationsNode = this.selectSingleNode(doc, "destinations");
        if (destinationsNode != null) {
            this.allowedChildElements(destinationsNode, DESTINATIONS_CHILDREN);
            NodeList destinations = this.selectNodeList(destinationsNode, "destination");
            for (int a = 0; a < destinations.getLength(); ++a) {
                Node dest = destinations.item(a);
                this.destination(dest, serviceSettings);
            }
            this.fileResolver.popIncludedFile();
        } else {
            Node dest = this.selectSingleNode(doc, "/destination");
            if (dest != null) {
                this.destination(dest, serviceSettings);
                this.fileResolver.popIncludedFile();
            } else {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10112, new Object[]{"destination-include", src, "destinations", "destination"});
                throw ex;
            }
        }
    }

    private void destination(Node dest, ServiceSettings serviceSettings) {
        DestinationSettings destinationSettings;
        this.requiredAttributesOrElements(dest, DESTINATION_REQ_CHILDREN);
        this.allowedAttributes(dest, DESTINATION_ATTR);
        this.allowedChildElements(dest, DESTINATION_CHILDREN);
        String serviceId = serviceSettings.getId();
        String id = this.getAttributeOrChildElement(dest, "id");
        if (ClientConfigurationParser.isValidID(id)) {
            destinationSettings = (DestinationSettings)serviceSettings.getDestinationSettings().get(id);
            if (destinationSettings != null) {
                ConfigurationException e = new ConfigurationException();
                e.setMessage(10122, new Object[]{id, serviceId});
                throw e;
            }
        } else {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10119, new Object[]{"destination", id, serviceId});
            throw ex;
        }
        destinationSettings = new DestinationSettings(id);
        serviceSettings.addDestinationSettings(destinationSettings);
        NodeList properties = this.selectNodeList(dest, "properties/*");
        if (properties.getLength() > 0) {
            ConfigMap map = this.properties(properties, this.getSourceFileOf(dest));
            destinationSettings.addProperties(map);
        }
        this.destinationChannels(dest, destinationSettings, serviceSettings);
    }

    private void destinationChannels(Node dest, DestinationSettings destinationSettings, ServiceSettings serviceSettings) {
        String destId = destinationSettings.getId();
        String channelsList = this.evaluateExpression(dest, "@channels").toString().trim();
        if (channelsList.length() > 0) {
            StringTokenizer st = new StringTokenizer(channelsList, ",;:");
            while (st.hasMoreTokens()) {
                String ref = st.nextToken().trim();
                ChannelSettings channel = this.config.getChannelSettings(ref);
                if (channel != null) {
                    destinationSettings.addChannelSettings(channel);
                    continue;
                }
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(10120, new Object[]{"channel", ref, destId});
                throw ex;
            }
        } else {
            Node channelsNode = this.selectSingleNode(dest, "channels");
            if (channelsNode != null) {
                this.allowedChildElements(channelsNode, DESTINATION_CHANNELS_CHILDREN);
                NodeList channels = this.selectNodeList(channelsNode, "channel");
                if (channels.getLength() > 0) {
                    for (int c = 0; c < channels.getLength(); ++c) {
                        ChannelSettings channel;
                        Node chan = channels.item(c);
                        this.requiredAttributesOrElements(chan, DESTINATION_CHANNEL_REQ_CHILDREN);
                        String ref = this.getAttributeOrChildElement(chan, "ref").trim();
                        if (ref.length() > 0) {
                            channel = this.config.getChannelSettings(ref);
                            if (channel == null) {
                                ConfigurationException ex = new ConfigurationException();
                                ex.setMessage(10120, new Object[]{"channel", ref, destId});
                                throw ex;
                            }
                        } else {
                            ConfigurationException ex = new ConfigurationException();
                            ex.setMessage(10121, new Object[]{"channel", ref, destId});
                            throw ex;
                        }
                        destinationSettings.addChannelSettings(channel);
                    }
                }
            } else {
                List defaultChannels = serviceSettings.getDefaultChannels();
                for (ChannelSettings channel : defaultChannels) {
                    destinationSettings.addChannelSettings(channel);
                }
            }
        }
        if (destinationSettings.getChannelSettings().size() <= 0) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10123, new Object[]{destId});
            throw ex;
        }
    }

    private void flexClient(Node root) {
        Node flexClient = this.selectSingleNode(root, "flex-client");
        if (flexClient != null) {
            FlexClientSettings flexClientSettings = new FlexClientSettings();
            String reliableReconnectDurationMillis = this.getAttributeOrChildElement(flexClient, "reliable-reconnect-duration-millis");
            if (reliableReconnectDurationMillis.length() > 0) {
                try {
                    int millis = Integer.parseInt(reliableReconnectDurationMillis);
                    if (millis < 0) {
                        ConfigurationException e = new ConfigurationException();
                        e.setMessage(11137, new Object[]{reliableReconnectDurationMillis});
                        throw e;
                    }
                    flexClientSettings.setReliableReconnectDurationMillis(millis);
                }
                catch (NumberFormatException nfe) {
                    ConfigurationException e = new ConfigurationException();
                    e.setMessage(11137, new Object[]{reliableReconnectDurationMillis});
                    throw e;
                }
            } else {
                flexClientSettings.setReliableReconnectDurationMillis(0);
            }
            String heartbeatIntervalMillis = this.getAttributeOrChildElement(flexClient, "heartbeat-interval-millis");
            if (heartbeatIntervalMillis.length() > 0) {
                try {
                    int millis = Integer.parseInt(heartbeatIntervalMillis);
                    if (millis < 0) {
                        ConfigurationException e = new ConfigurationException();
                        e.setMessage(11146, new Object[]{heartbeatIntervalMillis});
                        throw e;
                    }
                    flexClientSettings.setHeartbeatIntervalMillis(millis);
                }
                catch (NumberFormatException nfe) {
                    ConfigurationException e = new ConfigurationException();
                    e.setMessage(11146, new Object[]{heartbeatIntervalMillis});
                    throw e;
                }
            }
            ((ClientConfiguration)this.config).setFlexClientSettings(flexClientSettings);
        }
    }
}

