/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Block;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.IntList;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlowGraphEmitter
extends Emitter {
    private boolean hasLeader;
    private ObjectList<Block> blocks = new ObjectList();
    private ObjectList<Node> defs = new ObjectList();
    private int cur_block;
    private int def_count;
    private boolean show_blocks;
    private int within_try_block;
    private Context cx;
    protected int max_temp_count;
    protected int cur_temp_count;
    protected int max_stack;
    protected int cur_stack;
    protected char max_params;
    protected String scriptname;
    protected IntList if_addrs = new IntList();
    protected IntList else_addrs = new IntList();
    protected IntList loopbegin_addrs = new IntList();
    protected ObjectList<IntList> break_addrs = new ObjectList();
    protected ObjectList<IntList> continue_addrs = new ObjectList();
    protected IntList switchbegin_addrs = new IntList();
    protected ObjectList<IntList> case_addrs = new ObjectList();
    protected IntList default_addrs = new IntList();
    protected IntList seen_default_case = new IntList();
    protected int current_with_count;
    protected IntList with_count = new IntList();
    protected IntList try_addrs = new IntList();
    protected ObjectList<IntList> catch_addrs = new ObjectList();
    static final int scopes_register = 0;
    static final int obj_register = 1;
    static final int args_register = 2;
    public IntList stackDepthStack = new IntList();
    public boolean show_instructions;
    public boolean show_linenums;
    public boolean show_stacknames;

    public void EnterBlock() {
        if (this.hasLeader) {
            this.hasLeader = false;
            if (this.cur_block != this.blocks.size() - 1) assert (false);
            this.blocks.add(this.cx.newBlock());
            ++this.cur_block;
        }
    }

    public BitSet NewDef(Node node) {
        BitSet def_mask = null;
        if (this.def_count >= 1000) {
            for (Block block : this.blocks) {
                block.def_bits = null;
            }
        } else {
            def_mask = BitSet.set(null, this.def_count, true);
            if (this.defs.size() <= this.def_count) {
                this.defs.resize(this.def_count + 1);
            }
            this.defs.set(this.def_count, node);
            Block block = (Block)this.blocks.get(this.cur_block);
            block.def_bits = BitSet.set(block.def_bits, this.def_count, true);
        }
        ++this.def_count;
        return def_mask;
    }

    public ObjectList<Node> GetDefs(BitSet def_bits) {
        ObjectList<Node> defs = new ObjectList<Node>();
        int i = BitSet.nextSetBit(def_bits, 0);
        while (i >= 0) {
            defs.add((Node)this.defs.get(i));
            i = BitSet.nextSetBit(def_bits, i + 1);
        }
        return defs;
    }

    public int GetBlock() {
        if (!this.hasLeader) {
            this.hasLeader = true;
        }
        return this.cur_block;
    }

    public Block getBlock() {
        return (Block)this.blocks.get(this.cur_block);
    }

    public void AddStmtToBlock(String stmt) {
        if (!this.hasLeader) {
            this.hasLeader = true;
            if (this.show_blocks) {
                ((Block)this.blocks.get((int)this.cur_block)).stmts = "\n    " + stmt;
            }
        }
    }

    public void EnterTerminalBlock() {
        this.EnterBlock();
        ((Block)this.blocks.get((int)this.cur_block)).is_terminal = true;
        this.AddStmtToBlock("terminal block for return");
        this.EnterBlock();
    }

    public boolean blockIsTerminal(int b) {
        return ((Block)this.blocks.get((int)b)).is_terminal;
    }

    public void AddEdge(int b1, int b2) {
        int i;
        if (((Block)this.blocks.get((int)b1)).is_terminal) {
            return;
        }
        IntList succs = ((Block)this.blocks.get((int)b1)).succs;
        int n = succs.size();
        for (i = 0; i < n && succs.get(i) != b2; ++i) {
        }
        if (i == n) {
            succs.add(b2);
        }
        IntList preds = ((Block)this.blocks.get((int)b2)).preds;
        n = preds.size();
        for (i = 0; i < n && preds.get(i) != b1; ++i) {
        }
        if (i == n) {
            preds.add(b1);
        }
    }

    public ObjectList<Block> GetBlocks() {
        return this.blocks;
    }

    public void InitGraph() {
        this.blocks.clear();
        this.cur_block = 0;
        this.hasLeader = true;
        this.blocks.add(this.cx.newBlock());
    }

    public void calcGenAndKill(Context cx) {
        BitSet gen_bits = null;
        BitSet kill_bits = null;
        int size = this.blocks.size();
        for (int i = 0; i < size; ++i) {
            Block block = (Block)this.blocks.get(i);
            BitSet defbits = block.def_bits;
            int n = BitSet.nextSetBit(defbits, 0);
            while (n >= 0) {
                Slot slot;
                Node node = (Node)this.defs.get(n);
                if (node != null && (slot = node.getRef(cx).getSlot(cx, -79)) != null) {
                    gen_bits = BitSet.set(null, n, true);
                    kill_bits = slot.getDefBits() != null ? BitSet.xor(slot.getDefBits(), gen_bits) : gen_bits;
                }
                block.gen_bits = BitSet.reset_set(block.gen_bits, kill_bits, gen_bits);
                block.kill_bits = BitSet.reset_set(block.kill_bits, gen_bits, kill_bits);
                n = BitSet.nextSetBit(defbits, n + 1);
            }
        }
    }

    public void calcInAndOut(Context cx) {
        boolean change;
        int size = this.blocks.size();
        for (int i = 0; i < size; ++i) {
            Block block = (Block)this.blocks.get(i);
            block.in_bits = null;
            block.out_bits = BitSet.copy(block.gen_bits);
        }
        do {
            change = false;
            int size2 = this.blocks.size();
            for (int i = 0; i < size2; ++i) {
                Block block = (Block)this.blocks.get(i);
                int terminalPreds = 0;
                for (int n = 0; n < block.preds.size(); ++n) {
                    Block pred = (Block)this.blocks.get(block.preds.get(n));
                    block.in_bits = BitSet.set(block.in_bits, pred.out_bits);
                    if (block.preds.get(n) == 0 || pred.preds.size() != 0) continue;
                    ++terminalPreds;
                }
                if (terminalPreds == block.preds.size() && !block.is_terminal) {
                    block.is_terminal = true;
                    block.preds.clear();
                    change = true;
                }
                BitSet out_bits = BitSet.copy(block.in_bits);
                if (BitSet.equals(block.out_bits, out_bits = BitSet.reset_set(out_bits, block.kill_bits, block.gen_bits))) continue;
                change = true;
                block.out_bits = out_bits;
            }
        } while (change);
    }

    public void printBlocks(Context cx) {
        int size = this.blocks.size();
        for (int i = 0; i < size; ++i) {
            int j;
            Block block = (Block)this.blocks.get(i);
            System.out.print("\nB" + i + ": Pred {");
            for (j = 0; j < block.preds.size(); ++j) {
                System.out.print(" B" + block.preds.get(j));
            }
            System.out.print(" } Succ {");
            for (j = 0; j < block.succs.size(); ++j) {
                System.out.print(" B" + block.succs.get(j));
            }
            System.out.print(" } Def {");
            BitSet bits = block.def_bits;
            int n = BitSet.nextSetBit(bits, 0);
            while (n >= 0) {
                System.out.print(" d" + n);
                n = BitSet.nextSetBit(bits, n + 1);
            }
            System.out.print(" } Gen {");
            bits = block.gen_bits;
            n = BitSet.nextSetBit(bits, 0);
            while (n >= 0) {
                System.out.print(" d" + n);
                n = BitSet.nextSetBit(bits, n + 1);
            }
            System.out.print(" } Kill {");
            bits = block.kill_bits;
            n = BitSet.nextSetBit(bits, 0);
            while (n >= 0) {
                System.out.print(" d" + n);
                n = BitSet.nextSetBit(bits, n + 1);
            }
            System.out.print(" } In {");
            bits = block.in_bits;
            n = BitSet.nextSetBit(bits, 0);
            while (n >= 0) {
                System.out.print(" d" + n);
                n = BitSet.nextSetBit(bits, n + 1);
            }
            System.out.print(" } Out {");
            bits = block.out_bits;
            n = BitSet.nextSetBit(bits, 0);
            while (n >= 0) {
                System.out.print(" d" + n);
                n = BitSet.nextSetBit(bits, n + 1);
            }
            System.out.print(" }");
            System.out.print(block.stmts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printFlowGraph(Context cx, String scriptname, String methname) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(scriptname + "." + methname + ".dot"));
            out.write("\ndigraph cfg {");
            out.write("\nratio=fill");
            out.write("\nranksep=.25");
            out.write("\nnodesep=.2");
            out.write("\nrankdir=LR");
            out.write("\nedge [arrowsize=.7,labeldistance=1.0,labelangle=-45,labelfontsize=9]");
            out.write("\nnode [fontsize=9,shape=box,width=.2,height=.2]");
            for (int i = 0; i < this.blocks.size(); ++i) {
                out.write("\nB" + i + "[label=\"B" + i + "\"]");
                for (int j = 0; j < ((Block)this.blocks.get((int)i)).succs.size(); ++j) {
                    out.write("\nB" + i + " . B" + ((Block)this.blocks.get((int)i)).succs.get(j) + "[weight=2]");
                }
            }
            out.write("\n}");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void StartClass(String scriptname) {
    }

    public void FinishClass(Context cx, QName name, QName basename, boolean is_dynamic) {
    }

    @Override
    public void StartProgram(String scriptname) {
    }

    @Override
    public void FinishProgram(Context cx, String name, int unused) {
    }

    @Override
    public void StartMethod(String name, int param_count, int local_count, int temp_count, boolean needs_activation, int needs_arguments) {
        if (this.show_instructions) {
            System.out.print("\n// ++StartMethod " + name + ", " + param_count + ", " + local_count);
        }
        this.InitGraph();
        this.EnterBlock();
        this.AddEdge(this.cur_block - 1, this.cur_block);
        this.max_temp_count = 0;
        this.cur_temp_count = 0;
    }

    @Override
    public int FinishMethod(Context cx, String name, TypeInfo type, ObjectList<TypeInfo> types, ObjectValue activation, int needs_arguments, int scope_depth, String debug_name, boolean is_native, boolean is_interface, String[] arg_names) {
        if (this.show_instructions) {
            System.out.print("\n// --FinishMethod " + name);
        }
        if (!this.hasLeader) {
            this.blocks.removeLast();
            --this.cur_block;
        }
        this.calcGenAndKill(cx);
        this.calcInAndOut(cx);
        if (this.show_blocks) {
            System.out.print("\n" + name + ":");
            this.printBlocks(cx);
        }
        return 0;
    }

    public void MakeDispatchMethod(Context cx) {
    }

    @Override
    public int allocateTemp() {
        int temp = this.cur_temp_count++;
        if (this.cur_temp_count > this.max_temp_count) {
            this.max_temp_count = this.cur_temp_count;
        }
        return temp - 1;
    }

    @Override
    public void freeTemp(int t) {
        --this.cur_temp_count;
    }

    @Override
    public int getTempCount() {
        return this.max_temp_count;
    }

    public void stack(int size) {
        this.cur_stack += size;
        if (this.cur_stack > this.max_stack) {
            this.max_stack = this.cur_stack;
        }
    }

    public void saveStackDepth() {
        this.stackDepthStack.add(this.cur_stack);
    }

    public void restoreStackDepth() {
        this.cur_stack = this.stackDepthStack.removeLast();
    }

    @Override
    public int getIP() {
        return 0;
    }

    @Override
    public void Break(int loop_index) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" Break target " + loop_index);
        }
        if (loop_index >= 0 && loop_index < this.break_addrs.size()) {
            this.AddStmtToBlock("Break");
            ((IntList)this.break_addrs.get(loop_index)).add(this.cur_block);
        }
        this.EnterBlock();
    }

    @Override
    public void Continue(int loop_index) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" Continue " + loop_index);
        }
        if (loop_index >= 0 && loop_index < this.continue_addrs.size()) {
            this.AddStmtToBlock("Continue");
            ((IntList)this.continue_addrs.get(loop_index)).add(this.cur_block);
        }
        this.EnterBlock();
    }

    @Override
    public void CaseLabel(boolean is_default) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            if (is_default) {
                System.out.print(" CaseLabel default");
            } else {
                System.out.print(" CaseLabel");
            }
        }
        this.EnterBlock();
        if (this.case_addrs.last().size() != 0) {
            this.AddEdge(this.cur_block - 1, this.cur_block);
        }
        if (is_default) {
            if (this.seen_default_case.last() == 0) {
                this.default_addrs.add(this.cur_block);
                this.case_addrs.last().add(this.cur_block);
                this.seen_default_case.set(this.seen_default_case.size() - 1, 1);
            }
        } else {
            this.case_addrs.last().add(this.cur_block);
        }
    }

    @Override
    public void Try(boolean hasFinally) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" Try");
        }
        ++this.within_try_block;
        this.EnterBlock();
        this.AddEdge(this.cur_block - 1, this.cur_block);
        this.try_addrs.add(this.cur_block);
        this.catch_addrs.add(new IntList());
    }

    @Override
    public void CatchClausesBegin() {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" CatchClausesBegin");
        }
    }

    @Override
    public void Catch(TypeValue type, QName name) {
        this.EnterBlock();
        this.catch_addrs.last().add(this.cur_block);
    }

    @Override
    public void CatchClausesEnd() {
        int i;
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" CatchClausesEnd");
        }
        if (this.within_try_block > 0) {
            --this.within_try_block;
        }
        this.EnterBlock();
        IntList catch_list = this.catch_addrs.last();
        int try_start = this.try_addrs.last();
        int try_end = catch_list.at(0);
        for (i = try_start; i < try_end; ++i) {
            int n = catch_list.size();
            for (int j = 0; j < n; ++j) {
                this.AddEdge(i, catch_list.at(j));
            }
        }
        for (i = try_start; i < this.cur_block; ++i) {
            this.AddEdge(i, this.cur_block);
        }
    }

    @Override
    public void FinallyClauseEnd() {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" FinallyClauseEnd");
        }
        this.try_addrs.pop_back();
        this.catch_addrs.pop_back();
    }

    @Override
    public void Throw() {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" Throw");
        }
        if (this.within_try_block == 0) {
            this.AddStmtToBlock("Throw");
            this.EnterTerminalBlock();
        }
    }

    @Override
    public void SwitchTable() {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" SwitchTable");
        }
        this.AddStmtToBlock("SwitchTable");
        int default_addr = this.default_addrs.last();
        this.default_addrs.removeLast();
        this.AddEdge(this.cur_block, default_addr);
        IntList case_addr = this.case_addrs.removeLast();
        for (int case_index = 0; case_index < case_addr.size(); ++case_index) {
            this.AddEdge(this.cur_block, case_addr.get(case_index));
        }
        this.EnterBlock();
    }

    @Override
    public void If(int kind) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" If");
        }
        this.AddStmtToBlock("If");
        this.if_addrs.add(this.GetBlock());
        this.saveStackDepth();
        this.EnterBlock();
        this.AddEdge(this.cur_block - 1, this.cur_block);
    }

    @Override
    public void PatchIf(int target) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" PatchIf");
        }
        this.restoreStackDepth();
        int if_index = this.if_addrs.last();
        this.if_addrs.removeLast();
        this.EnterBlock();
        this.AddEdge(if_index, this.cur_block);
    }

    @Override
    public void Else() {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" Else");
        }
        this.else_addrs.add(this.GetBlock());
        this.EnterBlock();
    }

    @Override
    public void PatchBreak(int loop_index) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" PatchBreak " + loop_index);
        }
        IntList break_addr = this.break_addrs.removeLast();
        while (break_addr.size() != 0) {
            int break_index = break_addr.last();
            this.AddEdge(break_index, this.cur_block);
            break_addr.removeLast();
        }
    }

    @Override
    public void PatchContinue(int loop_index) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" PatchContinue " + loop_index);
        }
        IntList continue_addr = this.continue_addrs.removeLast();
        while (continue_addr.size() != 0) {
            int continue_index = continue_addr.last();
            this.AddEdge(continue_index, this.cur_block);
            continue_addr.removeLast();
        }
    }

    @Override
    public void PatchElse(int target) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" PatchElse");
        }
        int else_index = this.else_addrs.last();
        this.else_addrs.removeLast();
        this.EnterBlock();
        this.AddEdge(else_index, this.cur_block);
        this.AddEdge(this.cur_block - 1, this.cur_block);
    }

    @Override
    public void Return(int type_id) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" Return");
        }
        this.AddStmtToBlock("Return");
        if (this.within_try_block == 0) {
            this.EnterTerminalBlock();
        }
    }

    @Override
    public void LabelStatementBegin() {
        this.break_addrs.add(new IntList());
    }

    @Override
    public void LabelStatementEnd(int loop_index) {
        this.PatchBreak(loop_index);
    }

    @Override
    public void LoopBegin() {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" LoopBegin");
        }
        this.AddStmtToBlock("LoopBegin");
        this.break_addrs.add(new IntList());
        this.continue_addrs.add(new IntList());
        this.loopbegin_addrs.add(this.cur_block + 1);
        this.with_count.add(this.current_with_count);
        this.EnterBlock();
    }

    @Override
    public void LoopEnd(int kind) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" LoopEnd");
        }
        this.AddEdge(this.cur_block, this.loopbegin_addrs.last());
        this.EnterBlock();
        this.AddEdge(this.cur_block - 1, this.cur_block);
        this.loopbegin_addrs.removeLast();
        this.with_count.pop_back();
    }

    @Override
    public void PatchLoopBegin(int target) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" PatchLoopBegin " + target);
        }
        this.EnterBlock();
        this.AddEdge(this.cur_block - 1, this.cur_block);
        this.AddEdge(this.loopbegin_addrs.last() - 1, this.cur_block);
    }

    @Override
    public void PatchSwitchBegin(int addr) {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" PatchSwitchBegin " + addr);
        }
        int switchbegin_index = this.switchbegin_addrs.last();
        this.seen_default_case.removeLast();
        this.switchbegin_addrs.removeLast();
        this.EnterBlock();
        this.AddEdge(switchbegin_index, this.cur_block);
    }

    @Override
    public void SwitchBegin() {
        if (this.show_linenums) {
            int[] ln = new int[1];
            int[] col = new int[1];
            String[] name = new String[1];
            this.getOriginAndPosition(name, ln, col);
            System.out.print("\n[Ln " + ln[0] + "]");
        }
        if (this.show_instructions) {
            System.out.print(" SwitchBegin");
        }
        this.AddStmtToBlock("SwitchBegin");
        this.seen_default_case.add(0);
        this.case_addrs.add(new IntList());
        this.break_addrs.add(new IntList());
        this.continue_addrs.add(new IntList());
        this.switchbegin_addrs.add(this.GetBlock());
        this.EnterBlock();
    }

    public FlowGraphEmitter(Context cx, String scriptname, boolean show_blocks) {
        this.cx = cx;
        this.scriptname = scriptname;
        this.def_count = 0;
        this.cur_block = 0;
        this.hasLeader = true;
        this.show_instructions = false;
        this.show_linenums = false;
        this.show_blocks = show_blocks;
        this.within_try_block = 0;
        this.InitGraph();
        this.EnterBlock();
    }

    @Override
    public ByteList emit(ByteList bytes) {
        return bytes;
    }
}

